/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.data;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.nhn.android.idp.common.logger.Logger;
import com.nhn.android.naverlogin.data.OAuthErrorCode;

public class OAuthLoginPreferenceManager {
    private static final String TAG = "OAuthLoginPreferenceManager";
    private static final String OAUTH_LOGIN_PREF_NAME_PER_APP = "NaverOAuthLoginPreferenceData";
    private static Context mContext = null;
    private static SharedPreferences mPref = null;

    public OAuthLoginPreferenceManager(Context _context) {
        mContext = _context;
        if (mContext != null) {
            if (mPref == null) {
                mPref = mContext.getSharedPreferences(OAUTH_LOGIN_PREF_NAME_PER_APP, 0);
            }
        } else {
            Logger.e(TAG, "context is null!");
        }
    }

    public void setAccessToken(String aToken) {
        PREF_KEY.ACCESS_TOKEN.set(aToken);
    }

    public String getAccessToken() {
        String token = (String)PREF_KEY.ACCESS_TOKEN.get();
        if (TextUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        if (System.currentTimeMillis() / 1000L - this.getExpiresAt() < 0L) {
            return token;
        }
        Logger.i(TAG, "access token is expired.");
        return null;
    }

    public void setRefreshToken(String rToken) {
        PREF_KEY.REFRESH_TOKEN.set(rToken);
    }

    public String getRefreshToken() {
        return (String)PREF_KEY.REFRESH_TOKEN.get();
    }

    public void setExpiresAt(long expiresTimeStamp) {
        PREF_KEY.EXPIRES_AT.set(expiresTimeStamp);
    }

    public long getExpiresAt() {
        Long expires = (Long)PREF_KEY.EXPIRES_AT.get();
        if (expires == null) {
            return 0L;
        }
        return expires;
    }

    public void setClientId(String clientId) {
        PREF_KEY.CLIENT_ID.set(clientId);
    }

    public String getClientId() {
        return (String)PREF_KEY.CLIENT_ID.get();
    }

    public void setClientSecret(String clientSecret) {
        PREF_KEY.CLIENT_SECRET.set(clientSecret);
    }

    public String getClientSecret() {
        return (String)PREF_KEY.CLIENT_SECRET.get();
    }

    public void setClientName(String clientName) {
        PREF_KEY.CLIENT_NAME.set(clientName);
    }

    public String getClientName() {
        return (String)PREF_KEY.CLIENT_NAME.get();
    }

    public void setCallbackUrl(String callbackUrl) {
        PREF_KEY.CALLBACK_URL.set(callbackUrl);
    }

    public String getCallbackUrl() {
        return (String)PREF_KEY.CALLBACK_URL.get();
    }

    public void setTokenType(String tokenType) {
        PREF_KEY.TOKEN_TYPE.set(tokenType);
    }

    public String getTokenType() {
        return (String)PREF_KEY.TOKEN_TYPE.get();
    }

    public void setLastErrorCode(OAuthErrorCode errorCode) {
        PREF_KEY.LAST_ERROR_CODE.set(errorCode.getCode());
    }

    public OAuthErrorCode getLastErrorCode() {
        String code = (String)PREF_KEY.LAST_ERROR_CODE.get();
        return OAuthErrorCode.fromString(code);
    }

    public void setLastErrorDesc(String errorDesc) {
        PREF_KEY.LAST_ERROR_DESC.set(errorDesc);
    }

    public String getLastErrorDesc() {
        return (String)PREF_KEY.LAST_ERROR_DESC.get();
    }

    protected static enum PREF_KEY {
        ACCESS_TOKEN("ACCESS_TOKEN", String.class),
        REFRESH_TOKEN("REFRESH_TOKEN", String.class),
        EXPIRES_AT("EXPIRES_AT", Long.TYPE),
        TOKEN_TYPE("TOKEN_TYPE", String.class),
        CLIENT_ID("CLIENT_ID", String.class),
        CLIENT_SECRET("CLIENT_SECRET", String.class),
        CLIENT_NAME("CLIENT_NAME", String.class),
        CALLBACK_URL("CALLBACK_URL", String.class),
        LAST_ERROR_CODE("LAST_ERROR_CODE", String.class),
        LAST_ERROR_DESC("LAST_ERROR_DESC", String.class);

        private String key;
        private String type;

        private PREF_KEY(String key, Class type) {
            this.key = key;
            this.type = type.getCanonicalName();
        }

        public String getValue() {
            return this.key;
        }

        public boolean set(Object data) {
            SharedPreferences pref = mPref;
            boolean res = false;
            for (int cnt = 0; !res && cnt < 3; ++cnt) {
                if (cnt > 0) {
                    Logger.e(OAuthLoginPreferenceManager.TAG, "preference set() fail (cnt:" + cnt + ")");
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                res = this.setSub(pref, data);
            }
            return res;
        }

        private boolean setSub(SharedPreferences pref, Object data) {
            if (pref == null) {
                return false;
            }
            SharedPreferences.Editor editor = pref.edit();
            if (editor == null) {
                return false;
            }
            try {
                if (this.type.equals(Integer.TYPE.getCanonicalName())) {
                    editor.putInt(this.key, ((Integer)data).intValue());
                } else if (this.type.equals(Long.TYPE.getCanonicalName())) {
                    editor.putLong(this.key, ((Long)data).longValue());
                } else if (this.type.equals(String.class.getCanonicalName())) {
                    editor.putString(this.key, (String)data);
                } else if (this.type.equals(Boolean.TYPE.getCanonicalName())) {
                    editor.putBoolean(this.key, ((Boolean)data).booleanValue());
                }
                return editor.commit();
            }
            catch (Exception e) {
                Logger.e(OAuthLoginPreferenceManager.TAG, "Prefernce Set() fail, key:" + this.key + ", type:" + this.type + "e:" + e.getMessage());
                return false;
            }
        }

        public boolean del() {
            return this.delSub(mPref);
        }

        private boolean delSub(SharedPreferences pref) {
            if (pref == null) {
                return false;
            }
            SharedPreferences.Editor editor = pref.edit();
            if (editor == null) {
                return false;
            }
            try {
                editor.remove(this.type);
                return editor.commit();
            }
            catch (Exception e) {
                Logger.e(OAuthLoginPreferenceManager.TAG, "Prefernce del() fail, key:" + this.key + ", type:" + this.type + "e:" + e.getMessage());
                return false;
            }
        }

        public Object get() {
            try {
                return this.getSub(mPref);
            }
            catch (Exception e) {
                Logger.e(OAuthLoginPreferenceManager.TAG, "get() fail, e:" + e.getMessage());
                return null;
            }
        }

        private Object getSub(SharedPreferences pref) {
            Object data = null;
            try {
                if (this.type.equals(Integer.TYPE.getCanonicalName())) {
                    data = pref.getInt(this.key, 0);
                } else if (this.type.equals(Long.TYPE.getCanonicalName())) {
                    data = pref.getLong(this.key, 0L);
                } else if (this.type.equals(String.class.getCanonicalName())) {
                    data = pref.getString(this.key, "");
                } else if (this.type.equals(Boolean.TYPE.getCanonicalName())) {
                    data = pref.getBoolean(this.key, true);
                }
            }
            catch (Exception e) {
                Logger.e(OAuthLoginPreferenceManager.TAG, "get(), key:" + this.key + ", pref:" + (pref == null ? "null" : "ok"));
            }
            return data;
        }
    }
}

