/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.connection;

import android.content.Context;
import com.navercorp.naverid.internal.log.Logger;
import com.nhn.android.idp.common.connection.CommonConnection;
import com.nhn.android.idp.common.connection.ResponseData;
import com.nhn.android.idp.common.util.DeviceAppInfo;
import com.nhn.android.naverlogin.connection.gen.OAuthQueryGenerator;
import com.nhn.android.naverlogin.data.OAuthErrorCode;
import com.nhn.android.naverlogin.data.OAuthResponse;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class OAuthLoginConnection
extends CommonConnection {
    private static final String TAG = "OAuthLoginConnection";

    public static OAuthResponse requestAccessToken(Context context, String clientId, String clientSecret, String initState, String code) {
        String locale = DeviceAppInfo.getBaseInstance().getLocaleString(context);
        String requestUrl = new OAuthQueryGenerator().generateRequestAccessTokenUrl(clientId, clientSecret, initState, code, locale, "4.3.2");
        return OAuthLoginConnection.request(context, requestUrl);
    }

    public static OAuthResponse requestRefreshToken(Context context, String clientId, String clientSecret, String refreshToken) {
        String locale = DeviceAppInfo.getBaseInstance().getLocaleString(context);
        String requestUrl = new OAuthQueryGenerator().generateRequestRefreshAccessTokenUrl(clientId, clientSecret, refreshToken, locale, "4.3.2");
        return OAuthLoginConnection.request(context, requestUrl);
    }

    public static OAuthResponse deleteToken(Context context, String clientId, String clientSecret, String accessToken) {
        String locale = DeviceAppInfo.getBaseInstance().getLocaleString(context);
        String requestUrl = new OAuthQueryGenerator().generateRequestDeleteAccessTokenUrl(clientId, clientSecret, accessToken, locale, "4.3.2");
        return OAuthLoginConnection.request(context, requestUrl);
    }

    private static OAuthResponse request(Context context, String requestUrl) {
        ResponseData data = CommonConnection.request(context, requestUrl, null, null);
        if (!data.stat.equals((Object)ResponseData.ResponseDataStat.SUCCESS)) {
            if (data.statusCode == 503) {
                return new OAuthResponse(OAuthErrorCode.SERVER_ERROR_TEMPORARILY_UNAVAILABLE);
            }
            if (data.statusCode == 500) {
                return new OAuthResponse(OAuthErrorCode.SERVER_ERROR_SERVER_ERROR);
            }
            if (data.stat.equals((Object)ResponseData.ResponseDataStat.CONNECTION_TIMEOUT) || data.stat.equals((Object)ResponseData.ResponseDataStat.CONNECTION_FAIL)) {
                return new OAuthResponse(OAuthErrorCode.CLIENT_ERROR_CONNECTION_ERROR);
            }
            if (data.stat.equals((Object)ResponseData.ResponseDataStat.NO_PEER_CERTIFICATE)) {
                return new OAuthResponse(OAuthErrorCode.CLIENT_ERROR_CERTIFICATION_ERROR);
            }
            return new OAuthResponse(OAuthErrorCode.ERROR_NO_CATAGORIZED);
        }
        try {
            JSONObject jsonObj = new JSONObject(data.content);
            Logger.d(TAG, "len :" + jsonObj.length());
            Logger.d(TAG, "str :" + jsonObj.toString());
            Iterator it = jsonObj.keys();
            HashMap<String, String> ret = new HashMap<String, String>();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = jsonObj.getString(key);
                ret.put(key, value);
                Logger.d(TAG, "key:" + key + ",value:" + value);
            }
            return new OAuthResponse(ret);
        }
        catch (JSONException e) {
            if (null != data) {
                Logger.d(TAG, "content:" + data.content);
            }
            e.printStackTrace();
            return new OAuthResponse(OAuthErrorCode.CLIENT_ERROR_PARSING_FAIL);
        }
    }

    public static ResponseData requestWithOAuthHeader(Context context, String requestUrl, String cookie, String userAgent, String authHeader) {
        ResponseData data = CommonConnection.request(context, requestUrl, null, null, authHeader, false);
        return data;
    }
}

