/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.webkit.CookieSyncManager;
import com.navercorp.naverid.internal.log.Logger;
import com.nhn.android.idp.common.connection.CommonConnection;
import com.nhn.android.idp.common.connection.NetworkState;
import com.nhn.android.idp.common.connection.ResponseData;
import com.nhn.android.idp.common.util.DeviceAppInfo;
import com.nhn.android.naverlogin.OAuthLoginDefine;
import com.nhn.android.naverlogin.OAuthLoginHandler;
import com.nhn.android.naverlogin.connection.OAuthLoginConnection;
import com.nhn.android.naverlogin.data.OAuthErrorCode;
import com.nhn.android.naverlogin.data.OAuthLoginPreferenceManager;
import com.nhn.android.naverlogin.data.OAuthLoginState;
import com.nhn.android.naverlogin.data.OAuthResponse;
import com.nhn.android.naverlogin.ui.OAuthLoginActivity;
import com.nhn.android.naverlogin.ui.OAuthLoginDialogManager;
import com.nhn.android.oauth.R;

public class OAuthLogin {
    private static final String TAG = "OAuthLogin";
    private static OAuthLogin instance;
    public static OAuthLoginHandler oauthLoginHandler;

    public static OAuthLogin getInstance() {
        if (instance == null) {
            instance = new OAuthLogin();
        }
        return instance;
    }

    private OAuthLogin() {
    }

    public void init(Context context, String clientId, String clientSecret, String clientName) {
        String packageName = DeviceAppInfo.getPackageName(context);
        OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(context);
        prefMng.setClientId(clientId);
        prefMng.setClientSecret(clientSecret);
        prefMng.setClientName(clientName);
        prefMng.setCallbackUrl(packageName);
        prefMng.setLastErrorCode(OAuthErrorCode.NONE);
        prefMng.setLastErrorDesc("");
        Logger.setPrefix("NaverIdLogin|" + packageName + "|");
        CookieSyncManager.createInstance((Context)context);
    }

    @Deprecated
    public void init(Context context, String clientId, String clientSecret, String clientName, String callbackIntent) {
        this.init(context, clientId, clientSecret, clientName);
    }

    public void showDevelopersLog(boolean show) {
        Logger.setForceLogging(show);
    }

    private boolean valid(Context context) {
        if (null == context) {
            Logger.i(TAG, "context is null");
            return false;
        }
        OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(context);
        if (TextUtils.isEmpty((CharSequence)prefMng.getClientId())) {
            Logger.i(TAG, "CliendId is null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)prefMng.getClientSecret())) {
            Logger.i(TAG, "CliendSecret is null");
            return false;
        }
        return true;
    }

    public static String getVersion() {
        return "4.3.2";
    }

    public OAuthLoginState getState(Context context) {
        if (!this.valid(context)) {
            return OAuthLoginState.NEED_INIT;
        }
        OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(context);
        String at = prefMng.getAccessToken();
        String rt = prefMng.getRefreshToken();
        if (TextUtils.isEmpty((CharSequence)at)) {
            if (TextUtils.isEmpty((CharSequence)rt)) {
                return OAuthLoginState.NEED_LOGIN;
            }
            return OAuthLoginState.NEED_REFRESH_TOKEN;
        }
        return OAuthLoginState.OK;
    }

    public void initializeLoginFlag() {
        this.disableNaverAppLoginOnly();
        this.disableCustomTabLoginOnly();
        this.disableWebViewLoginOnly();
    }

    public void enableNaverAppLoginOnly() {
        OAuthLoginDefine.LOGIN_BY_NAVERAPP_ONLY = true;
        this.disableCustomTabLoginOnly();
        this.disableWebViewLoginOnly();
    }

    public void enableCustomTabLoginOnly() {
        this.disableNaverAppLoginOnly();
        OAuthLoginDefine.LOGIN_BY_CUSTOM_TAB_ONLY = true;
        this.disableWebViewLoginOnly();
    }

    public void enableWebViewLoginOnly() {
        this.disableNaverAppLoginOnly();
        this.disableCustomTabLoginOnly();
        OAuthLoginDefine.LOGIN_BY_WEBVIEW_ONLY = true;
    }

    public void disableNaverAppLoginOnly() {
        OAuthLoginDefine.LOGIN_BY_NAVERAPP_ONLY = false;
    }

    public void disableCustomTabLoginOnly() {
        OAuthLoginDefine.LOGIN_BY_CUSTOM_TAB_ONLY = false;
    }

    public void disableWebViewLoginOnly() {
        OAuthLoginDefine.LOGIN_BY_WEBVIEW_ONLY = false;
    }

    public void setCustomTabReAuth(boolean value) {
        OAuthLoginDefine.CUSTOM_TAB_REQUIRED_RE_AUTH = value;
    }

    public void setMarketLinkWorking(boolean set) {
        OAuthLoginDefine.MARKET_LINK_WORKING = set;
    }

    public void setShowingBottomTab(boolean set) {
        OAuthLoginDefine.BOTTOM_TAB_WORKING = set;
    }

    public void startOauthLoginActivity(final Activity activity, final OAuthLoginHandler oauthLoginHandler) {
        boolean checkConnectivity = NetworkState.checkConnectivity((Context)activity, true, new NetworkState.RetryListener(){

            @Override
            public void onResult(boolean retry) {
                if (retry) {
                    OAuthLogin.this.startOauthLoginActivity(activity, oauthLoginHandler);
                }
            }
        });
        if (checkConnectivity) {
            OAuthLogin.oauthLoginHandler = oauthLoginHandler;
            String rt = this.getRefreshToken((Context)activity);
            if (!TextUtils.isEmpty((CharSequence)rt)) {
                new OAuthLoginTask((Context)activity).execute(new Void[0]);
            } else {
                Intent intent = new Intent((Context)activity, OAuthLoginActivity.class);
                activity.startActivity(intent);
            }
        }
    }

    public String refreshAccessToken(Context context) {
        String refreshToken;
        String clientSecret;
        OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(context);
        String clientId = prefMng.getClientId();
        OAuthResponse res = OAuthLoginConnection.requestRefreshToken(context, clientId, clientSecret = prefMng.getClientSecret(), refreshToken = prefMng.getRefreshToken());
        String at = res.getAccessToken();
        if (TextUtils.isEmpty((CharSequence)at)) {
            return null;
        }
        prefMng.setAccessToken(res.getAccessToken());
        prefMng.setExpiresAt(System.currentTimeMillis() / 1000L + res.getExpiresIn());
        return at;
    }

    public String getAccessToken(Context context) {
        OAuthLoginPreferenceManager pref = new OAuthLoginPreferenceManager(context);
        String at = pref.getAccessToken();
        if (TextUtils.isEmpty((CharSequence)at)) {
            return null;
        }
        return at;
    }

    public String getRefreshToken(Context context) {
        OAuthLoginPreferenceManager pref = new OAuthLoginPreferenceManager(context);
        String rt = pref.getRefreshToken();
        if (TextUtils.isEmpty((CharSequence)rt)) {
            return null;
        }
        return rt;
    }

    public long getExpiresAt(Context context) {
        OAuthLoginPreferenceManager pref = new OAuthLoginPreferenceManager(context);
        long expiresAt = pref.getExpiresAt();
        return expiresAt;
    }

    public String getTokenType(Context context) {
        OAuthLoginPreferenceManager pref = new OAuthLoginPreferenceManager(context);
        String tokenType = pref.getTokenType();
        if (TextUtils.isEmpty((CharSequence)tokenType)) {
            return null;
        }
        return tokenType;
    }

    public OAuthErrorCode getLastErrorCode(Context context) {
        OAuthLoginPreferenceManager pref = new OAuthLoginPreferenceManager(context);
        return pref.getLastErrorCode();
    }

    public String getLastErrorDesc(Context context) {
        OAuthLoginPreferenceManager pref = new OAuthLoginPreferenceManager(context);
        return pref.getLastErrorDesc();
    }

    public String requestApi(Context context, String accessToken, String url) {
        String authHeader = "bearer " + accessToken;
        Logger.d(TAG, "at:" + accessToken + ", url:" + url);
        Logger.d(TAG, "header:" + authHeader);
        ResponseData res = CommonConnection.request(context, url, null, null, authHeader);
        Logger.d(TAG, "res.statuscode" + res.statusCode);
        Logger.d(TAG, "res.content" + res.content);
        if (res == null) {
            return null;
        }
        return res.content;
    }

    public boolean logoutAndDeleteToken(Context context) {
        OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(context);
        String clientId = prefMng.getClientId();
        String clientSecret = prefMng.getClientSecret();
        String accessToken = prefMng.getAccessToken();
        this.logout(context);
        OAuthResponse res = null;
        try {
            res = OAuthLoginConnection.deleteToken(context, clientId, clientSecret, accessToken);
            if ("success".equalsIgnoreCase(res.getResultValue())) {
                return true;
            }
            prefMng.setLastErrorCode(res.getErrorCode());
            prefMng.setLastErrorDesc(res.getErrorDescription());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            prefMng.setLastErrorCode(OAuthErrorCode.ERROR_NO_CATAGORIZED);
            prefMng.setLastErrorDesc(e.getMessage());
            return false;
        }
    }

    public void logout(Context context) {
        OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(context);
        prefMng.setAccessToken("");
        prefMng.setRefreshToken("");
        prefMng.setLastErrorCode(OAuthErrorCode.NONE);
        prefMng.setLastErrorDesc("");
    }

    private class OAuthLoginTask
    extends AsyncTask<Void, Void, String> {
        private Context _context;
        private OAuthLoginDialogManager mDialogMng = new OAuthLoginDialogManager();

        OAuthLoginTask(Context context) {
            this._context = context;
        }

        protected void onPreExecute() {
            this.mDialogMng.showProgressDlg(this._context, this._context.getString(R.string.naveroauthlogin_string_getting_token), null);
        }

        protected String doInBackground(Void ... params) {
            return OAuthLogin.this.refreshAccessToken(this._context);
        }

        protected void onPostExecute(String at) {
            try {
                this.mDialogMng.hideProgressDlg();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (TextUtils.isEmpty((CharSequence)at)) {
                Intent intent = new Intent(this._context, OAuthLoginActivity.class);
                this._context.startActivity(intent);
            } else {
                oauthLoginHandler.run(true);
            }
        }
    }

    class OAuthNaverAppInstallMethod {
        static final int TYPE_UPDATE = 144;
        static final int TYPE_INSTALL = 145;

        OAuthNaverAppInstallMethod() {
        }
    }
}

