/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.idp.common.connection;

import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ResponseData {
    private final String TAG = "ResponseData";
    public ResponseDataStat stat = ResponseDataStat.SUCCESS;
    public int statusCode = -1;
    public String content = "";
    public String errorDetail = "";
    public List<String> cookieList = new ArrayList<String>();
    public String xmlEncoding = "utf-8";

    public void setResultCode(ResponseDataStat stat, String msg) {
        this.stat = stat;
        this.errorDetail = msg;
    }

    public void setResponseData(int statusCode, String contentType, InputStream responseContent, List<String> cookieList) {
        this.statusCode = statusCode;
        if (cookieList != null) {
            this.cookieList = cookieList;
        }
        try {
            this.xmlEncoding = contentType;
            this.content = this.getContent(responseContent, this.xmlEncoding);
        }
        catch (IllegalStateException e) {
            this.setResultCode(ResponseDataStat.EXCEPTION_FAIL, "setResponseData()-IllegalStateException:" + e.getMessage());
        }
        catch (Exception e) {
            this.setResultCode(ResponseDataStat.EXCEPTION_FAIL, "setResponseData()-Exception:" + e.getMessage());
        }
    }

    private String getContent(InputStream is, String encodeType) {
        BufferedReader reader;
        int bufferSize = 1024;
        char[] readString = new char[1024];
        try {
            reader = new BufferedReader(new InputStreamReader(is, encodeType));
        }
        catch (UnsupportedEncodingException e1) {
            reader = new BufferedReader(new InputStreamReader(is));
        }
        StringBuilder buf = new StringBuilder();
        try {
            int read;
            while ((read = reader.read(readString, 0, 1024)) > 0) {
                buf.append(readString, 0, read);
            }
            reader.close();
        }
        catch (IOException e) {
            this.setResultCode(ResponseDataStat.EXCEPTION_FAIL, "getContent()-IOException:" + e.getMessage());
        }
        catch (RuntimeException e) {
            this.setResultCode(ResponseDataStat.EXCEPTION_FAIL, "getContent()-RuntimeException:" + e.getMessage());
        }
        return buf.toString();
    }

    public String toString() {
        return "Statuscode:" + this.statusCode + ", Content:" + this.content + ", Cookie:" + TextUtils.join((CharSequence)"|", this.cookieList) + ", ErrorDetail:" + this.errorDetail;
    }

    public static enum ResponseDataStat {
        SUCCESS("SUCCESS", null),
        BUSY("BUSY", "BUSY"),
        CANCEL("CANCEL", "CANCEL"),
        URL_ERROR("URL_ERROR", "URL_ERROR"),
        CONNECTION_TIMEOUT("CONNECTION_TIMEOUT", "CONNECTION_TIMEOUT"),
        CONNECTION_FAIL("CONNECTION_FAIL", "CONNECTION_FAIL"),
        EXCEPTION_FAIL("EXCEPTION_FAIL", "EXCEPTION_FAIL"),
        NO_PEER_CERTIFICATE("NO_PEER_CERTIFICATE", "NO_PEER_CERTIFICATE"),
        FAIL("FAIL", "FAIL");

        private String stat;

        private ResponseDataStat(String str, String errMsg) {
            this.stat = str;
        }

        public String getValue() {
            return this.stat;
        }
    }
}

