/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.idp.common.connection;

import android.content.Context;
import com.navercorp.naverid.internal.log.Logger;
import com.nhn.android.idp.common.connection.ResponseData;
import com.nhn.android.idp.common.util.CookieUtil;
import com.nhn.android.idp.common.util.DeviceAppInfo;
import com.nhn.android.idp.common.util.HttpConnectionUtil;
import com.nhn.android.naverlogin.OAuthLoginDefine;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;

public class CommonConnection {
    private static final String TAG = "CommonConnection";
    protected static HttpURLConnection mHttpUrlConnection = null;
    protected static boolean mCancel;

    public static ResponseData request(Context context, String strRequestUrl, String cookies, String userAgent) {
        return CommonConnection.request(context, strRequestUrl, cookies, userAgent, false);
    }

    public static ResponseData request(Context context, String strRequestUrl, String cookies, String userAgent, String authHeader) {
        return CommonConnection.request(context, strRequestUrl, cookies, userAgent, authHeader, false, OAuthLoginDefine.TIMEOUT);
    }

    public static ResponseData request(Context context, String strRequestUrl, String cookies, String userAgent, boolean httpClientIsolated) {
        return CommonConnection.request(context, strRequestUrl, cookies, userAgent, null, httpClientIsolated, OAuthLoginDefine.TIMEOUT);
    }

    public static ResponseData request(Context context, String strRequestUrl, String cookies, String userAgent, String authHeader, boolean httpClientIsolated) {
        return CommonConnection.request(context, strRequestUrl, cookies, userAgent, authHeader, httpClientIsolated, OAuthLoginDefine.TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseData request(Context context, String strRequestUrl, String cookies, String userAgent, String authHeader, boolean httpClientIsolated, int timeout) {
        ResponseData res = new ResponseData();
        ArrayList<String> postCookies = new ArrayList();
        HttpsURLConnection httpClient = null;
        Class<CommonConnection> clazz = CommonConnection.class;
        synchronized (CommonConnection.class) {
            block44: {
                if (!httpClientIsolated && mHttpUrlConnection != null) {
                    res.setResultCode(ResponseData.ResponseDataStat.BUSY, "HttpClient already in use.");
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                    return res;
                }
                Logger.d(TAG, "request url : " + strRequestUrl);
                if (strRequestUrl == null || strRequestUrl.length() == 0) {
                    res.setResultCode(ResponseData.ResponseDataStat.URL_ERROR, "strRequestUrl is null");
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                    return res;
                }
                try {
                    if (httpClientIsolated) {
                        httpClient = userAgent != null && userAgent.length() > 0 ? CommonConnection.getDefaultHttpsConnection("GET", strRequestUrl, userAgent, timeout) : CommonConnection.getDefaultHttpsConnection("GET", strRequestUrl, context, timeout);
                    } else {
                        mHttpUrlConnection = userAgent != null && userAgent.length() > 0 ? CommonConnection.getDefaultHttpsConnection("GET", strRequestUrl, userAgent, timeout) : CommonConnection.getDefaultHttpsConnection("GET", strRequestUrl, context, timeout);
                    }
                }
                catch (MalformedURLException e) {
                    res.setResultCode(ResponseData.ResponseDataStat.URL_ERROR, "malformedUrl : " + e.getMessage());
                    e.printStackTrace();
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                    return res;
                }
                catch (IOException e) {
                    res.setResultCode(ResponseData.ResponseDataStat.CONNECTION_FAIL, "connection open fail : " + e.getMessage());
                    e.printStackTrace();
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                    return res;
                }
                catch (Exception e) {
                    res.setResultCode(ResponseData.ResponseDataStat.EXCEPTION_FAIL, "unknown fail : " + e.getMessage());
                    Logger.e(TAG, "exception step : connection establishing");
                    e.printStackTrace();
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                    return res;
                }
                mCancel = false;
                // ** MonitorExit[var10_10] (shouldn't be in output)
                if (cookies == null || cookies.length() == 0) {
                    cookies = CookieUtil.getAllNidCookie();
                    Logger.d(TAG, "request() --- request with naverCookie!");
                    Logger.d(TAG, "request() --- " + cookies);
                } else {
                    Logger.d(TAG, "request() --- request with user Cookie!");
                    Logger.d(TAG, "request() --- " + cookies);
                }
                try {
                    int responseCode;
                    if (httpClientIsolated) {
                        if (null != cookies && cookies.length() > 0) {
                            httpClient.setRequestProperty("Cookie", cookies);
                        }
                        if (null != authHeader && authHeader.length() > 0) {
                            httpClient.setRequestProperty("Authorization", authHeader);
                        }
                        responseCode = httpClient.getResponseCode();
                        Logger.i(TAG, "response status code:" + responseCode);
                        postCookies = CookieUtil.getCookieUpperSDK23(httpClient.getHeaderFields());
                        String contentType = HttpConnectionUtil.getCharsetFromContentTypeHeader(httpClient.getHeaderFields());
                        InputStream in = null;
                        try {
                            in = httpClient.getInputStream();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            in = httpClient.getErrorStream();
                        }
                        res.setResponseData(responseCode, contentType, in, postCookies);
                        break block44;
                    }
                    if (null != cookies && cookies.length() > 0) {
                        mHttpUrlConnection.setRequestProperty("Cookie", cookies);
                    }
                    if (null != authHeader && authHeader.length() > 0) {
                        mHttpUrlConnection.setRequestProperty("Authorization", authHeader);
                    }
                    responseCode = mHttpUrlConnection.getResponseCode();
                    Logger.i(TAG, "response status code:" + responseCode);
                    postCookies = CookieUtil.getCookieUpperSDK23(mHttpUrlConnection.getHeaderFields());
                    String contentType = HttpConnectionUtil.getCharsetFromContentTypeHeader(mHttpUrlConnection.getHeaderFields());
                    InputStream in = null;
                    try {
                        in = mHttpUrlConnection.getInputStream();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        in = mHttpUrlConnection.getErrorStream();
                    }
                    res.setResponseData(responseCode, contentType, in, postCookies);
                }
                catch (SSLPeerUnverifiedException e) {
                    res.setResultCode(ResponseData.ResponseDataStat.NO_PEER_CERTIFICATE, "SSLPeerUnverifiedException : " + e.getMessage());
                    e.printStackTrace();
                }
                catch (SSLProtocolException e) {
                    res.setResultCode(ResponseData.ResponseDataStat.NO_PEER_CERTIFICATE, "SSLProtocolException : " + e.getMessage());
                    e.printStackTrace();
                }
                catch (SSLKeyException e) {
                    res.setResultCode(ResponseData.ResponseDataStat.NO_PEER_CERTIFICATE, "SSLKeyException : " + e.getMessage());
                    e.printStackTrace();
                }
                catch (SSLHandshakeException e) {
                    res.setResultCode(ResponseData.ResponseDataStat.NO_PEER_CERTIFICATE, "SSLHandshakeException : " + e.getMessage());
                    e.printStackTrace();
                }
                catch (SSLException e) {
                    res.setResultCode(ResponseData.ResponseDataStat.NO_PEER_CERTIFICATE, "SSLException : " + e.getMessage());
                    e.printStackTrace();
                }
                catch (SocketTimeoutException e) {
                    res.setResultCode(ResponseData.ResponseDataStat.CONNECTION_TIMEOUT, "SocketTimeoutException : " + e.getMessage());
                    e.printStackTrace();
                }
                catch (SocketException e) {
                    res.setResultCode(ResponseData.ResponseDataStat.CONNECTION_FAIL, "SocketException : " + e.getMessage());
                    e.printStackTrace();
                }
                catch (IOException e) {
                    res.setResultCode(ResponseData.ResponseDataStat.EXCEPTION_FAIL, "IOException : " + e.getMessage());
                    e.printStackTrace();
                }
                catch (Exception e) {
                    res.setResultCode(ResponseData.ResponseDataStat.EXCEPTION_FAIL, "Exception : " + e.getMessage());
                    e.printStackTrace();
                }
            }
            try {
                if (httpClientIsolated) {
                    httpClient.disconnect();
                } else {
                    mHttpUrlConnection.disconnect();
                }
            }
            catch (Exception e) {
                Logger.e(TAG, e);
            }
            finally {
                if (httpClientIsolated) {
                    httpClient = null;
                } else {
                    mHttpUrlConnection = null;
                }
            }
            if (mCancel) {
                ResponseData cc = new ResponseData();
                cc.setResultCode(ResponseData.ResponseDataStat.CANCEL, "User cancel");
                return cc;
            }
            try {
                CookieUtil.setCookie(strRequestUrl, postCookies);
            }
            catch (Exception e) {
                res.setResultCode(ResponseData.ResponseDataStat.FAIL, "setCookie() failed :" + e.getMessage());
                Logger.e(TAG, e);
            }
            return res;
        }
    }

    public static HttpsURLConnection getDefaultHttpsConnection(String method, String url, Context context, int timeout) throws MalformedURLException, IOException {
        String useragent = DeviceAppInfo.getUserAgent(context);
        return CommonConnection.getDefaultHttpsConnection(method, url, useragent, timeout);
    }

    private static HttpsURLConnection getDefaultHttpsConnection(String method, String url, String userAgent, int timeout) throws MalformedURLException, IOException {
        return (HttpsURLConnection)CommonConnection.getDefaultHttpConnection(method, url, userAgent, timeout);
    }

    public static HttpURLConnection getDefaultHttpConnection(String method, String url, Context context, int timeout) throws MalformedURLException, IOException {
        String useragent = DeviceAppInfo.getUserAgent(context);
        return CommonConnection.getDefaultHttpConnection(method, url, useragent, timeout);
    }

    private static HttpURLConnection getDefaultHttpConnection(String method, String url, String userAgent, int timeout) throws MalformedURLException, IOException {
        HttpURLConnection urlConn = (HttpURLConnection)new URL(url).openConnection();
        urlConn.setDefaultUseCaches(false);
        urlConn.setUseCaches(false);
        urlConn.setRequestMethod(method);
        urlConn.setRequestProperty("User-Agent", userAgent);
        urlConn.setReadTimeout(timeout);
        urlConn.setConnectTimeout(timeout);
        urlConn.setDoInput(true);
        if ("GET".equalsIgnoreCase(method)) {
            urlConn.setDoOutput(false);
        } else {
            urlConn.setDoOutput(true);
        }
        return urlConn;
    }

    public static boolean isBusy() {
        return mHttpUrlConnection != null;
    }

    public static void cancel() {
        mCancel = true;
        if (mHttpUrlConnection != null) {
            Logger.e(TAG, "cancel() https-connection shutdown");
            mHttpUrlConnection.disconnect();
            mHttpUrlConnection = null;
        }
    }
}

