/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.naverid.internal.log;

import com.navercorp.naverid.internal.log.DebugLogger;
import com.navercorp.naverid.internal.log.ILogger;
import com.navercorp.naverid.internal.log.RealLogger;

public class Logger {
    private static ILogger instance = null;

    private Logger() {
    }

    public static synchronized ILogger getInstance() {
        if (instance == null) {
            instance = "release".equalsIgnoreCase("debug") ? new DebugLogger() : new RealLogger();
        }
        return instance;
    }

    public static void setPrefix(String prefix) {
        Logger.getInstance().setPrefix(prefix);
    }

    public static void setForceLogging(boolean isForceLogging) {
        instance = isForceLogging ? new DebugLogger() : new RealLogger();
    }

    public static void v(String tag, String message) {
        Logger.getInstance().v(tag, message);
    }

    public static void d(String tag, String message) {
        Logger.getInstance().d(tag, message);
    }

    public static void i(String tag, String message) {
        Logger.getInstance().v(tag, message);
    }

    public static void w(String tag, String message) {
        Logger.getInstance().w(tag, message);
    }

    public static void e(String tag, String message) {
        Logger.getInstance().e(tag, message);
    }

    public static void wtf(String tag, String message) {
        Logger.getInstance().wtf(tag, message);
    }

    private static String getExceptionMessage(Exception e) {
        if (e == null) {
            return "Unknown Exception!";
        }
        return e.getLocalizedMessage();
    }

    public static void v(String tag, Exception e) {
        Logger.getInstance().v(tag, Logger.getExceptionMessage(e));
    }

    public static void d(String tag, Exception e) {
        Logger.getInstance().d(tag, Logger.getExceptionMessage(e));
    }

    public static void i(String tag, Exception e) {
        Logger.getInstance().v(tag, Logger.getExceptionMessage(e));
    }

    public static void w(String tag, Exception e) {
        Logger.getInstance().w(tag, Logger.getExceptionMessage(e));
    }

    public static void e(String tag, Exception e) {
        Logger.getInstance().e(tag, Logger.getExceptionMessage(e));
    }

    public static void wtf(String tag, Exception e) {
        Logger.getInstance().wtf(tag, Logger.getExceptionMessage(e));
    }
}

