/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.data;

import android.text.TextUtils;
import com.nhn.android.idp.common.logger.Logger;
import com.nhn.android.naverlogin.data.OAuthErrorCode;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.SecureRandom;

public class OAuthLoginData {
    private static final String TAG = "OAuthLoginData";
    private String mInOAuthClientId;
    private String mInOAuthClientSecret;
    private String mInOAuthCallback;
    private String mInOAuthState;
    private String mOAuthState;
    private String mOAuthCode;
    private OAuthErrorCode mOAuthErrorCode;
    private String mOAuthErrorDesc;

    public OAuthLoginData(String clientId, String clientSecret, String callbackUrl) {
        this.init(clientId, clientSecret, callbackUrl, null);
    }

    public OAuthLoginData(String clientId, String clientSecret, String callbackUrl, String state) {
        this.init(clientId, clientSecret, callbackUrl, state);
    }

    private void init(String clientId, String clientSecret, String callbackUrl, String state) {
        this.mInOAuthClientId = clientId;
        this.mInOAuthClientSecret = clientSecret;
        this.mInOAuthCallback = callbackUrl;
        this.mInOAuthState = TextUtils.isEmpty((CharSequence)state) ? this.generateState() : state;
    }

    private String generateState() {
        SecureRandom random = new SecureRandom();
        String state = new BigInteger(130, random).toString(32);
        try {
            return URLEncoder.encode(state, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return state;
        }
    }

    public void setMiddleResult(String code, String state, String errorCode, String errorDesc) {
        this.mOAuthCode = code;
        this.mOAuthState = state;
        this.mOAuthErrorCode = OAuthErrorCode.fromString(errorCode);
        this.mOAuthErrorDesc = errorDesc;
    }

    public boolean isSuccess() {
        if (TextUtils.isEmpty((CharSequence)this.mOAuthErrorCode.getCode())) {
            if (this.isStateOk()) {
                return !TextUtils.isEmpty((CharSequence)this.mOAuthCode);
            }
            return false;
        }
        return false;
    }

    public String getInitState() {
        return this.mInOAuthState;
    }

    public String getState() {
        return this.mOAuthState;
    }

    public String getClientId() {
        return this.mInOAuthClientId;
    }

    public String getClientSecret() {
        return this.mInOAuthClientSecret;
    }

    public String getCode() {
        if (this.isStateOk()) {
            return this.mOAuthCode;
        }
        return null;
    }

    public OAuthErrorCode getErrorCode() {
        return this.mOAuthErrorCode;
    }

    public String getErrorDesc() {
        return this.mOAuthErrorDesc;
    }

    private boolean isStateOk() {
        if (this.mInOAuthState.equalsIgnoreCase(this.mOAuthState)) {
            return true;
        }
        if (!Logger.isRealVersion()) {
            Logger.d(TAG, "state is not valid. init:" + this.mInOAuthState + ", check:" + this.mOAuthState);
        }
        return false;
    }

    public String getCallbackUrl() {
        return this.mInOAuthCallback;
    }
}

