/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.idp.common.logger;

import com.nhn.android.idp.common.logger.LoggerStrategyLog;
import com.nhn.android.idp.common.logger.LoggerStrategyNoLog;

public class Logger {
    private static ILoggerStrategy logger = LoggerStrategyLog.getInstance();
    private static boolean isRealVersion = true;
    private static String mTagPrefix = "";

    public static void setAsRealVersion(boolean realVersion) {
        isRealVersion = realVersion;
    }

    public static boolean isRealVersion() {
        return isRealVersion;
    }

    public static void setTagPrefix(String tagPrefix) {
        mTagPrefix = tagPrefix;
        logger.setTagPrefix(tagPrefix);
    }

    public static void setLogger(ILoggerStrategy customLogger) {
        logger = customLogger;
    }

    public static void switchingToLogcat() {
        logger = LoggerStrategyLog.getInstance(mTagPrefix);
    }

    public static void switchingToNoLogging() {
        logger = LoggerStrategyNoLog.getInstance(mTagPrefix);
    }

    public static void i(String tag, String message) {
        logger.i(tag, message);
    }

    public static void w(String tag, String message) {
        logger.w(tag, message);
    }

    public static void d(String tag, String message) {
        logger.d(tag, message);
    }

    public static void e(String tag, String message) {
        logger.e(tag, message);
    }

    public static void v(String tag, String message) {
        logger.v(tag, message);
    }

    public static void write(int level, String tag, String message) {
        logger.write(level, tag, message);
    }

    public static void write(Exception exception) {
        if (exception == null) {
            return;
        }
        Logger.e("Exception", exception.toString());
        StackTraceElement[] elem = exception.getStackTrace();
        for (int i = 0; i < elem.length; ++i) {
            Logger.e("Exception", elem[i].toString());
        }
    }

    public static interface ILoggerStrategy {
        public void setTagPrefix(String var1);

        public void i(String var1, String var2);

        public void w(String var1, String var2);

        public void d(String var1, String var2);

        public void e(String var1, String var2);

        public void v(String var1, String var2);

        public void write(int var1, String var2, String var3);
    }
}

