/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.idp.common.connection;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import android.widget.Toast;
import com.nhn.android.oauth.R;

public class NetworkState {
    private static boolean shown = false;

    public static boolean isDataConnected(Context context) {
        try {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = manager.getActiveNetworkInfo();
            return info != null && manager.getActiveNetworkInfo().isConnected();
        }
        catch (Exception err) {
            err.printStackTrace();
            return true;
        }
    }

    private static boolean isConnected(Context context, int connectType) {
        try {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            if (manager != null) {
                if (Build.VERSION.SDK_INT < 23) {
                    NetworkInfo ni = manager.getNetworkInfo(connectType);
                    if (ni.isConnected()) {
                        return true;
                    }
                } else {
                    Network[] allNetwork;
                    for (Network network : allNetwork = manager.getAllNetworks()) {
                        NetworkInfo info = manager.getNetworkInfo(network);
                        if (null == info || connectType != info.getType() || !info.isConnected()) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return false;
    }

    public static boolean is3GConnected(Context context) {
        return NetworkState.isConnected(context, 0);
    }

    public static boolean isWifiConnected(Context context) {
        return NetworkState.isConnected(context, 1);
    }

    public static void showRetry(final Context context, final RetryListener retryListener) {
        if (shown || context == null) {
            return;
        }
        if (context instanceof Activity && ((Activity)context).isFinishing()) {
            return;
        }
        shown = true;
        AlertDialog.Builder dialog = new AlertDialog.Builder(context);
        dialog.setIcon(17301543);
        dialog.setMessage((CharSequence)context.getString(R.string.naveroauthlogin_string_network_state_not_available));
        dialog.setPositiveButton((CharSequence)context.getString(R.string.retry), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                shown = false;
                if (context instanceof Activity && ((Activity)context).isFinishing()) {
                    return;
                }
                retryListener.onResult(true);
            }
        });
        dialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                shown = false;
                if (context instanceof Activity && ((Activity)context).isFinishing()) {
                    return;
                }
                retryListener.onResult(false);
            }
        });
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface arg0) {
                shown = false;
                if (context instanceof Activity && ((Activity)context).isFinishing()) {
                    return;
                }
                retryListener.onResult(false);
            }
        });
        try {
            dialog.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean checkConnectivity(Context context, boolean showDialog, RetryListener retryListener) {
        if (NetworkState.isDataConnected(context)) {
            return true;
        }
        if (showDialog) {
            if (retryListener == null) {
                String msg = context.getString(R.string.naveroauthlogin_string_network_state_not_available);
                Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
                return false;
            }
            NetworkState.showRetry(context, retryListener);
        }
        return false;
    }

    public static String getNetworkState(Context context) {
        String network = "other";
        if (NetworkState.is3GConnected(context)) {
            network = "cell";
        } else if (NetworkState.isWifiConnected(context)) {
            network = "wifi";
        }
        return network;
    }

    public static interface RetryListener {
        public void onResult(boolean var1);
    }
}

