/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.nhn.android.idp.common.logger.Logger;
import com.nhn.android.naverlogin.data.OAuthErrorCode;
import com.nhn.android.naverlogin.data.OAuthLoginData;
import com.nhn.android.naverlogin.data.OAuthLoginPreferenceManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class OAuthWebviewUrlUtil {
    private static final String TAG = "OAuthWebvewUrlUtil";
    public static final String FINAL_URL = "http://nid.naver.com/com.nhn.login_global/inweb/finish";
    public static final String FINAL_URL_HTTPS = "https://nid.naver.com/com.nhn.login_global/inweb/finish";

    private static Map<String, String> getQueryMapFromUrl(String url) {
        if (url.contains("?")) {
            url = url.split("\\?")[1];
        }
        return OAuthWebviewUrlUtil.getQueryMap(url);
    }

    private static Map<String, String> getQueryMap(String query) {
        if (query == null) {
            return null;
        }
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String value;
            String name;
            String[] keyname = param.split("=");
            if (keyname.length == 2) {
                name = keyname[0];
                value = keyname[1];
                map.put(name, value);
                continue;
            }
            if (keyname.length != 1) continue;
            name = keyname[0];
            value = "";
            map.put(name, value);
        }
        return map;
    }

    public static boolean isErrorResultNaverTokenInvalid(Context context, String preUrlString, String urlString, OAuthLoginData oAuthLoginData) {
        block7: {
            try {
                if (!TextUtils.isEmpty((CharSequence)preUrlString) && !preUrlString.startsWith("https://nid.naver.com/")) {
                    if (!Logger.isRealVersion()) {
                        Logger.d(TAG, "isErrorResultNaverTokenInvalid - pre url is not naver.com");
                    }
                    break block7;
                }
                Map<String, String> querymap = null;
                try {
                    URL url = new URL(urlString);
                    querymap = OAuthWebviewUrlUtil.getQueryMap(url.getQuery());
                }
                catch (Exception e) {
                    querymap = OAuthWebviewUrlUtil.getQueryMapFromUrl(urlString);
                }
                if (null != querymap && querymap.containsKey("error") && querymap.containsKey("error_description") && querymap.get("error").equalsIgnoreCase("invalid_request") && querymap.get("error_description").contains("token") && querymap.get("error_description").contains("invalid")) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static String getDecodedString(String oriStr) {
        if (TextUtils.isEmpty((CharSequence)oriStr)) {
            return oriStr;
        }
        String decodedStr = "";
        try {
            decodedStr = URLDecoder.decode(oriStr, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!TextUtils.isEmpty((CharSequence)decodedStr) && !decodedStr.equalsIgnoreCase(oriStr)) {
            return decodedStr;
        }
        return oriStr;
    }

    public static boolean returnWhenAuthorizationDone(Context context, String preUrlString, String urlString, OAuthLoginData oAuthLoginData) {
        boolean rt;
        block18: {
            rt = false;
            if (oAuthLoginData == null) {
                oAuthLoginData = new OAuthLoginData("", "", "");
            }
            try {
                if (!TextUtils.isEmpty((CharSequence)preUrlString) && !(preUrlString.startsWith("https://nid.naver.com/") || preUrlString.startsWith("https://nid.naver.com/"))) {
                    if (!Logger.isRealVersion()) {
                        Logger.d(TAG, "returnWhenAuthorizationDone - pre url is not naver.com");
                    }
                    break block18;
                }
                if (urlString.startsWith("https://nid.naver.com/login/noauth/logout.nhn") || urlString.startsWith("http://nid.naver.com/nidlogin.logout")) {
                    Intent intent = new Intent();
                    intent.putExtra("oauth_error_code", OAuthErrorCode.CLIENT_USER_CANCEL.getCode());
                    intent.putExtra("oauth_error_desc", OAuthErrorCode.CLIENT_USER_CANCEL.getDesc());
                    ((Activity)context).setResult(-1, intent);
                    ((Activity)context).finish();
                    return true;
                }
                Map<String, String> querymap = null;
                try {
                    URL url = new URL(urlString);
                    querymap = OAuthWebviewUrlUtil.getQueryMap(url.getQuery());
                }
                catch (Exception e) {
                    querymap = OAuthWebviewUrlUtil.getQueryMapFromUrl(urlString);
                }
                if (querymap != null && querymap.containsKey("code") && querymap.containsKey("state")) {
                    if (!Logger.isRealVersion()) {
                        Logger.d(TAG, "query map contain code and state");
                    }
                    rt = true;
                } else if (querymap != null && querymap.containsKey("error") && querymap.containsKey("error_description")) {
                    if (!Logger.isRealVersion()) {
                        Logger.d(TAG, "query map contain error, url : " + urlString);
                    }
                    rt = true;
                    OAuthLoginPreferenceManager pref = new OAuthLoginPreferenceManager(context);
                    pref.setLastErrorCode(OAuthErrorCode.fromString(querymap.get("error")));
                    String errorDesc = OAuthWebviewUrlUtil.getDecodedString(querymap.get("error_description"));
                    pref.setLastErrorDesc(errorDesc);
                } else if (!Logger.isRealVersion()) {
                    Logger.d(TAG, "query map does not contain code and state, url:" + urlString);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (rt) {
            try {
                OAuthWebviewUrlUtil.processCallbackUrl(context, urlString, oAuthLoginData);
                Intent intent = new Intent();
                intent.putExtra("oauth_code", oAuthLoginData.getCode());
                intent.putExtra("oauth_state", oAuthLoginData.getInitState());
                intent.putExtra("oauth_error_code", oAuthLoginData.getErrorCode().getCode());
                intent.putExtra("oauth_error_desc", oAuthLoginData.getErrorDesc());
                ((Activity)context).setResult(-1, intent);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                Intent intent = new Intent();
                intent.putExtra("oauth_error_code", OAuthErrorCode.CLIENT_ERROR_PARSING_FAIL.getCode());
                intent.putExtra("oauth_error_desc", OAuthErrorCode.CLIENT_ERROR_PARSING_FAIL.getDesc());
                ((Activity)context).setResult(0, intent);
            }
            ((Activity)context).finish();
        }
        return rt;
    }

    public static boolean isFinalUrl(boolean isShouldOverrideUrl, String preUrl, String url) {
        if (url == null) {
            return false;
        }
        if (url.equalsIgnoreCase(FINAL_URL) || url.equalsIgnoreCase(FINAL_URL_HTTPS) || url.equalsIgnoreCase("http://m.naver.com/") || url.equalsIgnoreCase("http://m.naver.com")) {
            return true;
        }
        if (isShouldOverrideUrl && url.startsWith("https://nid.naver.com/nidlogin.login?svctype=262144")) {
            return true;
        }
        return false == isShouldOverrideUrl && (preUrl.startsWith("https://nid.naver.com/mobile/user/help/sleepId.nhn?m=viewSleepId&token_help=") && url.startsWith("https://nid.naver.com/nidlogin.login?svctype=262144") || preUrl.startsWith("https://nid.naver.com/mobile/user/global/idSafetyRelease.nhn?") && url.startsWith("https://nid.naver.com/nidlogin.login?svctype=262144") || preUrl.startsWith("https://nid.naver.com/mobile/user/help/idSafetyRelease.nhn?") && url.startsWith("https://nid.naver.com/nidlogin.login?svctype=262144"));
    }

    public static void processCallbackUrl(Context context, String urlstr, OAuthLoginData data) throws MalformedURLException {
        Map<String, String> querymap = null;
        try {
            URL url = new URL(urlstr);
            querymap = OAuthWebviewUrlUtil.getQueryMap(url.getQuery());
        }
        catch (Exception e) {
            querymap = OAuthWebviewUrlUtil.getQueryMapFromUrl(urlstr);
        }
        String code = querymap.get("code");
        String state = querymap.get("state");
        String errorCode = querymap.get("error");
        String errorDesc = OAuthWebviewUrlUtil.getDecodedString(querymap.get("error_description"));
        data.setMiddleResult(code, state, errorCode, errorDesc);
    }
}

