/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewTreeObserver;
import android.webkit.DownloadListener;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.nhn.android.idp.common.connection.NetworkState;
import com.nhn.android.idp.common.logger.Logger;
import com.nhn.android.idp.common.util.DeviceAppInfo;
import com.nhn.android.naverlogin.OAuthLoginDefine;
import com.nhn.android.naverlogin.connection.gen.OAuthQueryGenerator;
import com.nhn.android.naverlogin.data.OAuthLoginData;
import com.nhn.android.naverlogin.ui.OAuthWebviewUrlUtil;
import com.nhn.android.naverlogin.ui.view.OAuthLoginLayoutNaverAppDownloadBanner;
import com.nhn.android.naverlogin.util.OAuthLoginUiUtil;
import com.nhn.android.oauth.R;

public class OAuthLoginInAppBrowserActivity
extends Activity
implements View.OnClickListener {
    private static final String TAG = "OAuthLoginInAppBrowserActivity";
    private static final String INSTANCE_STATE_WEBVIEW_RUN_ONLY_ONCE = "IsLoginActivityStarted";
    private static final String INSTANCE_STATE_IS_VISIBLE_BANNER = "isVisibleBanner";
    private int mOriginHeight;
    private Context mContext;
    private OAuthLoginLayoutNaverAppDownloadBanner mNaverDownloadBanner;
    private ImageView mImgSeperator;
    private ImageView mImgCloseButton;
    private WebView mWebView;
    private ProgressBar mWebviewProgressbar;
    private LinearLayout mWholeView;
    private LinearLayout mNaviBar;
    public String mInOAuthUrl;
    private String mWebViewContent;
    private OAuthLoginData mOAuthLoginData;
    private boolean mIsLoginActivityStarted = false;
    private String mOAuthSdkVersion;
    private boolean mFixActivityPortrait = true;
    private boolean mVisibleNaverAppDownloadBanner = true;
    final DownloadListener mDefaultDownloadListener = new DownloadListener(){

        public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
            Intent viewIntent = new Intent("android.intent.action.VIEW");
            viewIntent.setDataAndType(Uri.parse((String)url), mimetype);
            try {
                OAuthLoginInAppBrowserActivity.this.startActivity(viewIntent);
            }
            catch (Throwable th) {
                th.printStackTrace();
                try {
                    viewIntent.setData(Uri.parse((String)url));
                    OAuthLoginInAppBrowserActivity.this.startActivity(viewIntent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initIntentData();
        this.initSavedInstanceStateData(savedInstanceState);
        this.initView(savedInstanceState);
        if (!Logger.isRealVersion()) {
            Logger.d(TAG, "webview onCreate() fix:" + this.mFixActivityPortrait);
        }
        if (this.mFixActivityPortrait) {
            this.setRequestedOrientation(1);
        }
        this.registerSizeChangeListener();
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.initSavedInstanceStateData(savedInstanceState);
        if (!Logger.isRealVersion()) {
            Logger.d(TAG, "webview onRestoreInstanceState() first:" + this.mIsLoginActivityStarted + ", sdk:" + this.mOAuthSdkVersion + ", fix:" + this.mFixActivityPortrait);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (!Logger.isRealVersion()) {
            Logger.d(TAG, "webview onSaveInstanceState()");
        }
        outState.putBoolean(INSTANCE_STATE_WEBVIEW_RUN_ONLY_ONCE, this.mIsLoginActivityStarted);
        if (this.mWebView != null) {
            this.mWebView.saveState(outState);
        }
        outState.putString("SdkVersionCalledFrom", this.mOAuthSdkVersion);
        outState.putBoolean("IsFixActivityPortrait", this.mFixActivityPortrait);
        outState.putString("oauthUrl", this.mInOAuthUrl);
        if (this.mVisibleNaverAppDownloadBanner && null != this.mNaverDownloadBanner && this.mNaverDownloadBanner.getVisibility() == 0) {
            outState.putBoolean(INSTANCE_STATE_IS_VISIBLE_BANNER, true);
        } else {
            outState.putBoolean(INSTANCE_STATE_IS_VISIBLE_BANNER, false);
        }
    }

    private void initIntentData() {
        this.mContext = this;
        if (DeviceAppInfo.isAppExist(this.mContext, "com.nhn.android.search")) {
            this.mVisibleNaverAppDownloadBanner = false;
        }
        if (this.getIntent() != null) {
            String clientId = this.getIntent().getStringExtra("ClientId");
            String callbackUrl = this.getIntent().getStringExtra("ClientCallbackUrl");
            String state = this.getIntent().getStringExtra("state");
            String locale = DeviceAppInfo.getBaseInstance().getLocaleString(this.mContext);
            String network = NetworkState.getNetworkState(this.mContext);
            this.mOAuthLoginData = new OAuthLoginData(clientId, null, callbackUrl, state);
            if (!this.getIntent().hasExtra("OAuthUrl")) {
                this.mInOAuthUrl = new OAuthQueryGenerator().generateRequestWebViewAuthorizationUrl(clientId, this.mOAuthLoginData.getInitState(), callbackUrl, locale, network, "4.2.2");
            } else {
                String oAuthUrl = this.getIntent().getStringExtra("OAuthUrl");
                if (oAuthUrl.startsWith("https://nid.naver.com")) {
                    this.mInOAuthUrl = oAuthUrl;
                }
            }
            this.mOAuthSdkVersion = this.getIntent().getStringExtra("oauth_sdk_version");
            this.mFixActivityPortrait = OAuthLoginUiUtil.isFixActivityPortrait(this.mOAuthSdkVersion);
        }
    }

    private void initSavedInstanceStateData(Bundle savedInstanceState) {
        if (null != savedInstanceState) {
            this.mIsLoginActivityStarted = savedInstanceState.getBoolean(INSTANCE_STATE_WEBVIEW_RUN_ONLY_ONCE);
            if (this.mWebView != null) {
                this.mWebView.restoreState(savedInstanceState);
            }
            this.mOAuthSdkVersion = savedInstanceState.getString("SdkVersionCalledFrom");
            this.mFixActivityPortrait = savedInstanceState.getBoolean("IsFixActivityPortrait");
            this.mVisibleNaverAppDownloadBanner = savedInstanceState.getBoolean(INSTANCE_STATE_IS_VISIBLE_BANNER);
            this.mInOAuthUrl = savedInstanceState.getString("oauthUrl");
        }
    }

    private void runOnlyOnce() {
        if (this.getIntent() != null) {
            String url = this.getIntent().getStringExtra("agreeFormUrl");
            if (!TextUtils.isEmpty((CharSequence)url)) {
                this.mInOAuthUrl = url;
            }
            this.mWebViewContent = this.getIntent().getStringExtra("agreeFormContent");
        }
        if (TextUtils.isEmpty((CharSequence)this.mWebViewContent)) {
            if (!Logger.isRealVersion()) {
                Logger.d(TAG, "webview url -> " + this.mInOAuthUrl);
            }
            this.mWebView.loadUrl(this.mInOAuthUrl);
        } else {
            if (!Logger.isRealVersion()) {
                Logger.d(TAG, "webview url -> " + this.mInOAuthUrl);
                Logger.d(TAG, "webview content -> " + this.mWebViewContent);
            }
            this.mWebView.loadDataWithBaseURL(this.mInOAuthUrl, this.mWebViewContent, "text/html", null, null);
        }
    }

    public void onResume() {
        super.onResume();
        if (this.mWebView != null) {
            this.mWebView.resumeTimers();
            if (Build.VERSION.SDK_INT >= 11) {
                this.mWebView.onResume();
            }
        }
        if (!this.mIsLoginActivityStarted) {
            if (!Logger.isRealVersion()) {
                Logger.d(TAG, "webview onResume() first");
            }
            this.mIsLoginActivityStarted = true;
            this.runOnlyOnce();
        }
        if (!Logger.isRealVersion()) {
            Logger.d(TAG, "webview onResume()");
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mWebView != null && Build.VERSION.SDK_INT >= 11) {
            this.mWebView.onPause();
        }
        if (!Logger.isRealVersion()) {
            Logger.d(TAG, "webview onPause()");
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (!Logger.isRealVersion()) {
            Logger.d(TAG, "webview onDestroy()");
        }
        if (this.mWebView != null) {
            this.mWebView.stopLoading();
            if (this.mWholeView != null) {
                this.mWholeView.removeView((View)this.mWebView);
            }
            this.mWebView.removeAllViews();
            this.mWebView.destroy();
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initView(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        this.setContentView(R.layout.nlogin_browser_view);
        this.mWholeView = (LinearLayout)this.findViewById(R.id.wholeView);
        this.mWebviewProgressbar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.mWebView = (WebView)this.findViewById(R.id.webView);
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.setVerticalScrollbarOverlay(true);
        this.mWebView.setHorizontalScrollbarOverlay(true);
        this.mWebView.setWebViewClient((WebViewClient)new InAppWebViewClient());
        this.mWebView.setWebChromeClient((WebChromeClient)new InAppWebChromeClient());
        this.mWebView.setDownloadListener(this.mDefaultDownloadListener);
        String ua = this.mWebView.getSettings().getUserAgentString() + " " + DeviceAppInfo.getUserAgent((Context)this);
        this.mWebView.getSettings().setUserAgentString(ua);
        this.mWebView.getSettings().setAppCacheEnabled(false);
        this.mWebView.getSettings().setCacheMode(2);
        this.mImgCloseButton = (ImageView)this.findViewById(R.id.webviewEndKey);
        this.mImgCloseButton.setClickable(true);
        this.mImgCloseButton.setOnClickListener((View.OnClickListener)this);
        if (OAuthLoginDefine.MARKET_LINK_WORKING && this.mVisibleNaverAppDownloadBanner) {
            this.mNaverDownloadBanner = (OAuthLoginLayoutNaverAppDownloadBanner)this.findViewById(R.id.app_download_banner);
        }
        if (OAuthLoginDefine.MARKET_LINK_WORKING && null != this.mNaverDownloadBanner && this.mVisibleNaverAppDownloadBanner) {
            this.mNaverDownloadBanner.setVisibility(0);
        }
        this.mNaviBar = (LinearLayout)this.findViewById(R.id.webviewNaviBar);
        if (!OAuthLoginDefine.BOTTOM_TAB_WORKING) {
            this.mNaviBar.setVisibility(8);
        }
    }

    private void registerSizeChangeListener() {
        LinearLayout activityRootView = this.mWholeView;
        activityRootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (OAuthLoginInAppBrowserActivity.this.mOriginHeight == 0) {
                    OAuthLoginInAppBrowserActivity.this.mOriginHeight = OAuthLoginInAppBrowserActivity.this.mWholeView.getHeight();
                }
                if (OAuthLoginInAppBrowserActivity.this.mOriginHeight > OAuthLoginInAppBrowserActivity.this.mWholeView.getHeight() || !OAuthLoginDefine.BOTTOM_TAB_WORKING) {
                    OAuthLoginInAppBrowserActivity.this.mNaviBar.setVisibility(8);
                } else {
                    OAuthLoginInAppBrowserActivity.this.mNaviBar.setVisibility(0);
                }
            }
        });
    }

    public void onClick(View view) {
        if (view == this.mImgCloseButton) {
            this.finish();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (!Logger.isRealVersion()) {
            Logger.d(TAG, "screen orientation = " + (newConfig.orientation == 2 ? "landscape" : "portrait"));
        }
        this.mOriginHeight = 0;
    }

    private boolean loadBrowser(String url) {
        if (url.length() <= 0 || url.contentEquals("about:blank")) {
            return false;
        }
        if (url.startsWith("https://nid.naver.com")) {
            return url.startsWith("https://nid.naver.com/mobile/user/help/idInquiry.nhn") || url.startsWith("https://nid.naver.com/mobile/user/help/pwInquiry.nhn") || url.startsWith("https://nid.naver.com/user/mobile_join.nhn");
        }
        if (url.startsWith("https://nid.naver.com/nidlogin.logout") || url.startsWith("http://nid.naver.com/nidlogin.logout")) {
            return false;
        }
        if (url.contains("/sso/logout.nhn") || url.contains("/sso/cross-domain.nhn") || url.contains("/sso/finalize.nhn")) {
            return false;
        }
        if (url.startsWith("http://cc.naver.com") || url.startsWith("http://cr.naver.com")) {
            return false;
        }
        if (url.startsWith("https://cert.vno.co.kr")) {
            return false;
        }
        if (url.startsWith("https://ipin.ok-name.co.kr")) {
            return false;
        }
        return !url.startsWith("https://ipin.siren24.com");
    }

    private class InAppWebViewClient
    extends WebViewClient {
        private String preUrl = "";

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            if (!Logger.isRealVersion()) {
                Logger.d(OAuthLoginInAppBrowserActivity.TAG, "[star] pre url : " + this.preUrl);
                Logger.d(OAuthLoginInAppBrowserActivity.TAG, "[star]     url : " + url);
            }
            if (OAuthWebviewUrlUtil.isFinalUrl(false, this.preUrl, url)) {
                OAuthLoginInAppBrowserActivity.this.mWebView.stopLoading();
                OAuthLoginInAppBrowserActivity.this.finish();
                return;
            }
            if (OAuthWebviewUrlUtil.returnWhenAuthorizationDone(OAuthLoginInAppBrowserActivity.this.mContext, this.preUrl, url, OAuthLoginInAppBrowserActivity.this.mOAuthLoginData)) {
                OAuthLoginInAppBrowserActivity.this.mWebView.stopLoading();
                return;
            }
            super.onPageStarted(view, url, favicon);
            if (OAuthLoginInAppBrowserActivity.this.mWebviewProgressbar != null) {
                OAuthLoginInAppBrowserActivity.this.mWebviewProgressbar.setVisibility(0);
            }
        }

        @RequiresApi(api=21)
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return this.shouldOverrideUrlLoading(view, request.getUrl().toString());
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (!Logger.isRealVersion()) {
                Logger.d(OAuthLoginInAppBrowserActivity.TAG, "[over] pre url : " + this.preUrl);
                Logger.d(OAuthLoginInAppBrowserActivity.TAG, "[over]     url : " + url);
            }
            if (OAuthWebviewUrlUtil.isFinalUrl(true, this.preUrl, url)) {
                OAuthLoginInAppBrowserActivity.this.mWebView.stopLoading();
                OAuthLoginInAppBrowserActivity.this.finish();
                return true;
            }
            if (OAuthWebviewUrlUtil.returnWhenAuthorizationDone(OAuthLoginInAppBrowserActivity.this.mContext, this.preUrl, url, OAuthLoginInAppBrowserActivity.this.mOAuthLoginData)) {
                return true;
            }
            if (OAuthLoginInAppBrowserActivity.this.loadBrowser(url)) {
                Intent i = new Intent("android.intent.action.VIEW");
                Uri u = Uri.parse((String)url);
                i.setData(u);
                OAuthLoginInAppBrowserActivity.this.startActivity(i);
                return true;
            }
            view.loadUrl(url);
            this.preUrl = url;
            return true;
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (OAuthLoginInAppBrowserActivity.this.mWebviewProgressbar != null) {
                OAuthLoginInAppBrowserActivity.this.mWebviewProgressbar.setVisibility(8);
            }
            view.clearCache(true);
        }

        @RequiresApi(api=23)
        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            this.onReceivedError(view, error.getErrorCode(), error.getDescription().toString(), request.getUrl().toString());
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            if (OAuthLoginInAppBrowserActivity.this.mWebviewProgressbar != null) {
                OAuthLoginInAppBrowserActivity.this.mWebviewProgressbar.setVisibility(8);
            }
            if (!Logger.isRealVersion()) {
                Logger.d(OAuthLoginInAppBrowserActivity.TAG, "webview receive error " + errorCode + ", " + description + ", " + failingUrl);
            }
            if (!NetworkState.checkConnectivity(OAuthLoginInAppBrowserActivity.this.mContext, true, null)) {
                OAuthLoginInAppBrowserActivity.this.finish();
                return;
            }
        }

        public void onFormResubmission(WebView view, Message dontResend, Message resend) {
            super.onFormResubmission(view, dontResend, resend);
        }
    }

    private class InAppWebChromeClient
    extends WebChromeClient {
        private InAppWebChromeClient() {
        }

        public void onProgressChanged(WebView view, int newProgress) {
            if (OAuthLoginInAppBrowserActivity.this.mWebviewProgressbar != null) {
                OAuthLoginInAppBrowserActivity.this.mWebviewProgressbar.setProgress(newProgress);
            }
        }
    }

    public class OAuthLoginInAppBrowserOutIntentData {
        public static final String RESULT_CALLBACK = "RESULT_CALLBACK";
    }
}

