/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.connection.gen;

import com.nhn.android.naverlogin.connection.gen.CommonLoginQuery;
import java.util.HashMap;
import java.util.Map;

public class OAuthQueryGenerator
extends CommonLoginQuery {
    private static final String TAG = "OAuthQueryGenerator";
    private static final String OAUTH_REQUEST_AUTH_URL = "https://nid.naver.com/oauth2.0/authorize?";
    private static final String OAUTH_REQUEST_ACCESS_TOKEN_URL = "https://nid.naver.com/oauth2.0/token?";

    public String generateRequestWebViewAuthorizationUrl(String clientId, String state, String callbackUrl, String locale) {
        return this.generateRequestWebViewAuthorizationUrl(clientId, state, callbackUrl, locale, null, "4.2.2");
    }

    public String generateRequestWebViewAuthorizationUrl(String clientId, String state, String callbackUrl, String locale, String network, String version) {
        return String.format("%s%s", OAUTH_REQUEST_AUTH_URL, this.getQueryParameter(this.newAuthorizationParamMap(clientId, state, callbackUrl, locale, network, "true", version)));
    }

    public String generateRequestCustomTabAuthorizationUrl(String clientId, String state, String appPackageName, String locale, String network, String version) {
        return String.format("%s%s", OAUTH_REQUEST_AUTH_URL, this.getQueryParameter(this.newAuthorizationParamMap(clientId, state, appPackageName, locale, network, "custom_tab", version)));
    }

    private Map<String, String> newAuthorizationParamMap(String clientId, String state, String callbackUrl, String locale, String network, String inAppType, String version) {
        HashMap<String, String> paramArray = new HashMap<String, String>();
        paramArray.put("client_id", clientId);
        paramArray.put("inapp_view", inAppType);
        paramArray.put("response_type", "code");
        paramArray.put("oauth_os", "android");
        paramArray.put("version", "android-" + version);
        if (null != network) {
            paramArray.put("network", network);
        }
        paramArray.put("locale", locale);
        paramArray.put("redirect_uri", callbackUrl);
        paramArray.put("state", state);
        return paramArray;
    }

    public String generateRequestAccessTokenUrl(String clientId, String clientSecret, String state, String code, String locale, String version) {
        HashMap<String, String> paramArray = new HashMap<String, String>();
        paramArray.put("client_id", clientId);
        paramArray.put("client_secret", clientSecret);
        paramArray.put("grant_type", "authorization_code");
        paramArray.put("state", state);
        paramArray.put("code", code);
        paramArray.put("oauth_os", "android");
        paramArray.put("version", "android-" + version);
        paramArray.put("locale", locale);
        return String.format("%s%s", OAUTH_REQUEST_ACCESS_TOKEN_URL, this.getQueryParameter(paramArray));
    }

    public String generateRequestRefreshAccessTokenUrl(String clientId, String clientSecret, String refreshToken, String locale, String version) {
        HashMap<String, String> paramArray = new HashMap<String, String>();
        paramArray.put("client_id", clientId);
        paramArray.put("client_secret", clientSecret);
        paramArray.put("grant_type", "refresh_token");
        paramArray.put("refresh_token", refreshToken);
        paramArray.put("oauth_os", "android");
        paramArray.put("version", "android-" + version);
        paramArray.put("locale", locale);
        return String.format("%s%s", OAUTH_REQUEST_ACCESS_TOKEN_URL, this.getQueryParameter(paramArray));
    }

    public String generateRequestDeleteAccessTokenUrl(String clientId, String clientSecret, String accessToken, String locale, String version) {
        HashMap<String, String> paramArray = new HashMap<String, String>();
        paramArray.put("client_id", clientId);
        paramArray.put("client_secret", clientSecret);
        paramArray.put("grant_type", "delete");
        paramArray.put("access_token", accessToken);
        paramArray.put("service_provider", "NAVER");
        paramArray.put("oauth_os", "android");
        paramArray.put("version", "android-" + version);
        paramArray.put("locale", locale);
        return String.format("%s%s", OAUTH_REQUEST_ACCESS_TOKEN_URL, this.getQueryParameter(paramArray));
    }
}

