package com.nhn.android.naverlogin.ui.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;

import com.nhn.android.naverlogin.OAuthLogin;
import com.nhn.android.naverlogin.OAuthLoginHandler;
import com.nhn.android.naverlogin.util.OAuthLoginUiUtil;
import com.nhn.android.oauth.R;

/**
 * imagebutton for "Sign-in with NAVER"
 * @author nhn
 *
 */
public class OAuthLoginButton extends ImageView {

	public static final String TAG = "OAuthLoginButton";
	private Context mContext;
	private static OAuthLoginHandler mOAuthLoginHandler;
	
	// background image resource id
	private int		mBgDrawableResId = R.drawable.login_btn_img;
	private Drawable buttonImage;

	public OAuthLoginButton(Context context) {
		super(context);
		init(context);
	}

	public OAuthLoginButton(Context context, AttributeSet attrs) {
		super(context, attrs);
		init(context);
	}

	public OAuthLoginButton(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
		init(context);
	}

	/**
	 * 버튼을 클릭하여 로그인하는 경우, 로그인 결과를 받을 handler 를 지정해준다.
	 * @param oauthLoginHandler 로그인 결과를 받을 handler 
	 */
	public void setOAuthLoginHandler(final OAuthLoginHandler oauthLoginHandler) {
		mOAuthLoginHandler = oauthLoginHandler;
	}
	
	/**
	 * 네이버로 로그인 버튼의 색깔과 형태는 하나로 고정되어 표시됩니다.
	 * 다른 이미지를 사용하고 싶으시다면 setBgResourceName() 메쏘드를 사용해주세요.  
	 * set color and type of Naver Sign-in Button.
	 * @deprecated Use setBgResourceId(). this method is deprecated.(cause, containg image resource in jar make that file size is large.)  
	 * @param color unused
	 * @param type unused
	 */
	@Deprecated
	public void setBgType(String color, String type) {}
	
	/**
	 * 버튼의 배경 이미지를  정해준다.
	 * 정해주지 않는 경우 디폴트 이미지가 표시됨
	 * 사용가능한 버튼 이미지는 네이버 아이디로 로그인 개발자 페이지의 
	 * BI 가이드(http://developer.naver.com/wiki/pages/NaverLoginBIGuide)에서 참고 가능
	 *
	 * @param resId 버튼 배경 이미지로 쓸 resource id
	 * @deprecated 4.2.0 {@linkplain ImageView}의 리소스 설정메소드 혹은 xml 상에서 이미지를 지정
	 *
	 * @see ImageView
	 */
	@Deprecated
	public void setBgResourceId(@DrawableRes int resId) {
		setImageResource(resId);
	}
	
	private void setBgType() {
		if(getDrawable() == null) {
			buttonImage = OAuthLoginUiUtil.getDrawableById(mContext, mBgDrawableResId);
			setImageDrawable(buttonImage);
		}
	}

	private void init(Context context) {
		mContext = context;
		setBgType();
		setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				OAuthLogin.getInstance().startOauthLoginActivity((Activity)mContext, mOAuthLoginHandler);
			}
		});
	}

	@Override
	protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
		if (isInEditMode()) return ;
		super.onLayout(changed, left, top, right, bottom);
	}
	
}
