/*
 * @(#)NLoginInAppBrowserActivity.java $version 2011. 8. 31.
 *
 * Copyright 2007 NHN Corp. All rights Reserved. 
 * NHN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.nhn.android.naverlogin.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewTreeObserver.OnGlobalLayoutListener;
import android.view.Window;
import android.webkit.DownloadListener;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;

import com.nhn.android.idp.common.connection.NetworkState;
import com.nhn.android.idp.common.logger.Logger;
import com.nhn.android.idp.common.util.DeviceAppInfo;
import com.nhn.android.naverlogin.OAuthLoginDefine;
import com.nhn.android.naverlogin.connection.gen.OAuthQueryGenerator;
import com.nhn.android.naverlogin.data.OAuthLoginBrowserIntentParam;
import com.nhn.android.naverlogin.data.OAuthLoginData;
import com.nhn.android.naverlogin.ui.view.OAuthLoginLayoutNaverAppDownloadBanner;
import com.nhn.android.naverlogin.util.OAuthLoginUiUtil;
import com.nhn.android.oauth.R;

/**
 * 네이버앱이 없는 경우 OAuth 인증시 사용하는 WebView를 포함한 Activity
 *
 * @author naver
 */
public class OAuthLoginInAppBrowserActivity extends Activity implements View.OnClickListener {
	private static final String TAG = "OAuthLoginInAppBrowserActivity";


	private static final String INSTANCE_STATE_WEBVIEW_RUN_ONLY_ONCE = "IsLoginActivityStarted";
	private static final String INSTANCE_STATE_IS_VISIBLE_BANNER = "isVisibleBanner";

	/**
	 * Original activity height<br/>
	 * If keyboard open then compare this value and current height.
	 */
	private int mOriginHeight;

	public class OAuthLoginInAppBrowserOutIntentData {
		public static final String RESULT_CALLBACK = "RESULT_CALLBACK";
	}

	private Context mContext;

	// UI 객체들 
	private OAuthLoginLayoutNaverAppDownloadBanner mNaverDownloadBanner;
	private ImageView mImgSeperator;
	private ImageView mImgCloseButton;
	private WebView mWebView;
	private ProgressBar mWebviewProgressbar;
	private LinearLayout mWholeView;
	private LinearLayout mNaviBar;

	// oauth 인증 과정 및 결과 전달에 필요한 변수들 
	public String mInOAuthUrl;
	private String mWebViewContent;

	// oauthlogin data
	private OAuthLoginData mOAuthLoginData;

	private boolean mIsLoginActivityStarted = false;

	/* 
	 * 갤럭시s5 android 5.0.0 이고, 3rd-party 앱이 multi-window 기능을 쓰는 경우 이 activity 의 orientation 이 지정되지 않고 네아로 SDK 4.1.1 이하에서 로그인시도시 
	 * onCreate() 가 2번 실행되는 현상이 있어서 orientation 을 고정한다. (네아로 4.1.3 버젼에서 호출될땐 추가적인 파라미터를 받아서 orientation 고정되지 않도록 한다.) 
	 */
	private String mOAuthSdkVersion;
	private boolean mFixActivityPortrait = true;
	private boolean mVisibleNaverAppDownloadBanner = true;


	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		initIntentData();
		initSavedInstanceStateData(savedInstanceState);
		initView(savedInstanceState);

		if (!Logger.isRealVersion()) {
			Logger.d(TAG, "webview onCreate() fix:" + mFixActivityPortrait);
		}

		if (mFixActivityPortrait) {
			/* 
			 * 안드로이드 5.0.0 에서 네아로 SDK 4.1.1 미만 버젼사용한 앱이 네이버앱 호출하여 네아로 로그인하는 경우, 
			 * 로그인한 뒤 화면 회전하고 3rd-party 앱으로 되돌아가면 onCreate() 다시 실행되는 문제가 있어서
			 * 중간의 투명 activity 는 portrait 로 고정하였음.    
			 */
			setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
		}

		// size 변경되는 걸 알 수 있는 listener 등록 
		registerSizeChangeListener();
	}

	@Override
	protected void onRestoreInstanceState(Bundle savedInstanceState) {
		super.onRestoreInstanceState(savedInstanceState);

		initSavedInstanceStateData(savedInstanceState);

		if (!Logger.isRealVersion()) {
			Logger.d(TAG, "webview onRestoreInstanceState() first:" + mIsLoginActivityStarted + ", sdk:" + mOAuthSdkVersion + ", fix:" + mFixActivityPortrait);
		}
	}

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);

		if (!Logger.isRealVersion()) {
			Logger.d(TAG, "webview onSaveInstanceState()");
		}

		outState.putBoolean(INSTANCE_STATE_WEBVIEW_RUN_ONLY_ONCE, mIsLoginActivityStarted);

		if (mWebView != null) {
			mWebView.saveState(outState);
		}

		// activity portrait 관련 값 
		outState.putString("SdkVersionCalledFrom", mOAuthSdkVersion);
		outState.putBoolean("IsFixActivityPortrait", mFixActivityPortrait);
		outState.putString("oauthUrl", mInOAuthUrl);

		if (mVisibleNaverAppDownloadBanner && null != mNaverDownloadBanner && mNaverDownloadBanner.getVisibility() == View.VISIBLE) {
			outState.putBoolean(INSTANCE_STATE_IS_VISIBLE_BANNER, true);
		} else {
			outState.putBoolean(INSTANCE_STATE_IS_VISIBLE_BANNER, false);
		}
	}


	private void initIntentData() {
		mContext = OAuthLoginInAppBrowserActivity.this;
		if (DeviceAppInfo.isAppExist(mContext, OAuthLoginDefine.NAVER_PACKAGE_NAME)) {
			mVisibleNaverAppDownloadBanner = false;
		}

		if (getIntent() != null) {

			String clientId = this.getIntent().getStringExtra(OAuthLoginBrowserIntentParam.INTENT_PARAM_KEY_CLIENT_ID);
			String callbackUrl = this.getIntent().getStringExtra(OAuthLoginBrowserIntentParam.INTENT_PARAM_KEY_CALLBACK_URL);
			String state = this.getIntent().getStringExtra(OAuthLoginBrowserIntentParam.INTENT_PARAM_KEY_STATE);

			String locale = DeviceAppInfo.getBaseInstance().getLocaleString(mContext);
			String network = NetworkState.getNetworkState(mContext);

			mOAuthLoginData = new OAuthLoginData(clientId, null, callbackUrl, state);
			if (!getIntent().hasExtra(OAuthLoginBrowserIntentParam.INTENT_PARAM_OAUTH_URL)) {
				mInOAuthUrl = new OAuthQueryGenerator().generateRequestWebViewAuthorizationUrl(clientId, mOAuthLoginData.getInitState(), callbackUrl, locale, network, OAuthLoginDefine.VERSION);
			} else {
				String oAuthUrl = getIntent().getStringExtra(OAuthLoginBrowserIntentParam.INTENT_PARAM_OAUTH_URL);
				// prevent wrong url
				if(oAuthUrl.startsWith("https://nid.naver.com")) {
					mInOAuthUrl = oAuthUrl;
				}
			}
			mOAuthSdkVersion = getIntent().getStringExtra(OAuthLoginBrowserIntentParam.INTENT_PARAM_KEY_OAUTH_SDK_VERSION);
			mFixActivityPortrait = OAuthLoginUiUtil.isFixActivityPortrait(mOAuthSdkVersion);
		}
	}

	private void initSavedInstanceStateData(Bundle savedInstanceState) {

		if (null != savedInstanceState) {
			mIsLoginActivityStarted = savedInstanceState.getBoolean(INSTANCE_STATE_WEBVIEW_RUN_ONLY_ONCE);

			if (mWebView != null) {
				mWebView.restoreState(savedInstanceState);
			}

			// activity portrait 관련 값 
			mOAuthSdkVersion = savedInstanceState.getString("SdkVersionCalledFrom");
			mFixActivityPortrait = savedInstanceState.getBoolean("IsFixActivityPortrait");
			mVisibleNaverAppDownloadBanner = savedInstanceState.getBoolean(INSTANCE_STATE_IS_VISIBLE_BANNER);
			mInOAuthUrl = savedInstanceState.getString("oauthUrl");
		}

	}


	private void runOnlyOnce() {
		// webview 에 설정하는건 한번만 실행 
		if (getIntent() != null) {
			// 동의 페이지의 내용을 이미 httpclient로 받아온 경우 그걸 그대로 보여준다
			String url = this.getIntent().getStringExtra(OAuthLoginBrowserIntentParam.INTENT_PARAM_KEY_AGREE_FORM_URL);
			if (!TextUtils.isEmpty(url)) {
				mInOAuthUrl = url;
			}

			mWebViewContent = this.getIntent().getStringExtra(OAuthLoginBrowserIntentParam.INTENT_PARAM_KEY_AGREE_FORM_CONTENT);
		}

		if (TextUtils.isEmpty(mWebViewContent)) {
			if (!Logger.isRealVersion()) {
				Logger.d(TAG, "webview url -> " + mInOAuthUrl);
			}
			mWebView.loadUrl(mInOAuthUrl);
		} else {
			if (!Logger.isRealVersion()) {
				Logger.d(TAG, "webview url -> " + mInOAuthUrl);
				Logger.d(TAG, "webview content -> " + mWebViewContent);
			}
			mWebView.loadDataWithBaseURL(mInOAuthUrl, mWebViewContent, "text/html", null, null);
		}

	}


	@Override
	public void onResume() {
		super.onResume();

		// pause 는 안하지만 혹시 다른 곳에서 pause 했을 수도 있으니 들어오면서 resume 한다. 
		if (mWebView != null) {
			mWebView.resumeTimers();

			if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
				mWebView.onResume();
			}
		}

		// resumeTimer() 를 실행하고 있음에도 불구하고 webview 의 javascript 가 실행안되는 경우가 발견되어 (갤럭시S2 4.0.3) onCreate() 에서 실행하던  runOnlyOnce() 메쏘드를 onResume() 의 webview.resumeTimers() 이후에 동작하게 했음.
		// 추가로 webview.onResume() 과 onPause() 도 실행하게 함
		if (false == mIsLoginActivityStarted) {
			if (!Logger.isRealVersion()) {
				Logger.d(TAG, "webview onResume() first");
			}

			mIsLoginActivityStarted = true;
			runOnlyOnce();
		}


		if (!Logger.isRealVersion()) {
			Logger.d(TAG, "webview onResume()");
		}
	}


	@Override
	public void onPause() {
		super.onPause();

		if (mWebView != null) {
			//mWebView.pauseTimers();	// 이거 호출하면 네앱이나 3rd-party 앱에 영향 미칠 수 있음

			if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
				mWebView.onPause();
			}
		}

		if (!Logger.isRealVersion()) {
			Logger.d(TAG, "webview onPause()");
		}
	}

	@Override
	public void onDestroy() {
		super.onDestroy();

		if (!Logger.isRealVersion()) {
			Logger.d(TAG, "webview onDestroy()");
		}

		if (mWebView != null) {
			mWebView.stopLoading();

			if (mWholeView != null) {
				mWholeView.removeView(mWebView);
			}
			mWebView.removeAllViews();
			mWebView.destroy();
		}

	}


	@SuppressWarnings("deprecation")
	@SuppressLint("SetJavaScriptEnabled")
	private void initView(Bundle savedInstanceState) {
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		setContentView(R.layout.nlogin_browser_view);
		mWholeView = (LinearLayout) findViewById(R.id.wholeView);
		mWebviewProgressbar = (ProgressBar) findViewById(R.id.progressBar);

		mWebView = (WebView) findViewById(R.id.webView);
		mWebView.getSettings().setJavaScriptEnabled(true);
		mWebView.setVerticalScrollbarOverlay(true);
		mWebView.setHorizontalScrollbarOverlay(true);
		mWebView.setWebViewClient(new InAppWebViewClient());
		mWebView.setWebChromeClient(new InAppWebChromeClient());
		mWebView.setDownloadListener(mDefaultDownloadListener);
		String ua = mWebView.getSettings().getUserAgentString() + " " + DeviceAppInfo.getUserAgent(OAuthLoginInAppBrowserActivity.this);
		mWebView.getSettings().setUserAgentString(ua);
		//
		mWebView.getSettings().setAppCacheEnabled(false);
		mWebView.getSettings().setCacheMode(WebSettings.LOAD_NO_CACHE);


		mImgCloseButton = (ImageView) findViewById(R.id.webviewEndKey);

		mImgCloseButton.setClickable(true);
		mImgCloseButton.setOnClickListener(OAuthLoginInAppBrowserActivity.this);

		if (OAuthLoginDefine.MARKET_LINK_WORKING && mVisibleNaverAppDownloadBanner) {
			mNaverDownloadBanner = (OAuthLoginLayoutNaverAppDownloadBanner) findViewById(R.id.app_download_banner);
		}

		if (OAuthLoginDefine.MARKET_LINK_WORKING && null != mNaverDownloadBanner && mVisibleNaverAppDownloadBanner) {
			mNaverDownloadBanner.setVisibility(View.VISIBLE);
		}
		mNaviBar = (LinearLayout) findViewById(R.id.webviewNaviBar);

		if (!OAuthLoginDefine.BOTTOM_TAB_WORKING) {
			mNaviBar.setVisibility(View.GONE);
		}
	}

	/*
	 * keyboard가 올라오면 하단의 navi-bar를 없앤다 
	 * <br/> 없애는 이유 : webview activity를 종료하는 X버튼을 사용자가 keyboard 닫는 버튼으로 착각하기 때문 
	 */
	private void registerSizeChangeListener() {
		final View activityRootView = mWholeView;
		// ref : http://stackoverflow.com/questions/2150078/how-to-check-visibility-of-software-keyboard-in-android
		activityRootView.getViewTreeObserver().addOnGlobalLayoutListener(
				new OnGlobalLayoutListener() {
					@Override
					public void onGlobalLayout() {
						if (mOriginHeight == 0) {
							mOriginHeight = mWholeView.getHeight();
						}
						if (mOriginHeight > mWholeView.getHeight() || !OAuthLoginDefine.BOTTOM_TAB_WORKING) {
							mNaviBar.setVisibility(View.GONE);
						} else {
							mNaviBar.setVisibility(View.VISIBLE);
						}
					}
				});
	}


	@Override
	public void onClick(View view) {
		if (view == mImgCloseButton) {
			finish();
		}
	}


	private class InAppWebChromeClient extends WebChromeClient {
		@Override
		public void onProgressChanged(WebView view, int newProgress) {
			if (mWebviewProgressbar != null) {
				mWebviewProgressbar.setProgress(newProgress);
			}
		}
	}

	/// URL 에 따른 WebView의 동작을 정의해둔 클래스

	/**
	 * URL에 따라 {@link OAuthLoginInAppBrowserActivity}를 종료시키거나, 기본 웹 브라우져를 실행시키거나, token을 얻어오는 동작을 하게됨
	 *
	 * @author naver
	 */
	private class InAppWebViewClient extends WebViewClient {
		private String preUrl = "";

		public InAppWebViewClient() {
		}

		@Override
		public void onPageStarted(WebView view, String url, Bitmap favicon) {
			if (!Logger.isRealVersion()) {
				Logger.d(TAG, "[star] pre url : " + preUrl);
				Logger.d(TAG, "[star]     url : " + url);
			}

			if (OAuthWebviewUrlUtil.isFinalUrl(false, preUrl, url)) {
				mWebView.stopLoading();
				finish();
				return;
			}

			if (OAuthWebviewUrlUtil.returnWhenAuthorizationDone(mContext, preUrl, url, mOAuthLoginData)) {
				mWebView.stopLoading();
				return;
			}

			super.onPageStarted(view, url, favicon);

			if (mWebviewProgressbar != null) {
				mWebviewProgressbar.setVisibility(View.VISIBLE);
			}
		}

		@RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
		@Override
		public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
			return shouldOverrideUrlLoading(view, request.getUrl().toString());
		}

		/**
		 * shouldOverrideUrlLoading은 post나 header redirect 방식의 페이지 이동 감지 못함
		 */
		@Override
		public boolean shouldOverrideUrlLoading(WebView view, String url) {
			if (!Logger.isRealVersion()) {
				Logger.d(TAG, "[over] pre url : " + preUrl);
				Logger.d(TAG, "[over]     url : " + url);
			}

			if (OAuthWebviewUrlUtil.isFinalUrl(true, preUrl, url)) {
				mWebView.stopLoading();
				finish();
				return true;
			}

			if (OAuthWebviewUrlUtil.returnWhenAuthorizationDone(mContext, preUrl, url, mOAuthLoginData)) {
				return true;
			}

			if (loadBrowser(url)) {
				Intent i = new Intent(Intent.ACTION_VIEW);
				Uri u = Uri.parse(url);
				i.setData(u);
				startActivity(i);
				return true;
			}

			view.loadUrl(url);
			preUrl = url;
			return true;
		}

		@Override
		public void onPageFinished(WebView view, String url) {
			super.onPageFinished(view, url);

			if (mWebviewProgressbar != null) {
				mWebviewProgressbar.setVisibility(View.GONE);
			}
			view.clearCache(true);
		}

		@RequiresApi(api = Build.VERSION_CODES.M)
		@Override
		public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
			onReceivedError(view, error.getErrorCode(), error.getDescription().toString(), request.getUrl().toString());
		}

		@Override
		public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
			if (mWebviewProgressbar != null) {
				mWebviewProgressbar.setVisibility(View.GONE);
			}
			if (!Logger.isRealVersion()) {
				Logger.d(TAG, "webview receive error " + errorCode + ", " + description + ", " + failingUrl);
			}

			if (!NetworkState.checkConnectivity(mContext, true, null)) {
				finish();
				return;
			}

			// TODO : Resource 상의 이슈는 loadUrl을 호출하지 않는다.
//			if(!failingUrl.contains("static.nid.naver.com")) {
//				view.loadUrl(mInOAuthUrl);
//			}
		}

		@Override
		public void onFormResubmission(WebView view, final Message dontResend, final Message resend) {
			super.onFormResubmission(view, dontResend, resend);
		}
	}

	/**
	 * 리프레시를 막아 화면 회전을 해도
	 *
	 * @param newConfig
	 */
	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		super.onConfigurationChanged(newConfig);

		if (!Logger.isRealVersion()) {
			Logger.d(TAG, "screen orientation = " +
					(newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE ? "landscape" : "portrait"));
		}
		mOriginHeight = 0;
	}

	private boolean loadBrowser(String url) {
		if (url.length() <= 0 || url.contentEquals("about:blank")) {
			return false;
		} else if (url.startsWith("https://nid.naver.com")) {
			//nid.naver.com 으로 시작하는 링크는 인앱 웹뷰이다.

			if (url.startsWith("https://nid.naver.com/mobile/user/help/idInquiry.nhn") ||
					url.startsWith("https://nid.naver.com/mobile/user/help/pwInquiry.nhn") ||
					url.startsWith("https://nid.naver.com/user/mobile_join.nhn")) {
				//그 중에서 아이디찾기, 비번찾기, 회원가입은 외부브라우저로 띄우도록 한다.
				return true;
			} else {
				return false;
			}

		} else if (url.startsWith("https://nid.naver.com/nidlogin.logout") ||
				url.startsWith("http://nid.naver.com/nidlogin.logout")) {
			return false;
		} else if (url.contains("/sso/logout.nhn") ||
				url.contains("/sso/cross-domain.nhn") ||
				url.contains("/sso/finalize.nhn")) {
			return false;

		} else if (url.startsWith("http://cc.naver.com") || url.startsWith("http://cr.naver.com")) {
			return false;
		} else if (url.startsWith("https://cert.vno.co.kr")) {
			// 나이스 신용평가
			return false;
		} else if (url.startsWith("https://ipin.ok-name.co.kr")) {
			// 코리아 크레딧뷰로
			return false;
		} else if (url.startsWith("https://ipin.siren24.com")) {
			// 서신평 
			return false;
		}

		return true;
	}


	final DownloadListener mDefaultDownloadListener = new DownloadListener() {
		public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
			/* test required */
			Intent viewIntent = new Intent(Intent.ACTION_VIEW);

			viewIntent.setDataAndType(Uri.parse(url), mimetype);

			try {
				startActivity(viewIntent); //caution : In case of the context not being attached a activity, this is useless
			} catch (Throwable th) {
				th.printStackTrace();
				try {
					viewIntent.setData(Uri.parse(url));
					startActivity(viewIntent);
				} catch (Exception ex) {
				}
			}
		}
	};

}
