package com.nhn.android.idp.common.util;


import android.os.Build;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;

import com.nhn.android.idp.common.logger.Logger;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CookieUtil {

	private static final String TAG = "CookieUtil";

	public static final String COOKIE_DOMAIN_NID = "https://nid.naver.com";

	
	public static List<String> getCookieUpperSDK23(Map<String, List<String>> headerMap) {
		List<String> cookieHeaders = new ArrayList<String>();
		
		for( String key : headerMap.keySet() ){
			// 대소문자 구분 안하게 동작함.
			if ("Set-Cookie".equalsIgnoreCase(key))	{
				List<String> headerList = headerMap.get(key);
			
				for (String cookie : headerList) {
					
					String cookieNoSpace = cookie.toString().trim();
					
					if (!cookieNoSpace.endsWith(";")) {
						cookie += ";";
					}
					
					cookieHeaders.add(cookie);
					
					if (!Logger.isRealVersion()) {
						Logger.d(TAG, "cookie:" + cookie);
					}
				}					
			}            
        }

		return cookieHeaders;
	}


	/**
	 * CookieManager의 naver 및 me2day 도메인에 login cookie 를 넣어줌 
	 * (cookie String -> cookie manager)
	 * @param cookies
	 * @throws InterruptedException 
	 */
	public static void setCookie(String url, List<String> cookies) throws InterruptedException {
		CookieManager cookieManager = CookieManager.getInstance();

		if (!Logger.isRealVersion()) {
			Logger.i(TAG, "setCookie url: " + url);
		}
		
		
		for (String cookie : cookies) {
			cookieManager.setCookie(url, cookie);
			
			if (!Logger.isRealVersion()) {
				Logger.i(TAG, "setCookie: " + cookie);
			}
		}

	    if (Build.VERSION.SDK_INT < 21) {
	    	CookieSyncManager.getInstance().sync();
	    } else {
	    	try {
	    		cookieManager.flush();
	    	} catch (Throwable thr) {
	    		thr.printStackTrace();
	    	}
	    }
	}

	/**
	 * .naver.com 및 nid.naver.com 쿠키를 리턴함 
	 * @return
	 */
	public static String getAllNidCookie() {
		CookieManager cookieMng = CookieManager.getInstance();
		
		try {
			cookieMng.removeExpiredCookie();
		} catch (Throwable ignore) {
			ignore.printStackTrace();
		}
		
		String cookie = cookieMng.getCookie(COOKIE_DOMAIN_NID);
		return cookie;
	}
}
