package com.nhn.android.idp.common.logger;

import com.nhn.android.idp.common.logger.Logger.ILoggerStrategy;

/*
 * UnitTest시 사용하는 Logger
 */
public class LoggerStrategySystemLog implements Logger.ILoggerStrategy {
	private static final LoggerStrategyNoLog sInstance = new LoggerStrategyNoLog();

	private static 	String 				TAG_PREFIX = "NaverLogin|";
	

	public static ILoggerStrategy getInstance() {
		return sInstance;
	}

	public static ILoggerStrategy getInstance(String tag) {
		sInstance.setTagPrefix(tag);
		return sInstance;
	}

	@Override
	public void d(String tag, String message) {
		System.out.println("[" + TAG_PREFIX + tag + "] " + message);
	}

	@Override
	public void e(String tag, String message) {
		System.out.println("[" + TAG_PREFIX + tag + "] " + message);
	}

	@Override
	public void i(String tag, String message) {
		System.out.println("[" + TAG_PREFIX + tag + "] " + message);
	}

	@Override
	public void v(String tag, String message) {
		System.out.println("[" + TAG_PREFIX + tag + "] " + message);
	}

	@Override
	public void w(String tag, String message) {
		System.out.println("[" + TAG_PREFIX + tag + "] " + message);
	}

	@Override
	public void write(int level, String tag, String message) {
		System.out.println("[" + TAG_PREFIX + tag + "] " + message);
	}

	@Override
	public void setTagPrefix(String tagPrefix) {
		TAG_PREFIX = tagPrefix;
	}
}
