package com.nhn.android.idp.common.logger;

import android.util.Log;

public class LoggerStrategyLog implements Logger.ILoggerStrategy {
	private final	static	LoggerStrategyLog 	sInstance = new LoggerStrategyLog();
	
	private static 	String 				TAG_PREFIX = "NaverLogin|";
	

	public static LoggerStrategyLog getInstance() {
		return sInstance;
	}
	
	public static LoggerStrategyLog getInstance(String tag) {
		sInstance.setTagPrefix(tag);
		return sInstance;
	}
	
	private LoggerStrategyLog() {
	}

	@Override
	public void d(String tag, String message) {
		Log.d(TAG_PREFIX + tag, message);
	}

	@Override
	public void e(String tag, String message) {
		Log.e(TAG_PREFIX + tag, message);
	}

	@Override
	public void i(String tag, String message) {
		Log.i(TAG_PREFIX + tag, message);
	}

	@Override
	public void v(String tag, String message) {
		Log.v(TAG_PREFIX + tag, message);
	}

	@Override
	public void w(String tag, String message) {
		Log.w(TAG_PREFIX + tag, message);
	}

	@Override
	public void write(int level, String tag, String message) {
		Log.println(level, TAG_PREFIX + tag, message);
	}

	@Override
	public void setTagPrefix(String tagPrefix) {
		TAG_PREFIX = tagPrefix;
	}
}
