// 로그인 중 디버그성 데이터를 남기는 로그를 켜거나 끌 수 있는 클래스를 모아둔 package
package com.nhn.android.idp.common.logger;


/*
 * Logger.java $version 1.0 Mar 31, 2010
 *
 * Copyright 2010 NHN Corp. All rights Reserved.
 * NHN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

// <b>Logging 방식을 switching 할 수 있는 class</b>
/*
 * <br/> Logging 방식을 파일로 하거나, logcat 으로 하거나, 하지 않도록 switching 할 수 있는 class 
 * 
 * @author Accenture India, gilsub.kim@nhn.com
 */
public class Logger {
	
	public interface ILoggerStrategy {
		void setTagPrefix(String tagPrefix);
		
		void i(String tag, String message);

		void w(String tag, String message);

		void d(String tag, String message);

		void e(String tag, String message);

		void v(String tag, String message);

		void write(int level, String tag, String message);
	}
	
	// TODO default ??? 로그 없게 해야하는지 
	/* default logging : logcat-logging */
	private static ILoggerStrategy logger = LoggerStrategyLog.getInstance();

	private static boolean isRealVersion = true;  
	private static String mTagPrefix = "";

	/**
	 * if want to show developer logs and sensetive logs (privacy infomation, token,  and so on) , pass realVersion as false.  
	 */	
	public static void setAsRealVersion(boolean realVersion) {
		isRealVersion = realVersion;
	}
	
	public static boolean isRealVersion() {
		return isRealVersion;
	}
	
	public static void setTagPrefix(String tagPrefix) {
		mTagPrefix = tagPrefix;
		logger.setTagPrefix(tagPrefix);
	}
	
	/**
	 * set user-custom logger
	 * @param customLogger
	 */
	public static void setLogger(ILoggerStrategy customLogger) {
		logger = customLogger;
	}
	
	public static void switchingToLogcat() {
		logger = LoggerStrategyLog.getInstance(mTagPrefix);
	}
	
	public static void switchingToNoLogging() {
		logger = LoggerStrategyNoLog.getInstance(mTagPrefix);
	}
	
	public static void i(String tag, String message) {
		logger.i(tag, message);
	}

	public static void w(String tag, String message) {
		logger.w(tag, message);
	}

	public static void d(String tag, String message) {
		logger.d(tag, message);
	}

	public static void e(String tag, String message) {
		logger.e(tag, message);
	}

	public static void v(String tag, String message) {
		logger.v(tag, message);
	}

	public static void write(int level, String tag, String message) {
		logger.write(level, tag, message);
	}

	public static void write(Exception exception) {
		if (exception == null) {
			return;
		}
		e("Exception", exception.toString());
		StackTraceElement[] elem = exception.getStackTrace();
		for (int i = 0; i < elem.length; ++i) {
			e("Exception", elem[i].toString());
		}
	}

}
