/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.mapviewer.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.location.Location;
import com.nhn.android.maps.NMapCompassManager;
import com.nhn.android.maps.NMapLocationManager;
import com.nhn.android.maps.NMapOverlay;
import com.nhn.android.maps.NMapProjection;
import com.nhn.android.maps.NMapView;
import com.nhn.android.maps.maplib.NGeoPoint;
import com.nhn.android.mapviewer.overlay.NMapResourceProvider;
import com.nhn.android.util.Assertion;

public class NMapMyLocationOverlay
extends NMapOverlay
implements NMapCompassManager.OnCompassChangeListener,
NMapLocationManager.OnLocationChangeListener {
    private final NMapView a;
    private boolean b = false;
    private volatile boolean c;
    private volatile boolean d;
    private Paint e = null;
    private Paint f = null;
    private Paint g = null;
    private final Point h = new Point();
    private final Rect i = new Rect();
    private Drawable[] j;
    private int k;
    private final Point l = new Point();
    private int m;
    private long n;
    private Drawable o;
    private boolean p;
    private final NMapLocationManager q;
    private final NMapCompassManager r;
    private NGeoPoint s;
    private Location t;
    private final ResourceProvider u;

    public NMapMyLocationOverlay(Context context, NMapView nMapView, NMapLocationManager nMapLocationManager, NMapCompassManager nMapCompassManager, ResourceProvider resourceProvider) {
        this.mIsPersistent = true;
        this.a = nMapView;
        this.c = false;
        this.d = true;
        this.s = null;
        this.t = null;
        this.q = nMapLocationManager;
        nMapLocationManager.setOnLocationChangeListener(this);
        this.r = nMapCompassManager;
        if (nMapCompassManager != null) {
            nMapCompassManager.setOnCompassChangeListener(this);
        }
        this.u = resourceProvider;
        if (this.u == null) {
            throw new IllegalArgumentException("NMapMyLocationOverlay.ResourceProvider should be provided on creation of NMapMyLocationOverlay.");
        }
        this.j = null;
        this.o = null;
        this.p = false;
    }

    public void refresh() {
        this.a.postInvalidate();
    }

    public void setCompassHeadingVisible(boolean bl) {
        this.p = bl;
        this.refresh();
    }

    public boolean isCompassHeadingVisible() {
        return this.p;
    }

    @Override
    public boolean draw(Canvas canvas, NMapView nMapView, boolean bl, long l2) {
        boolean bl2;
        if (bl) {
            return false;
        }
        boolean bl3 = bl2 = this.r != null && this.r.isCompassEnabled() && this.r.isHeadingValid();
        if (this.s != null && this.t != null) {
            this.a(canvas, nMapView, this.t, this.s, bl2, l2);
        }
        return false;
    }

    protected void a(Canvas canvas, NMapView nMapView, Location location, NGeoPoint nGeoPoint, boolean bl, long l2) {
        float f2;
        if (location == null || nGeoPoint == null) {
            return;
        }
        NMapProjection nMapProjection = nMapView.getMapProjection();
        nMapProjection.toPixels(nGeoPoint, this.h);
        this.l.set(this.h.x, this.h.y);
        boolean bl2 = false;
        if (this.c) {
            this.n = l2;
        }
        if (l2 < this.n + 4000L) {
            bl2 = true;
        }
        if (this.b) {
            bl2 = false;
        }
        this.a(bl2, l2);
        Drawable drawable2 = this.e();
        float f3 = this.k;
        if (location.hasAccuracy() && !this.b && (f2 = nMapProjection.metersToPixels(nGeoPoint, location.getAccuracy())) > f3) {
            Paint paint = null;
            paint = nMapView.getMapController().getMapViewMode() == 0 ? this.c() : this.d();
            canvas.drawCircle((float)this.h.x, (float)this.h.y, f2, this.b());
            canvas.drawCircle((float)this.h.x, (float)this.h.y, f2, paint);
        }
        if (this.p && bl) {
            this.a(canvas, this.r.getHeading());
        }
        if (drawable2 != null) {
            NMapOverlay.drawAt(canvas, drawable2, this.h.x, this.h.y, false);
        }
        int n2 = nMapView.getWidth();
        int n3 = nMapView.getHeight();
        this.i.set(0, 0, n2, n3);
        this.d = this.i.contains(this.h.x, this.h.y);
        if (this.d && bl2) {
            this.a.postInvalidateDelayed(200L);
        } else if (this.m != 0) {
            this.a.postInvalidate();
        }
        this.c = false;
    }

    protected void a(Canvas canvas, float f2) {
        Drawable drawable2 = this.f();
        if (drawable2 == null) {
            return;
        }
        canvas.save();
        canvas.translate((float)this.l.x, (float)this.l.y);
        if (this.a.isAutoRotateEnabled()) {
            canvas.rotate(-this.a.getRoateAngle());
        } else {
            canvas.rotate(f2);
        }
        NMapOverlay.drawAt(canvas, drawable2, 0, 0, false);
        canvas.restore();
    }

    @Override
    public boolean hasPathData() {
        if (this.t != null && this.t.hasAccuracy() && !this.b) {
            return true;
        }
        return this.mHasPathData;
    }

    public void didStopLocationUpdates() {
        this.b = true;
        if (this.s != null && this.a(this.a, this.s)) {
            this.a.postInvalidate();
        }
    }

    public void didStartLocationUpdates() {
        this.b = false;
    }

    @Override
    public boolean onLocationChanged(NMapLocationManager nMapLocationManager, NGeoPoint nGeoPoint) {
        boolean bl = nGeoPoint != null ? this.a(this.a, nGeoPoint) : false;
        boolean bl2 = this.s != null ? this.a(this.a, this.s) : false;
        this.c = true;
        this.s = nGeoPoint;
        this.t = this.q.getLastLocationFix();
        if (this.b) {
            if (bl || bl2) {
                this.a.invalidate();
            }
        } else if (bl) {
            this.a.postInvalidate();
        }
        return true;
    }

    @Override
    public void onLocationUpdateTimeout(NMapLocationManager nMapLocationManager) {
    }

    @Override
    public void onLocationUnavailableArea(NMapLocationManager nMapLocationManager, NGeoPoint nGeoPoint) {
    }

    public boolean onTap(NGeoPoint nGeoPoint, NMapView nMapView) {
        NGeoPoint nGeoPoint2 = this.s;
        if (nGeoPoint2 != null) {
            nMapView.getMapProjection().toPixels(nGeoPoint2, this.h);
            long l2 = this.h.x;
            long l3 = this.h.y;
            nMapView.getMapProjection().toPixels(nGeoPoint, this.h);
            long l4 = Math.abs(l2 - (long)this.h.x);
            long l5 = Math.abs(l3 - (long)this.h.y);
            float f2 = this.k;
            if ((float)(l4 * l4 + l5 * l5) < f2 * f2) {
                this.a();
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean a() {
        return false;
    }

    @Override
    public boolean onSensorChanged(NMapCompassManager nMapCompassManager, float f2) {
        if (this.d) {
            if (this.a.isAutoRotateEnabled()) {
                this.a.setRotateAngle(-f2);
            } else {
                this.a.postInvalidate();
            }
        }
        return true;
    }

    private boolean a(NMapView nMapView, NGeoPoint nGeoPoint) {
        nMapView.getMapProjection().toPixels(nGeoPoint, this.h);
        this.i.set(0, 0, nMapView.getWidth(), nMapView.getHeight());
        Drawable drawable2 = this.e();
        if (drawable2 != null) {
            int n2 = drawable2.getIntrinsicWidth();
            int n3 = drawable2.getIntrinsicHeight();
            this.i.inset(-n2, -n3);
        }
        Rect rect = this.i;
        if (nMapView.isAutoRotateEnabled()) {
            nMapView.mapPointToScreen(this.h);
        }
        return rect.contains(this.h.x, this.h.y);
    }

    private void a(boolean bl, long l2) {
        if (!bl) {
            this.m = 0;
        } else {
            long l3 = l2 - this.n;
            this.m = (int)(l3 / 400L % 2L);
        }
    }

    private Paint b() {
        if (this.e == null) {
            this.e = new Paint();
            this.e.setColor(-12146952);
            this.e.setAlpha(30);
            this.e.setStyle(Paint.Style.FILL);
        }
        return this.e;
    }

    private Paint c() {
        if (this.f == null) {
            this.f = new Paint();
            this.f.setColor(-15502111);
            this.f.setAlpha(127);
            float f2 = NMapResourceProvider.getScaleFactor() * 2.0f;
            this.f.setStrokeWidth(f2);
            this.f.setStyle(Paint.Style.STROKE);
            this.f.setAntiAlias(true);
        }
        return this.f;
    }

    private Paint d() {
        if (this.g == null) {
            this.g = new Paint();
            this.g.setColor(-1);
            this.g.setAlpha(127);
            float f2 = NMapResourceProvider.getScaleFactor() * 2.0f;
            this.g.setStrokeWidth(f2);
            this.g.setStyle(Paint.Style.STROKE);
            this.g.setAntiAlias(true);
        }
        return this.g;
    }

    private Drawable e() {
        if (this.j == null) {
            this.j = this.u.getLocationDot();
            if (!Assertion.checkNotNull(this.j)) {
                return null;
            }
            this.k = Math.max(this.j[0].getIntrinsicWidth(), this.j[0].getIntrinsicHeight()) / 2;
        }
        return this.j[this.m];
    }

    private Drawable f() {
        if (this.o == null) {
            this.o = this.u.getDirectionArrow();
        }
        return this.o;
    }

    public static interface ResourceProvider {
        public Drawable[] getLocationDot();

        public Drawable getDirectionArrow();
    }
}

