/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.maps.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.drawable.Drawable;
import com.nhn.android.maps.NMapOverlay;
import com.nhn.android.maps.NMapOverlayItem;

public class NMapCircleStyle {
    private static final float[] a = new float[]{6.67f, 3.33f};
    private final Paint b;
    private final Paint c;
    private final float d;
    private float e;
    private int f;
    private DashPathEffect g;
    private final Drawable h;

    public NMapCircleStyle(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("NMapCircleStyle cannot be created without instances of context.");
        }
        this.d = context.getResources().getDisplayMetrics().density;
        this.c = new Paint();
        this.c.setStyle(Paint.Style.FILL);
        this.setFillColor(-1, 127);
        this.b = new Paint();
        this.b.setStyle(Paint.Style.STROKE);
        this.b.setAntiAlias(true);
        this.setStrokeWidth(6.0f);
        this.setStrokeColor(-15759107, 255);
        this.f = 1;
        this.g = new DashPathEffect(new float[]{this.d * a[0], this.d * a[1]}, 1.0f);
        this.h = null;
    }

    public NMapCircleStyle(Context context, int n2) {
        if (context == null) {
            throw new IllegalArgumentException("NMapCircleStyle cannot be created without instances of context.");
        }
        this.d = 1.0f;
        this.c = null;
        this.b = null;
        this.h = context.getResources().getDrawable(n2);
        if (this.h == null) {
            throw new IllegalArgumentException("NMapCircleStyle cannot be created without instances of marker.");
        }
        if (this.h.getBounds().isEmpty()) {
            NMapOverlayItem.boundCenter(this.h);
        }
    }

    public NMapCircleStyle(Drawable drawable2) {
        if (drawable2 == null) {
            throw new IllegalArgumentException("NMapCircleStyle cannot be created without instances of marker.");
        }
        this.d = 1.0f;
        this.c = null;
        this.b = null;
        this.h = drawable2;
        if (this.h.getBounds().isEmpty()) {
            NMapOverlayItem.boundCenter(this.h);
        }
    }

    public void setLineType(int n2) {
        this.f = n2;
    }

    public void setDashPathEffect(DashPathEffect dashPathEffect) {
        this.g = dashPathEffect;
    }

    public void setStrokeWidth(float f2) {
        this.e = this.d * f2;
        if (this.b != null) {
            this.b.setStrokeWidth(this.e);
        }
    }

    public void setStrokeColor(int n2, int n3) {
        if (this.b != null) {
            this.b.setColor(n2);
            this.b.setAlpha(n3);
        }
    }

    public void setFillColor(int n2, int n3) {
        if (this.c != null) {
            this.c.setColor(n2);
            this.c.setAlpha(n3);
        }
    }

    public boolean hasCircleImage() {
        return this.h != null;
    }

    public void drawCircle(Canvas canvas, float f2, float f3, float f4) {
        if (this.h != null) {
            NMapOverlay.drawAt(canvas, this.h, Math.round(f2), Math.round(f3), false);
        } else {
            if (this.f == 2) {
                this.b.setPathEffect((PathEffect)this.g);
            } else {
                this.b.setPathEffect(null);
            }
            canvas.drawCircle(f2, f3, f4, this.c);
            canvas.drawCircle(f2, f3, f4, this.b);
        }
    }
}

