/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.maps.maplib;

import android.os.Parcel;
import android.os.Parcelable;
import com.nhn.android.maps.maplib.NMapConverter;

public class NGeoPoint
implements Parcelable {
    public double longitude;
    public double latitude;
    public static final Parcelable.Creator<NGeoPoint> CREATOR = new Parcelable.Creator<NGeoPoint>(){

        public NGeoPoint[] a(int n2) {
            return null;
        }

        public NGeoPoint a(Parcel parcel) {
            NGeoPoint nGeoPoint = new NGeoPoint(parcel.readDouble(), parcel.readDouble());
            return nGeoPoint;
        }

        public /* synthetic */ Object[] newArray(int n2) {
            return this.a(n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    public NGeoPoint() {
        this.init();
    }

    public void init() {
        this.set(0.0, 0.0);
    }

    public boolean isValid() {
        return this.longitude != 0.0 && this.latitude != 0.0;
    }

    public NGeoPoint(double d2, double d3) {
        this.set(d2, d3);
    }

    public NGeoPoint(int n2, int n3) {
        this.set(n2, n3);
    }

    public void set(double d2, double d3) {
        this.longitude = d2;
        this.latitude = d3;
    }

    public void set(int n2, int n3) {
        this.longitude = NGeoPoint.toLongitude(n2);
        this.latitude = NGeoPoint.toLatitude(n3);
    }

    public void set(NGeoPoint nGeoPoint) {
        this.set(nGeoPoint.longitude, nGeoPoint.latitude);
    }

    public int getLatitudeE6() {
        return NGeoPoint.toLatitudeE6(this.latitude);
    }

    public int getLongitudeE6() {
        return NGeoPoint.toLongitudeE6(this.longitude);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.longitude);
        stringBuilder.append(",");
        stringBuilder.append(this.latitude);
        return stringBuilder.toString();
    }

    public static double toLongitude(int n2) {
        return (double)n2 / 1000000.0;
    }

    public static double toLatitude(int n2) {
        return (double)n2 / 1000000.0;
    }

    public static int toLongitudeE6(double d2) {
        return (int)(d2 * 1000000.0);
    }

    public static int toLatitudeE6(double d2) {
        return (int)(d2 * 1000000.0);
    }

    public static double getDistance(NGeoPoint nGeoPoint, NGeoPoint nGeoPoint2) {
        return NMapConverter.distLoLa(nGeoPoint, nGeoPoint2);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeDouble(this.longitude);
        parcel.writeDouble(this.latitude);
    }
}

