/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.maps;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.Display;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import com.nhn.android.maps.NMapActivity;
import com.nhn.android.maps.NMapController;
import com.nhn.android.maps.NMapOverlay;
import com.nhn.android.maps.NMapProjection;
import com.nhn.android.maps.a;
import com.nhn.android.maps.b;
import com.nhn.android.maps.c;
import com.nhn.android.maps.d;
import com.nhn.android.maps.e;
import com.nhn.android.maps.g;
import com.nhn.android.maps.h;
import com.nhn.android.maps.i;
import com.nhn.android.maps.j;
import com.nhn.android.maps.k;
import com.nhn.android.maps.maplib.NGPoint;
import com.nhn.android.maps.maplib.NGeoPoint;
import com.nhn.android.maps.maplib.NMapConverter;
import com.nhn.android.maps.maplib.f;
import com.nhn.android.maps.nmapmodel.NMapError;
import java.util.List;

public class NMapView
extends ViewGroup {
    private boolean a = true;
    private boolean b = false;
    public static final int ANIMATION_TYPE_ZOOM = 1;
    public static final int ANIMATION_TYPE_PAN = 2;
    public static final int ANIMATION_STATE_STARTED = 1;
    public static final int ANIMATION_STATE_FINISHED = 2;
    public static final int VIEW_MODE_VECTOR = 0;
    public static final int VIEW_MODE_SATELLITE = 1;
    public static final int VIEW_MODE_HYBRID = 2;
    public static final int VIEW_MODE_TRAFFIC = 3;
    public static final int VIEW_MODE_PANORAMA = 4;
    public static final int VIEW_MODE_BICYCLE = 5;
    public static final int VIEW_MODE_MAX = com.nhn.android.maps.maplib.f.d;
    private String c = null;
    private Bitmap d = null;
    private final Rect e = new Rect();
    private com.nhn.android.maps.mapcore.d f;
    private i g;
    private NMapController h;
    private d i;
    private j j;
    private NMapProjection k;
    private e l;
    private k m;
    private a n;
    private com.nhn.android.maps.f o;
    private c p;
    private b q;
    private boolean r;
    private boolean s = false;
    private int t;
    private boolean u = false;
    private h v;
    private Bitmap w = null;
    private Canvas x = null;
    private String y = null;

    public void setOnMapViewDelegate(OnMapViewDelegate onMapViewDelegate) {
        this.l.a(onMapViewDelegate);
    }

    public void setOnMapStateChangeListener(OnMapStateChangeListener onMapStateChangeListener) {
        this.l.a(onMapStateChangeListener);
    }

    public void setOnMapStateChangeListener(OnMapStateChangeSimpleListener onMapStateChangeSimpleListener) {
        this.l.a(onMapStateChangeSimpleListener);
    }

    public void setOnMapViewTouchEventListener(OnMapViewTouchEventListener onMapViewTouchEventListener) {
        this.l.a(onMapViewTouchEventListener);
    }

    public static boolean isValidLocation(double d2, double d3) {
        boolean bl = false;
        if (NMapConverter.isValidLocation(d2, d3)) {
            NGeoPoint nGeoPoint = new NGeoPoint(d2, d3);
            int n2 = 7;
            NGeoPoint[] nGeoPointArray = new NGeoPoint[]{new NGeoPoint(124.56058, 31.98885), new NGeoPoint(124.31054, 38.60789), new NGeoPoint(132.4987, 38.53306), new NGeoPoint(132.37484, 36.66325), new NGeoPoint(127.16246, 33.30521), new NGeoPoint(127.0328, 32.02206), new NGeoPoint(124.56058, 31.98885)};
            int n3 = 6;
            boolean bl2 = false;
            int n4 = 0;
            while (n4 < 7) {
                if ((nGeoPointArray[n4].latitude < nGeoPoint.latitude && nGeoPointArray[n3].latitude >= nGeoPoint.latitude || nGeoPointArray[n3].latitude < nGeoPoint.latitude && nGeoPointArray[n4].latitude >= nGeoPoint.latitude) && nGeoPointArray[n4].longitude + (nGeoPoint.latitude - nGeoPointArray[n4].latitude) / (nGeoPointArray[n3].latitude - nGeoPointArray[n4].latitude) * (nGeoPointArray[n3].longitude - nGeoPointArray[n4].longitude) < nGeoPoint.longitude) {
                    bl2 = !bl2;
                }
                n3 = n4++;
            }
            bl = bl2;
        }
        return bl;
    }

    public NMapView(Context context) {
        super(context);
        this.a(context, null);
    }

    public NMapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.a(context, attributeSet);
    }

    public NMapView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.a(context, attributeSet);
    }

    private void a(Context context, AttributeSet attributeSet) {
        this.p = null;
        this.setWillNotDraw(false);
        if (context instanceof NMapActivity) {
            ((NMapActivity)context).setupMapView(this);
        }
    }

    protected void setup(com.nhn.android.maps.mapcore.d d2) {
        this.f = d2;
        this.g = new i(this);
        this.f.a(this.g);
        this.g.a(this.f);
        this.k = new NMapProjection(this.f);
        this.g.a(this.k);
        this.l = new e(this, this.f);
        this.h = new NMapController(this, this.f, this.g, this.k, this.l);
        this.i = this.h.a();
        this.j = this.h.b();
        this.v = new h(this, this.h);
        this.m = new k(this, this.h);
        this.h.a(this.m);
        this.p = new c();
        this.n = new a(this, this.h, this.l, this.p);
        this.o = new com.nhn.android.maps.f(this.m.a());
        this.q = new b(this);
    }

    protected i getMapTileRenderer() {
        return this.g;
    }

    protected k getMapZoomController() {
        return this.m;
    }

    protected a getMapGestureDetector() {
        return this.n;
    }

    protected e getMapStateReporter() {
        return this.l;
    }

    protected b getMapLibrary() {
        return this.q;
    }

    public void handleMapInitialized(NMapError nMapError) {
        this.l.a(nMapError);
    }

    public void setNcpClientId(String string) {
        this.y = string;
    }

    protected String getNcpClientId() {
        return this.y;
    }

    public void setAppName(String string) {
        this.c = string;
    }

    protected String getAppName() {
        return this.c;
    }

    public void setBlankTileImage(int n2) {
        if (this.d == null) {
            this.d = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)n2);
        }
        if (this.d != null) {
            this.g.a(this.d);
        }
    }

    protected void a() {
        if (this.d == null) {
            this.d = this.q.a();
        }
        if (this.d != null) {
            this.g.a(this.d);
        }
    }

    public void setBackgroundColor(int n2) {
        this.j.a(n2);
    }

    public boolean setScalingFactor(float f2) {
        if (this.k.setScalingFactor(f2)) {
            this.g.a(this.d, f2);
            this.h.h();
            this.k.a(this.getWidth(), this.getHeight());
            this.h.i();
            this.p.a(this.getWidth(), this.getHeight());
            this.h.reload();
            return true;
        }
        return false;
    }

    public boolean setScalingFactor(float f2, boolean bl) {
        boolean bl2 = this.k.isMapHD();
        this.k.a(bl);
        boolean bl3 = this.setScalingFactor(f2);
        if (!bl3 && this.k.isProjectionScaled() && bl2 != this.k.isMapHD()) {
            this.h.reload();
        }
        return bl3;
    }

    public void setClipBounds(int n2, int n3, int n4, int n5) {
        this.h.a(n2, n3, n4, n5);
    }

    public Rect getClipBounds() {
        return this.h.g();
    }

    public void setLogoImageOffset(int n2, int n3) {
        this.q.b(n2, n3);
    }

    protected void b() {
        this.q.d();
    }

    public NMapController getMapController() {
        return this.h;
    }

    public NMapProjection getMapProjection() {
        return this.k;
    }

    public final List<NMapOverlay> getOverlays() {
        return this.p.a();
    }

    public void setBuiltInZoomControls(boolean bl, LayoutParams layoutParams) {
        View view = this.m.a(layoutParams);
        if (bl) {
            if (view.getParent() == null) {
                this.addView(view);
            }
            this.m.a(false);
        } else if (view.getParent() != null) {
            this.removeView(view);
        }
        this.r = bl;
    }

    public void displayZoomControls(boolean bl) {
        if (this.r) {
            View view = this.m.a((LayoutParams)null);
            if (view.getParent() == null) {
                this.addView(view);
            }
            this.m.a(bl);
        }
    }

    public void setBuiltInAppControl(boolean bl) {
        this.s = bl;
    }

    protected void c() {
        View view;
        if (this.s && (view = this.q.b()).getParent() == null) {
            this.addView(view);
        }
    }

    public void executeNaverMap() {
        this.q.c();
    }

    protected void d() {
        this.h.r();
    }

    protected void e() {
        this.h.s();
    }

    public void setPanWithTouchMoveEvent(boolean bl) {
        this.a = bl;
    }

    public boolean getPanWithTouchMoveEvent() {
        return this.a;
    }

    public void setAutoRotateEnabled(boolean bl, boolean bl2) {
        if (this.u != bl && !this.v.a()) {
            if (bl || bl2) {
                this.u = bl;
                this.v.a(0.0f);
            } else {
                this.v.a(0.0f, true);
            }
        }
    }

    protected void f() {
        this.u = false;
        ViewParent viewParent = this.getParent();
        if (viewParent != null && viewParent instanceof View) {
            ((View)viewParent).requestLayout();
        }
    }

    public boolean isAutoRotateEnabled() {
        return this.u;
    }

    public void setRotateAngle(float f2) {
        if (this.u) {
            if (this.h.c()) {
                return;
            }
            this.v.a(f2);
        }
    }

    public float getRoateAngle() {
        if (this.u) {
            return this.v.b();
        }
        return 0.0f;
    }

    public void mapPoints(float[] fArray) {
        if (this.u) {
            this.v.a(fArray);
        }
    }

    public void mapPoint(Point point) {
        if (this.u) {
            this.v.a(point);
        }
    }

    public void mapPointFromScreen(Point point) {
        if (this.u) {
            this.v.b(point);
        }
    }

    public void mapDeltaFromScreen(NGPoint nGPoint, boolean bl) {
        if (this.u) {
            this.v.a(nGPoint, bl);
        }
    }

    public void mapDeltaFromScreen(int[] nArray, boolean bl) {
        if (this.u) {
            this.v.a(nArray, bl);
        }
    }

    public void mapPointToScreen(Point point) {
        if (this.u) {
            this.v.c(point);
        }
    }

    private void a(MotionEvent motionEvent) {
        if (this.u) {
            this.v.a(motionEvent);
        }
    }

    public void computeScroll() {
        if (this.n.b()) {
            return;
        }
        super.computeScroll();
    }

    protected boolean a(int n2, int n3) {
        return n2 == this.getWidth() / 2 && n3 == this.getHeight() / 2;
    }

    protected void onDraw(Canvas canvas) {
        Canvas canvas2;
        if (!this.u) {
            canvas.getClipBounds(this.e);
            if (!Rect.intersects((Rect)this.h.g(), (Rect)this.e)) {
                return;
            }
        }
        this.h.t();
        boolean bl = false;
        Bitmap bitmap = this.a(canvas);
        if (bitmap != null && (canvas2 = this.x) != null) {
            this.b(canvas2);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
            bl = true;
        }
        if (!bl) {
            this.b(canvas);
        }
        if (this.t > 0) {
            this.h();
        }
    }

    private Bitmap a(Canvas canvas) {
        if (com.nhn.android.maps.g.a().b(canvas)) {
            if (!this.p.b()) {
                if (this.w != null) {
                    this.w.recycle();
                    this.w = null;
                }
                this.x = null;
                return null;
            }
            int n2 = canvas.getWidth();
            int n3 = canvas.getHeight();
            if (this.w == null || this.w.getWidth() != n2 || this.w.getHeight() != n3) {
                if (this.w != null) {
                    this.w.recycle();
                }
                Bitmap.Config config = com.nhn.android.maps.mapcore.e.a;
                if (this.isAutoRotateEnabled()) {
                    config = Bitmap.Config.RGB_565;
                }
                try {
                    this.w = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)config);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    outOfMemoryError.printStackTrace();
                    if (config != Bitmap.Config.RGB_565) {
                        config = Bitmap.Config.RGB_565;
                        try {
                            this.w = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)config);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (this.w != null) {
                    this.x = new Canvas(this.w);
                }
            }
            return this.w;
        }
        return null;
    }

    private void b(Canvas canvas) {
        long l2 = this.getDrawingTime();
        boolean bl = false;
        if (this.u) {
            bl = this.v.a(canvas, this, l2);
            canvas.save(1);
            this.v.a(canvas);
        }
        boolean bl2 = this.a(canvas, l2);
        if (this.u) {
            canvas.restore();
            if (bl && !bl2) {
                this.invalidate();
            }
        }
        this.q.a(canvas);
    }

    private boolean a(Canvas canvas, long l2) {
        boolean bl = false;
        boolean bl2 = true;
        if (this.j != null) {
            bl2 = this.j.a(l2);
        }
        if (bl2) {
            this.g.a(canvas);
        }
        if (this.j != null) {
            bl |= this.j.a(canvas, this, l2);
        }
        bl |= this.p.a(canvas, this, l2);
        if (this.i != null) {
            bl |= this.i.a(l2);
        }
        if (bl) {
            this.invalidate();
        }
        return bl;
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        com.nhn.android.maps.maplib.c c2 = this.k.a();
        if (!c2.b(n2, n3)) {
            this.h.a(n2, n3);
            this.g.a(n2, n3);
        }
        this.p.a(n2, n3);
    }

    protected void onWindowVisibilityChanged(int n2) {
        if (n2 == 0) {
            // empty if block
        }
        super.onWindowVisibilityChanged(n2);
    }

    public void onWindowFocusChanged(boolean bl) {
        if (!bl && this.i != null) {
            this.i.d();
        }
        super.onWindowFocusChanged(bl);
    }

    public void onFocusChanged(boolean bl, int n2, Rect rect) {
        if (!bl && this.i != null) {
            this.i.d();
        }
        super.onFocusChanged(bl, n2, rect);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.isEnabled() || !this.isClickable()) {
            return false;
        }
        if (this.m.a(motionEvent)) {
            return true;
        }
        if (this.u) {
            this.a(motionEvent);
        }
        if (this.p.a(motionEvent, this)) {
            return true;
        }
        if (this.a) {
            switch (motionEvent.getAction()) {
                case 0: {
                    this.b = false;
                    break;
                }
                case 2: {
                    if (!this.h.v()) {
                        this.b = true;
                        this.h.a(motionEvent);
                        this.l.b(motionEvent);
                        return true;
                    }
                    if (!this.b) break;
                    this.h.b(motionEvent);
                    return true;
                }
                case 1: {
                    if (this.b) {
                        this.h.c(motionEvent);
                        this.l.c(motionEvent);
                        break;
                    }
                }
                case 3: {
                    if (!this.b) break;
                    this.h.c(motionEvent);
                    this.l.c(motionEvent);
                }
            }
            if (this.b) {
                this.b = false;
                return true;
            }
        }
        this.n.a(motionEvent);
        switch (motionEvent.getAction()) {
            case 1: {
                this.h.c(motionEvent);
                this.l.c(motionEvent);
                break;
            }
            case 3: {
                this.h.c(motionEvent);
                this.l.c(motionEvent);
            }
        }
        return true;
    }

    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        if (this.p.a(n2, keyEvent, this)) {
            return true;
        }
        if (this.h.a((View)this, n2, keyEvent)) {
            return true;
        }
        return super.onKeyDown(n2, keyEvent);
    }

    public boolean onKeyUp(int n2, KeyEvent keyEvent) {
        if (this.p.b(n2, keyEvent, this)) {
            return true;
        }
        if (this.h.b((View)this, n2, keyEvent)) {
            return true;
        }
        return super.onKeyUp(n2, keyEvent);
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        if (this.p.b(motionEvent, this)) {
            return true;
        }
        this.o.a(motionEvent);
        if (this.o.a()) {
            this.i.a((int)(motionEvent.getX() * 40.0f), (int)(motionEvent.getY() * 40.0f));
        } else if (this.o.b()) {
            this.p.a(this.getWidth() / 2, this.getHeight() / 2, this);
        }
        return false;
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    protected LayoutParams g() {
        return new LayoutParams(-2, -2);
    }

    protected LayoutParams a(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    protected void onMeasure(int n2, int n3) {
        this.b(n2, n3);
        this.h.f();
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        this.q.f();
        this.a(bl, n2, n3, n4, n5);
    }

    private void b(int n2, int n3) {
        this.measureChildren(n2, n3);
        int n4 = super.getMeasuredWidth();
        int n5 = super.getMeasuredHeight();
        if (n4 == 0 || n5 == 0) {
            WindowManager windowManager = (WindowManager)this.getContext().getSystemService("window");
            Display display = windowManager.getDefaultDisplay();
            if (n4 == 0) {
                n4 = display.getWidth();
            }
            if (n5 == 0) {
                n5 = display.getHeight();
            }
        }
        this.setMeasuredDimension(NMapView.resolveSize((int)n4, (int)n2), NMapView.resolveSize((int)n5, (int)n3));
    }

    private void h() {
        int n2 = this.getChildCount();
        Point point = new Point();
        int n3 = super.getWidth();
        int n4 = super.getHeight();
        int n5 = 0;
        int n6 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl;
            View view = this.getChildAt(i2);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            boolean bl2 = bl = layoutParams.mode == 0;
            if (!bl) continue;
            this.k.toPixels(layoutParams.point, point);
            if (this.isAutoRotateEnabled()) {
                this.mapPointToScreen(point);
            }
            point.x += layoutParams.px;
            point.y += layoutParams.py;
            int n7 = view.getMeasuredWidth();
            int n8 = view.getMeasuredHeight();
            int n9 = point.x;
            int n10 = point.y;
            int n11 = layoutParams.gravity;
            switch (n11 & 7) {
                case 1: {
                    if (bl) {
                        n9 -= n7 / 2;
                        break;
                    }
                    n9 = (n3 - n7) / 2;
                    break;
                }
                case 5: {
                    if (bl) {
                        n9 -= n7 - 1;
                        break;
                    }
                    n9 = n3 - 1 - n7;
                }
            }
            switch (n11 & 0x70) {
                case 16: {
                    if (bl) {
                        n10 -= n8 / 2;
                        break;
                    }
                    n10 = (n4 - n8) / 2;
                    break;
                }
                case 80: {
                    if (bl) {
                        n10 -= n8 - 1;
                        break;
                    }
                    n10 = n4 - 1 - n8;
                }
            }
            if (n5 > 0 && n6 > 0) {
                switch (n11 & 7) {
                    case 3: {
                        if (bl) break;
                        n9 += (n3 - n5) / 2;
                        break;
                    }
                    case 5: {
                        if (bl) break;
                        n9 += (n5 - n3) / 2;
                    }
                }
                switch (n11 & 0x70) {
                    case 48: {
                        if (bl) break;
                        n10 += (n4 - n6) / 2;
                        break;
                    }
                    case 80: {
                        if (bl) break;
                        n10 += (n6 - n4) / 2;
                    }
                }
            }
            int n12 = super.getPaddingLeft() + n9;
            int n13 = super.getPaddingTop() + n10;
            view.layout(n12, n13, n12 + n7, n13 + n8);
        }
    }

    private void a(boolean bl, int n2, int n3, int n4, int n5) {
        ViewParent viewParent;
        int n6 = this.getChildCount();
        this.t = 0;
        Point point = new Point();
        int n7 = super.getWidth();
        int n8 = super.getHeight();
        int n9 = 0;
        int n10 = 0;
        if (this.isAutoRotateEnabled() && (viewParent = this.getParent()) != null && viewParent instanceof View) {
            n9 = ((View)viewParent).getWidth();
            n10 = ((View)viewParent).getHeight();
            if (bl) {
                this.v.c();
                this.h.b((n7 - n9) / 2, (n8 - n10) / 2, n9, n10);
            }
        }
        for (int i2 = 0; i2 < n6; ++i2) {
            boolean bl2;
            View view = this.getChildAt(i2);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            boolean bl3 = bl2 = layoutParams.mode == 0;
            if (bl2) {
                ++this.t;
                this.k.toPixels(layoutParams.point, point);
                point.x += layoutParams.px;
                point.y += layoutParams.py;
            } else {
                point.x = layoutParams.px;
                point.y = layoutParams.py;
            }
            int n11 = view.getMeasuredWidth();
            int n12 = view.getMeasuredHeight();
            int n13 = point.x;
            int n14 = point.y;
            int n15 = layoutParams.gravity;
            switch (n15 & 7) {
                case 1: {
                    if (bl2) {
                        n13 -= n11 / 2;
                        break;
                    }
                    n13 = (n7 - n11) / 2;
                    break;
                }
                case 5: {
                    if (bl2) {
                        n13 -= n11 - 1;
                        break;
                    }
                    n13 = n7 - 1 - n11;
                }
            }
            switch (n15 & 0x70) {
                case 16: {
                    if (bl2) {
                        n14 -= n12 / 2;
                        break;
                    }
                    n14 = (n8 - n12) / 2;
                    break;
                }
                case 80: {
                    if (bl2) {
                        n14 -= n12 - 1;
                        break;
                    }
                    n14 = n8 - 1 - n12;
                }
            }
            if (n9 > 0 && n10 > 0) {
                switch (n15 & 7) {
                    case 3: {
                        if (bl2) break;
                        n13 += (n7 - n9) / 2;
                        break;
                    }
                    case 5: {
                        if (bl2) break;
                        n13 += (n9 - n7) / 2;
                    }
                }
                switch (n15 & 0x70) {
                    case 48: {
                        if (bl2) break;
                        n14 += (n8 - n10) / 2;
                        break;
                    }
                    case 80: {
                        if (bl2) break;
                        n14 += (n10 - n8) / 2;
                    }
                }
                if (this.s && this.q.a(n14, n15)) {
                    n14 = this.q.a(n9, n10, n11, n12);
                    n14 += n8 - 1 - n12;
                    n14 += (n10 - n8) / 2;
                }
            } else if (this.s && this.q.a(n14, n15)) {
                n14 = this.q.a(n7, n8, n11, n12);
                n14 += n8 - 1 - n12;
            }
            int n16 = super.getPaddingLeft() + n13;
            int n17 = super.getPaddingTop() + n14;
            view.layout(n16, n17, n16 + n11, n17 + n12);
        }
    }

    protected /* synthetic */ ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return this.g();
    }

    protected /* synthetic */ ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return this.a(layoutParams);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public static final int MODE_MAP = 0;
        public static final int MODE_VIEW = 1;
        public static final int LEFT = 3;
        public static final int RIGHT = 5;
        public static final int TOP = 48;
        public static final int BOTTOM = 80;
        public static final int CENTER_HORIZONTAL = 1;
        public static final int CENTER_VERTICAL = 16;
        public static final int CENTER = 17;
        public static final int TOP_LEFT = 51;
        public static final int TOP_RIGHT = 53;
        public static final int BOTTOM_CENTER = 81;
        public static final int BOTTOM_RIGHT = 85;
        public int mode;
        public NGeoPoint point;
        public int px;
        public int py;
        public int gravity;

        public LayoutParams(int n2, int n3, NGeoPoint nGeoPoint, int n4) {
            this(n2, n3, nGeoPoint, 0, 0, n4);
        }

        public LayoutParams(int n2, int n3, NGeoPoint nGeoPoint, int n4, int n5, int n6) {
            super(n2, n3);
            this.mode = 0;
            this.point = nGeoPoint;
            this.px = n4;
            this.py = n5;
            this.gravity = n6;
        }

        public LayoutParams(int n2, int n3, int n4, int n5, int n6) {
            super(n2, n3);
            this.mode = 1;
            this.px = n4;
            this.py = n5;
            this.gravity = n6;
        }

        public LayoutParams(int n2, int n3) {
            this(n2, n3, 0, 0, 17);
        }

        public LayoutParams(int n2, int n3, int n4) {
            this(n2, n3, 0, 0, n4);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.mode = 1;
            this.px = 0;
            this.py = 0;
            this.gravity = 17;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }
    }

    public static interface OnMapViewDelegate {
        public boolean isLocationTracking();
    }

    public static interface OnMapViewTouchEventListener {
        public void onLongPress(NMapView var1, MotionEvent var2);

        public void onLongPressCanceled(NMapView var1);

        public void onTouchDown(NMapView var1, MotionEvent var2);

        public void onTouchUp(NMapView var1, MotionEvent var2);

        public void onScroll(NMapView var1, MotionEvent var2, MotionEvent var3);

        public void onSingleTapUp(NMapView var1, MotionEvent var2);
    }

    public static interface OnMapStateChangeSimpleListener {
        public void didChangeMapLevel(NMapView var1);

        public void didChangeMapCenter(NMapView var1);

        public void didFinishAnimation(NMapView var1);

        public void didChangeZoomLevelConstraint(NMapView var1);
    }

    public static interface OnMapStateChangeListener {
        public void onMapInitHandler(NMapView var1, NMapError var2);

        public void onMapCenterChange(NMapView var1, NGeoPoint var2);

        public void onMapCenterChangeFine(NMapView var1);

        public void onZoomLevelChange(NMapView var1, int var2);

        public void onAnimationStateChange(NMapView var1, int var2, int var3);
    }
}

