/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.maps;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import com.nhn.android.maps.FusedLocationManager;
import com.nhn.android.maps.maplib.NGeoPoint;
import com.nhn.android.maps.maplib.NMapConverter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NMapLocationManager
implements LocationListener {
    private static boolean a = false;
    private static boolean b = false;
    private static boolean c = true;
    private long d = 1000L;
    private float e = 1.5f;
    private long f = 0L;
    private volatile boolean g = false;
    private long h = 2000L;
    private float i = 50.0f;
    private long j = 0L;
    private Location k;
    private boolean l;
    private volatile boolean m = false;
    private final LocationManager n;
    private FusedLocationManager o;
    private boolean p;
    private volatile boolean q = false;
    private volatile Location r = null;
    private volatile NGeoPoint s = null;
    private volatile NGeoPoint t = null;
    private final List<OnLocationChangeListener> u = new LinkedList<OnLocationChangeListener>();
    private FusedLocationManager.OnLocationListener v = new FusedLocationManager.OnLocationListener(){

        @Override
        public void onLocationChanged(FusedLocationManager fusedLocationManager, Location location) {
            if (!NMapLocationManager.this.m) {
                return;
            }
            if (location != null) {
                NMapLocationManager.this.onLocationChanged(location);
            }
        }

        @Override
        public void onConnected(FusedLocationManager fusedLocationManager, Location location) {
            if (!NMapLocationManager.this.m) {
                return;
            }
            if (!NMapLocationManager.this.p) {
                NMapLocationManager.this.p = true;
                NMapLocationManager.this.n.removeUpdates((LocationListener)NMapLocationManager.this);
            }
            if (location != null) {
                if (NMapLocationManager.this.k != null) {
                    NMapLocationManager.this.onLocationChanged(location);
                } else {
                    long l2 = Calendar.getInstance().getTime().getTime();
                    NMapLocationManager.this.a(location, l2);
                }
            }
        }

        @Override
        public void onDisconnected(FusedLocationManager fusedLocationManager) {
            if (!NMapLocationManager.this.m) {
                return;
            }
        }

        @Override
        public void onConnectionFailed(FusedLocationManager fusedLocationManager) {
            if (!NMapLocationManager.this.m) {
                return;
            }
        }
    };
    private final Handler w = new Handler();
    private final Runnable x = new Runnable(){

        @Override
        public void run() {
            if (!NMapLocationManager.this.q && NMapLocationManager.this.m) {
                NMapLocationManager.this.a();
            }
        }
    };
    private final Runnable y = new Runnable(){

        @Override
        public void run() {
            if (NMapLocationManager.this.g && NMapLocationManager.this.m) {
                NMapLocationManager.this.g = false;
                NMapLocationManager.this.b();
            }
        }
    };
    private final Runnable z = new Runnable(){

        @Override
        public void run() {
            if (NMapLocationManager.this.s != null && NMapLocationManager.this.m) {
                NMapLocationManager.this.a(NMapLocationManager.this.s);
            }
        }
    };

    public NMapLocationManager(Context context) {
        this(context, false);
    }

    public NMapLocationManager(Context context, boolean bl) {
        this.n = (LocationManager)context.getSystemService("location");
        if (bl && Build.VERSION.SDK_INT >= 9) {
            try {
                Class<?> clazz = Class.forName("com.google.android.gms.location.LocationRequest");
                if (clazz != null) {
                    this.o = new FusedLocationManager(context, this.v);
                }
            }
            catch (Exception exception) {
                Log.w((String)"NMapLocationManager", (String)"com.google.android.gms package does not found...");
            }
        }
    }

    public synchronized void setOnLocationChangeListener(OnLocationChangeListener onLocationChangeListener) {
        if (!this.u.contains(onLocationChangeListener)) {
            this.u.add(onLocationChangeListener);
        }
    }

    public synchronized void removeOnLocationChangeListener(OnLocationChangeListener onLocationChangeListener) {
        if (this.u.contains(onLocationChangeListener)) {
            this.u.remove(onLocationChangeListener);
        }
    }

    public final synchronized List<OnLocationChangeListener> getLocationChangeListenrs() {
        return this.u;
    }

    public void setUpdateFrequency(long l2, float f2) {
        this.d = l2;
        this.e = f2;
        if (this.o != null) {
            this.o.setUpdateFrequency(l2, f2);
        }
    }

    public void setStartTimeout(long l2) {
        this.h = l2;
    }

    public void setStartAccuracy(float f2) {
        this.i = f2;
    }

    public static boolean hasLocationProvider(Context context) {
        boolean bl = false;
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        if (locationManager == null) {
            return bl;
        }
        List list = locationManager.getAllProviders();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = (String)list.get(i2);
            boolean bl2 = locationManager.isProviderEnabled(string);
            if (!bl2 || !string.equals("gps") && !string.equals("network")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isMyLocationEnabled() {
        return this.m;
    }

    public synchronized boolean enableMyLocation(boolean bl) {
        if (!this.m) {
            if (this.n == null) {
                return false;
            }
            List list = this.n.getAllProviders();
            if (list == null || list.size() < 1) {
                return false;
            }
            String string = null;
            long l2 = Calendar.getInstance().getTime().getTime();
            Location[] locationArray = new Location[list.size()];
            int n2 = 0;
            for (String string2 : list) {
                boolean bl2 = this.n.isProviderEnabled(string2);
                if (!string2.equals("gps") && !string2.equals("network")) continue;
                this.n.requestLocationUpdates(string2, this.d, this.e, (LocationListener)this);
                if (!bl2) continue;
                this.m = true;
                Location location = this.n.getLastKnownLocation(string2);
                if (location != null) {
                    this.a(location, -9);
                }
                if (location == null || bl) continue;
                try {
                    locationArray[n2++] = location;
                }
                catch (Exception exception) {
                    Log.w((String)"NMapLocationManager", (String)("enableMyLocation: Couldn't get provider for " + string2));
                }
            }
            if (!this.m) {
                this.n.removeUpdates((LocationListener)this);
                Log.w((String)"NMapLocationManager", (String)"enableMyLocation: None of the desired Location Providers are available.");
            } else {
                this.f = Calendar.getInstance().getTime().getTime();
                this.g = true;
                if (this.g) {
                    this.w.postDelayed(this.y, this.h + 3000L);
                }
                this.r = null;
                this.j = 0L;
                this.k = null;
                this.l = false;
                this.w.postDelayed(this.x, 15000L);
                if (n2 > 0) {
                    Arrays.sort(locationArray, 0, n2, new a());
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string2;
                        string2 = locationArray[i2];
                        if (string2 != null) {
                            this.a((Location)string2, -8);
                        }
                        if (!this.a((Location)string2, (Location)string)) continue;
                        string = string2;
                    }
                }
                if (string != null) {
                    this.a((Location)string, l2);
                }
                if (this.o != null) {
                    this.p = false;
                    this.o.start();
                }
            }
        } else if (this.isMyLocationFixed() && this.r != null) {
            this.onLocationChanged(this.r);
        } else if (!this.q) {
            this.w.removeCallbacks(this.x);
            this.w.postDelayed(this.x, 15000L);
        }
        return this.m;
    }

    private void a(Location location, long l2) {
        this.a(location, -7);
        this.k = new Location(location);
        long l3 = location.getTime();
        if (l2 - l3 <= 30000L && l2 >= l3) {
            this.l = true;
        }
        this.onLocationChanged(this.k);
    }

    public synchronized void disableMyLocation() {
        if (this.m) {
            if (this.n == null) {
                return;
            }
            if (!this.p) {
                this.n.removeUpdates((LocationListener)this);
            }
            if (this.o != null) {
                this.o.stop();
            }
            this.m = false;
            this.s = null;
            this.t = null;
            this.q = false;
            this.w.removeCallbacks(this.x);
            this.g = false;
            this.w.removeCallbacks(this.y);
        }
    }

    public Location getLastLocationFix() {
        return this.r;
    }

    public NGeoPoint getMyLocation() {
        return this.s;
    }

    public boolean isMyLocationFixed() {
        return this.s != null;
    }

    public NGeoPoint getPreviousLocation() {
        return this.t;
    }

    public boolean isLastKnownLocation(NGeoPoint nGeoPoint) {
        return this.k != null && this.k.getLongitude() == nGeoPoint.longitude && this.k.getLatitude() == nGeoPoint.latitude;
    }

    private boolean a(Location location, Location location2) {
        boolean bl;
        if (location == null) {
            return false;
        }
        if (this.k != null && location2 != null) {
            if (this.k == location2) {
                location2 = null;
            } else {
                this.k = null;
            }
        }
        if (location2 == null || location == location2) {
            return true;
        }
        if (c) {
            if (location.getProvider().equals("gps")) {
                return true;
            }
            if (this.j > 0L && Calendar.getInstance().getTime().getTime() - this.j > 60000L) {
                return true;
            }
            if (location2.getProvider().equals("gps") && this.j > 0L && Calendar.getInstance().getTime().getTime() - this.j < 20000L) {
                return false;
            }
            if (location.getAccuracy() - location2.getAccuracy() > 200.0f) {
                return false;
            }
            return location2.getProvider().equals("gps") || location.getProvider().equals(location2.getProvider()) || this.j <= 0L || Calendar.getInstance().getTime().getTime() - this.j >= 20000L || !(location.getAccuracy() - location2.getAccuracy() > 0.0f);
        }
        long l2 = location.getTime() - location2.getTime();
        boolean bl2 = l2 > 60000L;
        boolean bl3 = l2 < -60000L;
        boolean bl4 = bl = l2 > 0L;
        if (this.j > 0L && Calendar.getInstance().getTime().getTime() - this.j > 60000L) {
            bl2 = true;
        }
        if (bl2) {
            return true;
        }
        if (bl3) {
            return false;
        }
        int n2 = (int)(location.getAccuracy() - location2.getAccuracy());
        boolean bl5 = n2 > 0;
        boolean bl6 = n2 < 0;
        boolean bl7 = n2 > 200;
        boolean bl8 = this.a(location.getProvider(), location2.getProvider());
        if (bl6) {
            return true;
        }
        if (bl && !bl5) {
            return true;
        }
        return bl && !bl7 && bl8;
    }

    private boolean a(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string.equals(string2)) {
            return true;
        }
        return string.equals("gps");
    }

    private boolean a(Location location) {
        if (this.k == location && !this.l) {
            return false;
        }
        if (location.getAccuracy() > this.i) {
            if (this.f > 0L && location.getAccuracy() <= 200.0f) {
                long l2 = Calendar.getInstance().getTime().getTime() - this.f;
                if (l2 > 0L && l2 < this.h) {
                    this.w.removeCallbacks(this.y);
                    this.w.postDelayed(this.y, this.h - l2);
                } else {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public synchronized void onLocationChanged(Location location) {
        if (!this.m) {
            this.a(location, -3);
            return;
        }
        if (!NMapConverter.isValidLocation(location.getLongitude(), location.getLatitude())) {
            Log.w((String)"NMapLocationManager", (String)("onLocationChanged: Invalid location=" + location.getLongitude() + ", " + location.getLatitude() + ", accuracy=" + location.getAccuracy()));
            this.s = new NGeoPoint(location.getLongitude(), location.getLatitude());
            this.w.post(this.z);
            this.a(location, -2);
            return;
        }
        if (!this.a(location, this.r)) {
            this.a(location, -1);
            return;
        }
        this.r = location;
        this.j = Calendar.getInstance().getTime().getTime();
        if (this.g) {
            if (!this.a(location)) {
                this.a(location, 0);
                return;
            }
            this.g = false;
            this.w.removeCallbacks(this.y);
        }
        if (!this.q) {
            this.q = true;
            this.w.removeCallbacks(this.x);
        }
        this.t = this.s;
        this.s = new NGeoPoint(location.getLongitude(), location.getLatitude());
        Iterator<OnLocationChangeListener> iterator = this.u.iterator();
        while (iterator.hasNext()) {
            OnLocationChangeListener onLocationChangeListener = iterator.next();
            if (onLocationChangeListener.onLocationChanged(this, this.s)) continue;
            iterator.remove();
        }
        this.a(location, 1);
    }

    public void onProviderDisabled(String string) {
    }

    public void onProviderEnabled(String string) {
    }

    public void onStatusChanged(String string, int n2, Bundle bundle) {
    }

    private void a() {
        for (OnLocationChangeListener onLocationChangeListener : this.u) {
            onLocationChangeListener.onLocationUpdateTimeout(this);
        }
    }

    private void b() {
        if (this.r != null) {
            this.onLocationChanged(this.r);
        }
    }

    private void a(NGeoPoint nGeoPoint) {
        for (OnLocationChangeListener onLocationChangeListener : this.u) {
            onLocationChangeListener.onLocationUnavailableArea(this, nGeoPoint);
        }
    }

    private void a(Location location, int n2) {
        if (!a) {
            return;
        }
        if (!b) {
            b = true;
            com.nhn.android.util.a.a("", "===========================");
            com.nhn.android.util.a.a("", "latitude,longitude,accuracy,provider,location time,current time,elapsed time,result");
        }
        String string = location.getLatitude() + "," + location.getLongitude() + "," + location.getAccuracy() + "," + location.getProvider() + "," + com.nhn.android.util.a.a(location.getTime(), "MM-dd HH:mm:ss") + "," + com.nhn.android.util.a.a(Calendar.getInstance().getTime().getTime(), "MM-dd HH:mm:ss") + "," + (double)(location.getTime() - this.f) / 1000.0 + "," + String.valueOf(n2);
        com.nhn.android.util.a.a("", string);
    }

    private class a
    implements Comparator<Location> {
        public int a(Location location, Location location2) {
            long l2;
            long l3 = location.getTime();
            if (l3 < (l2 = location2.getTime())) {
                return -1;
            }
            return l2 <= l3 ? 0 : 1;
        }

        a() {
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((Location)object, (Location)object2);
        }
    }

    public static interface OnLocationChangeListener {
        public boolean onLocationChanged(NMapLocationManager var1, NGeoPoint var2);

        public void onLocationUpdateTimeout(NMapLocationManager var1);

        public void onLocationUnavailableArea(NMapLocationManager var1, NGeoPoint var2);
    }
}

