/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.maps;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;

public class FusedLocationManager
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    public static final int CONNECTION_FAILURE_RESOLUTION_REQUEST = 9000;
    public static final int MILLISECONDS_PER_SECOND = 1000;
    public static final int UPDATE_INTERVAL_IN_SECONDS = 1;
    public static final float LOCATION_UPDATE_MIN_DISTANCE = 1.5f;
    public static final int FAST_CEILING_IN_SECONDS = 1;
    public static final long UPDATE_INTERVAL_IN_MILLISECONDS = 1000L;
    public static final long FAST_INTERVAL_CEILING_IN_MILLISECONDS = 1000L;
    private LocationRequest a;
    private GoogleApiClient b;
    private final Context c;
    private final OnLocationListener d;

    public FusedLocationManager(Context context, OnLocationListener onLocationListener) {
        this.c = context;
        this.d = onLocationListener;
        this.a = LocationRequest.create();
        this.a.setInterval(1000L);
        this.a.setSmallestDisplacement(1.5f);
        this.a.setPriority(100);
        this.b = new GoogleApiClient.Builder(this.c).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
    }

    public void setUpdateFrequency(long l2, float f2) {
        this.a.setInterval(l2);
        this.a.setSmallestDisplacement(f2);
    }

    public void start() {
        this.b.connect();
    }

    public void stop() {
        this.b.disconnect();
    }

    public Location getLastLocation() {
        if (FusedLocationManager.a(this.c)) {
            return LocationServices.FusedLocationApi.getLastLocation(this.b);
        }
        return null;
    }

    public void startUpdates() {
        if (FusedLocationManager.a(this.c)) {
            this.a();
        }
    }

    public void stopUpdates() {
        if (FusedLocationManager.a(this.c)) {
            this.b();
        }
    }

    private void a() {
        if (this.b.isConnected()) {
            LocationServices.FusedLocationApi.requestLocationUpdates(this.b, this.a, (LocationListener)this);
        }
    }

    private void b() {
        if (this.b.isConnected()) {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.b, (LocationListener)this);
        }
    }

    public void onConnected(Bundle bundle) {
        this.d.onConnected(this, this.getLastLocation());
        this.a();
    }

    public void onConnectionSuspended(int n2) {
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        this.d.onConnectionFailed(this);
    }

    public void onLocationChanged(Location location) {
        this.d.onLocationChanged(this, location);
    }

    private static boolean a(Context context) {
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
        return 0 == n2;
    }

    public static interface OnLocationListener {
        public void onLocationChanged(FusedLocationManager var1, Location var2);

        public void onConnected(FusedLocationManager var1, Location var2);

        public void onDisconnected(FusedLocationManager var1);

        public void onConnectionFailed(FusedLocationManager var1);
    }
}

