/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.maps;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Log;
import com.nhn.android.maps.mapcore.d;
import com.nhn.android.maps.mapcore.e;
import com.nhn.android.maps.maplib.NGPoint;
import com.nhn.android.maps.maplib.NGeoPoint;
import com.nhn.android.maps.maplib.NMapConverter;
import com.nhn.android.maps.maplib.a;
import com.nhn.android.maps.maplib.b;
import com.nhn.android.maps.maplib.c;
import com.nhn.android.maps.maplib.f;

public class NMapProjection {
    private final d a;
    private float b = 1.0f;
    private final c c = new c();
    private final Matrix d = new Matrix();
    private final Matrix e = new Matrix();
    private final float[] f = new float[2];
    private final Point g = new Point();

    protected NMapProjection(d d2) {
        this.a = d2;
        this.c();
    }

    protected void a(boolean bl) {
        if (com.nhn.android.maps.maplib.f.c) {
            this.a.g().a(bl);
        }
    }

    public boolean isMapHD() {
        if (com.nhn.android.maps.maplib.f.c) {
            return this.a.g().c();
        }
        return false;
    }

    public boolean setScalingFactor(float f2) {
        if (!com.nhn.android.maps.maplib.a.a(f2, this.b)) {
            this.b = f2;
            if (com.nhn.android.maps.maplib.f.c && this.isMapHD() && !this.isProjectionScaled()) {
                this.a(false);
            }
            return true;
        }
        return false;
    }

    public boolean isProjectionScaled() {
        return !com.nhn.android.maps.maplib.a.a(this.b, 1.0f);
    }

    protected c a() {
        return this.c;
    }

    protected boolean a(int n2, int n3) {
        this.c.a(n2, n3);
        if (this.isProjectionScaled()) {
            n2 = (int)((float)n2 / this.b);
            n3 = (int)((float)n3 / this.b);
        }
        return this.a.a(n2, n3);
    }

    protected boolean b() {
        if (this.c.a > 0 && this.c.b > 0) {
            return this.a(this.c.a, this.c.b);
        }
        return false;
    }

    protected b a(e e2, b b2, RectF rectF) {
        b b3 = this.a.e();
        b b4 = e2.r();
        b2.a.px = b4.a.px - b3.a.px;
        b2.a.py = b4.a.py - b3.a.py;
        b2.b.a = b4.b.a;
        b2.b.b = b4.b.b;
        if (this.isProjectionScaled()) {
            float f2 = (float)b2.a.px * this.b;
            float f3 = (float)b2.a.py * this.b;
            float f4 = (float)b2.b.a * this.b;
            float f5 = (float)b2.b.b * this.b;
            f2 = Math.round(f2);
            f3 = Math.round(f3);
            f3 = (float)this.c.b - (f3 + f5);
            b2.a.px = (int)f2;
            b2.a.py = (int)f3;
            b2.b.a = (int)f4;
            b2.b.b = (int)f5;
            rectF.left = f2;
            rectF.top = f3;
            rectF.right = f2 + f4;
            rectF.bottom = f3 + f5;
        } else {
            b2.a.py = this.c.b - (b2.a.py + b2.b.b);
        }
        return b2;
    }

    protected NGPoint a(NGPoint nGPoint) {
        if (this.isProjectionScaled()) {
            nGPoint.px = (int)((float)nGPoint.px / this.b);
            nGPoint.py = (int)((float)nGPoint.py / this.b);
        }
        return nGPoint;
    }

    protected void b(NGPoint nGPoint) {
        nGPoint = this.a(nGPoint);
        this.a.a(nGPoint);
    }

    protected NGPoint b(int n2, int n3) {
        b b2 = this.a.e();
        NGPoint nGPoint = new NGPoint(n2, n3);
        if (this.isProjectionScaled()) {
            nGPoint.px = b2.a.px + (int)((float)n2 / this.b);
            nGPoint.py = b2.a.py + (int)((float)(this.c.b - n3) / this.b);
        } else {
            nGPoint.px = b2.a.px + n2;
            nGPoint.py = b2.a.py + (this.c.b - n3);
        }
        return nGPoint;
    }

    protected NGPoint c(NGPoint nGPoint) {
        b b2 = this.a.e();
        if (this.isProjectionScaled()) {
            nGPoint.px = (int)((float)(nGPoint.px - b2.a.px) * this.b);
            nGPoint.py = this.c.b - (int)((float)(nGPoint.py - b2.a.py) * this.b);
        } else {
            nGPoint.px -= b2.a.px;
            nGPoint.py = this.c.b - (nGPoint.py - b2.a.py);
        }
        return nGPoint;
    }

    public NGPoint toSizeInScreen(NGPoint nGPoint) {
        if (this.isProjectionScaled()) {
            nGPoint.px = (int)((float)nGPoint.px * this.b);
            nGPoint.py = (int)((float)nGPoint.py * this.b);
        }
        return nGPoint;
    }

    public b getViewPort() {
        return this.a.e();
    }

    protected void c() {
        this.d.reset();
        this.e.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(Matrix matrix, float f2, NGeoPoint nGeoPoint, float f3, float f4) {
        float f5;
        float f6;
        this.d.reset();
        Point point = this.g;
        synchronized (point) {
            this.toPixels(nGeoPoint, this.g);
            this.d.postTranslate((float)(-this.g.x), (float)(-this.g.y));
            this.d.postScale(f2, f2);
            this.d.postTranslate(f3, f4);
            f6 = (float)this.g.x - f3;
            f5 = (float)this.g.y - f4;
        }
        matrix.postTranslate(f6, f5);
        this.d.postConcat(matrix);
        if (!this.d.invert(this.e)) {
            Log.e((String)"NMapProjection", (String)("Setting singular matrix " + this.d));
        }
    }

    private void d() {
        this.f[0] = this.g.x;
        this.f[1] = this.g.y;
        this.d.mapPoints(this.f);
        this.g.x = (int)this.f[0];
        this.g.y = (int)this.f[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NGPoint c(int n2, int n3) {
        Point point = this.g;
        synchronized (point) {
            this.f[0] = n2;
            this.f[1] = n3;
            this.e.mapPoints(this.f);
            n2 = (int)this.f[0];
            n3 = (int)this.f[1];
        }
        return this.b(n2, n3);
    }

    public NGeoPoint fromPixels(int n2, int n3) {
        NGPoint nGPoint = this.c(n2, n3);
        return this.a.c(nGPoint);
    }

    public NGPoint fromPixelsInUtmk(int n2, int n3) {
        NGPoint nGPoint = this.c(n2, n3);
        return this.a.b(nGPoint);
    }

    public float metersToPixels(float f2) {
        NGeoPoint nGeoPoint = this.a.v();
        return this.d.mapRadius(this.a(nGeoPoint, f2, this.a.A()));
    }

    public float metersToPixels(NGeoPoint nGeoPoint, float f2) {
        return this.d.mapRadius(this.a(nGeoPoint, f2, this.a.A()));
    }

    protected float a(NGeoPoint nGeoPoint, float f2, int n2) {
        NGPoint nGPoint = NMapConverter.grs2UtmK(nGeoPoint);
        com.nhn.android.maps.maplib.d d2 = new com.nhn.android.maps.maplib.d(n2, nGPoint.px, nGPoint.py);
        d2 = NMapConverter.getMapIndexFromUTMK(d2, null);
        NGPoint nGPoint2 = NMapConverter.getPointFromMapIndex(d2);
        nGPoint2 = this.c(nGPoint2);
        double d3 = NMapConverter.findLongitudeForDistance(nGeoPoint.longitude, nGeoPoint.latitude, f2);
        NGPoint nGPoint3 = NMapConverter.grs2UtmK(new NGeoPoint(d3, nGeoPoint.latitude));
        d2.a(n2, nGPoint3.px, nGPoint3.py);
        d2 = NMapConverter.getMapIndexFromUTMK(d2, null);
        NGPoint nGPoint4 = NMapConverter.getPointFromMapIndex(d2);
        nGPoint4 = this.c(nGPoint4);
        return com.nhn.android.maps.maplib.a.a(Math.abs(nGPoint2.px - nGPoint4.px), Math.abs(nGPoint2.py - nGPoint4.py));
    }

    public Point toPixels(NGeoPoint nGeoPoint, Point point) {
        NGPoint nGPoint = NMapConverter.grs2UtmK(nGeoPoint);
        return this.a(nGPoint, point, true);
    }

    protected Point a(NGeoPoint nGeoPoint, Point point, boolean bl) {
        NGPoint nGPoint = NMapConverter.grs2UtmK(nGeoPoint);
        return this.a(nGPoint, point, bl);
    }

    public Point toPixels(NGPoint nGPoint, Point point) {
        return this.a(nGPoint, point, true);
    }

    protected Point a(NGPoint nGPoint, Point point, boolean bl) {
        int n2 = this.a.A();
        NGPoint nGPoint2 = NMapConverter.toPointInMapCoordinates(n2, nGPoint.px, nGPoint.py);
        nGPoint2 = this.c(nGPoint2);
        this.g.x = nGPoint2.px;
        this.g.y = nGPoint2.py;
        if (bl) {
            this.d();
        }
        if (point == null) {
            point = new Point();
        }
        point.x = this.g.x;
        point.y = this.g.y;
        return point;
    }

    public Rect toBoundsUTMK(Rect rect, Rect rect2) {
        if (rect2 == null) {
            rect2 = new Rect();
        }
        NGeoPoint nGeoPoint = new NGeoPoint(rect.left, rect.top);
        NGPoint nGPoint = NMapConverter.grs2UtmK(nGeoPoint);
        rect2.left = nGPoint.px;
        rect2.top = nGPoint.py;
        nGeoPoint.set(rect.right, rect.bottom);
        nGPoint = NMapConverter.grs2UtmK(nGeoPoint);
        rect2.right = nGPoint.px;
        rect2.bottom = nGPoint.py;
        return rect2;
    }

    public Rect getScreenBoundsE6() {
        Rect rect = new Rect();
        b b2 = this.a.e();
        NGPoint nGPoint = new NGPoint();
        nGPoint.px = b2.a.px;
        nGPoint.py = b2.a.py + b2.b.b;
        NGeoPoint nGeoPoint = this.a.c(nGPoint);
        rect.left = nGeoPoint.getLongitudeE6();
        rect.top = nGeoPoint.getLatitudeE6();
        nGPoint.px = b2.a.px + b2.b.a;
        nGPoint.py = b2.a.py;
        nGeoPoint = this.a.c(nGPoint);
        rect.right = nGeoPoint.getLongitudeE6();
        rect.bottom = nGeoPoint.getLatitudeE6();
        return rect;
    }

    public Rect getScreenBoundsE6(double d2) {
        Rect rect = new Rect();
        b b2 = this.a.e();
        NGPoint nGPoint = new NGPoint();
        nGPoint.px = b2.a.px + b2.b.a / 2;
        nGPoint.py = b2.a.py + b2.b.b / 2;
        d2 = Math.sqrt(d2);
        NGPoint nGPoint2 = new NGPoint();
        nGPoint2.px = nGPoint.px - (int)((double)(nGPoint.px - b2.a.px) * d2);
        nGPoint2.py = nGPoint.py + (int)((double)(b2.a.py + b2.b.b - nGPoint.py) * d2);
        NGeoPoint nGeoPoint = this.a.c(nGPoint2);
        rect.left = nGeoPoint.getLongitudeE6();
        rect.top = nGeoPoint.getLatitudeE6();
        nGPoint2.px = nGPoint.px + (int)((double)(b2.a.px + b2.b.a - nGPoint.px) * d2);
        nGPoint2.py = nGPoint.py - (int)((double)(nGPoint.py - b2.a.py) * d2);
        nGeoPoint = this.a.c(nGPoint2);
        rect.right = nGeoPoint.getLongitudeE6();
        rect.bottom = nGeoPoint.getLatitudeE6();
        return rect;
    }

    public int getLatitudeSpan() {
        NGeoPoint nGeoPoint = this.fromPixels(0, 0);
        NGeoPoint nGeoPoint2 = this.fromPixels(this.c.a, this.c.b);
        return nGeoPoint.getLatitudeE6() - nGeoPoint2.getLatitudeE6();
    }

    public int getLongitudeSpan() {
        NGeoPoint nGeoPoint = this.fromPixels(0, 0);
        NGeoPoint nGeoPoint2 = this.fromPixels(this.c.a, this.c.b);
        return nGeoPoint2.getLongitudeE6() - nGeoPoint.getLongitudeE6();
    }

    public c getScreenBoundsSpan() {
        NGeoPoint nGeoPoint = this.fromPixels(0, 0);
        NGeoPoint nGeoPoint2 = this.fromPixels(this.c.a, this.c.b);
        c c2 = new c();
        c2.a = nGeoPoint2.getLongitudeE6() - nGeoPoint.getLongitudeE6();
        c2.b = nGeoPoint.getLatitudeE6() - nGeoPoint2.getLatitudeE6();
        return c2;
    }

    public b getScreenBoundsInUtmk() {
        NGPoint nGPoint = this.fromPixelsInUtmk(0, 0);
        NGPoint nGPoint2 = this.fromPixelsInUtmk(this.c.a, this.c.b);
        b b2 = new b();
        b2.a.px = nGPoint.px;
        b2.a.py = nGPoint2.py;
        b2.b.a = nGPoint2.px - nGPoint.px;
        b2.b.b = nGPoint.py - nGPoint2.py;
        return b2;
    }

    protected b a(b b2) {
        NGPoint nGPoint = this.fromPixelsInUtmk(b2.a.px, b2.a.py);
        NGPoint nGPoint2 = this.fromPixelsInUtmk(b2.a.px + b2.b.a, b2.a.py + b2.b.b);
        b b3 = new b();
        b3.a.px = nGPoint.px;
        b3.a.py = nGPoint2.py;
        b3.b.a = nGPoint2.px - nGPoint.px;
        b3.b.b = nGPoint.py - nGPoint2.py;
        return b3;
    }
}

