/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.mapviewer.overlay;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.nhn.android.maps.NMapOverlay;
import com.nhn.android.maps.NMapOverlayItem;
import com.nhn.android.maps.NMapView;
import com.nhn.android.maps.g;
import com.nhn.android.maps.maplib.NGeoPoint;
import com.nhn.android.maps.maplib.e;
import com.nhn.android.util.Assertion;

public abstract class NMapCalloutOverlay
extends NMapOverlay {
    private static boolean a = true;
    private boolean b = false;
    protected NMapOverlayItem mOverlayItem;
    protected Rect mItemBounds;
    protected int mInGestureMask;
    private int[] c;
    private int d;
    private int e;
    protected OnClickListener mOnClickListener;
    protected NMapOverlay mItemOverlay;
    protected final Point mTempPoint = new Point();
    protected final Rect mTempRect = new Rect();
    protected final RectF mTempRectF = new RectF();
    private final Point f = new Point();
    private e g;
    private boolean h;

    public NMapCalloutOverlay(NMapOverlay nMapOverlay, NMapOverlayItem nMapOverlayItem, Rect rect) {
        this.mOverlayItem = nMapOverlayItem;
        this.mItemBounds = rect;
        this.mInGestureMask = 0;
        this.e = -1;
        this.d = -1;
        this.mOnClickListener = null;
        this.mItemOverlay = nMapOverlay;
        this.g = new e((Interpolator)new LinearInterpolator(), 200L);
    }

    public static void setScaleAnimation(boolean bl) {
        a = bl;
    }

    public void setCalloutAdjustToCenter(boolean bl) {
        this.b = bl;
    }

    @Override
    public boolean draw(Canvas canvas, NMapView nMapView, boolean bl, long l2) {
        this.h = false;
        if (!bl) {
            canvas.save();
            this.drawCallout(canvas, nMapView, bl, l2);
            canvas.restore();
        }
        return this.h;
    }

    @Override
    public boolean onTap(int n2, int n3, NMapView nMapView) {
        if (nMapView.isAutoRotateEnabled()) {
            Point point = this.a(n2, n3, nMapView);
            n2 = point.x;
            n3 = point.y;
        }
        if (this.hitTest(n2, n3)) {
            return this.onTap(0);
        }
        return false;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent, NMapView nMapView) {
        return this.a(true, 1, motionEvent, nMapView, nMapView.getWidth() / 2, nMapView.getHeight() / 2);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent, NMapView nMapView) {
        return this.a(false, 2, motionEvent, nMapView, (int)motionEvent.getX(), (int)motionEvent.getY());
    }

    protected boolean hitTest(int n2, int n3) {
        return this.mTempRectF.contains((float)n2, (float)n3);
    }

    protected boolean onTap(int n2) {
        if (this.mOnClickListener != null) {
            this.mOnClickListener.onClick(this, this.mItemOverlay, this.mOverlayItem);
        }
        return true;
    }

    public void setOnClickListener(OnClickListener onClickListener) {
        this.mOnClickListener = onClickListener;
    }

    public void adjustBounds(NMapView nMapView, boolean bl) {
        if (this.b) {
            NGeoPoint nGeoPoint = this.mOverlayItem.getPoint();
            if (bl) {
                nMapView.getMapController().animateTo(nGeoPoint, true);
            } else {
                nMapView.getMapController().setMapCenter(nGeoPoint);
            }
        } else {
            Rect rect = nMapView.getMapController().getBoundsVisible();
            Rect rect2 = this.getBounds(nMapView);
            if (nMapView.isAutoRotateEnabled()) {
                rect2 = this.a(nMapView, rect2);
            }
            int n2 = this.getMarginX();
            boolean bl2 = this.isTitleTruncated();
            if (!rect.contains(rect2) || bl2) {
                int n3 = 0;
                if (bl2 || rect2.width() >= rect.width()) {
                    n3 = rect2.centerX();
                } else {
                    if (rect2.left < rect.left) {
                        n3 = rect.left - rect2.left + n2;
                    } else if (rect2.right > rect.right) {
                        n3 = rect.right - rect2.right - n2;
                    }
                    n3 = rect.centerX() - n3;
                }
                int n4 = 0;
                if (rect2.top < rect.top) {
                    n4 = rect.top - rect2.top + n2;
                } else if (rect2.bottom > rect.bottom) {
                    n4 = rect.bottom - rect2.bottom - n2;
                }
                n4 = rect.centerY() - n4;
                if (nMapView.isAutoRotateEnabled()) {
                    this.f.x = n3;
                    this.f.y = n4;
                    nMapView.mapPointFromScreen(this.f);
                    n3 = this.f.x;
                    n4 = this.f.y;
                }
                NGeoPoint nGeoPoint = nMapView.getMapProjection().fromPixels(n3, n4);
                if (bl) {
                    nMapView.getMapController().animateTo(nGeoPoint, true);
                } else {
                    nMapView.getMapController().setMapCenter(nGeoPoint);
                }
            }
        }
        this.a(nMapView);
    }

    private Rect a(NMapView nMapView, Rect rect) {
        this.f.x = rect.centerX();
        this.f.y = rect.bottom;
        nMapView.mapPointToScreen(this.f);
        int n2 = rect.width();
        int n3 = rect.height();
        rect.left = this.f.x - n2 / 2;
        rect.top = this.f.y - n3;
        rect.right = rect.left + n2;
        rect.bottom = rect.top + n3;
        return rect;
    }

    public boolean isCalloutInVisibleBounds(NMapView nMapView) {
        if (!this.isHidden()) {
            Rect rect = nMapView.getMapController().getBoundsVisible();
            Rect rect2 = this.getBounds(nMapView);
            if (nMapView.isAutoRotateEnabled()) {
                rect2 = this.a(nMapView, rect2);
            }
            return Rect.intersects((Rect)rect, (Rect)rect2);
        }
        return false;
    }

    private void a(NMapView nMapView) {
        if (a) {
            if (!Assertion.checkNotNull(this.g)) {
                return;
            }
            this.g.a(0.5f, 1.0f);
            this.g.a(true);
            nMapView.postInvalidate();
        }
    }

    protected void stepAnimations(Canvas canvas, NMapView nMapView, long l2) {
        Matrix matrix;
        if (nMapView.isAutoRotateEnabled()) {
            matrix = canvas.getMatrix();
            matrix.preRotate(-nMapView.getRoateAngle(), (float)this.mTempPoint.x, (float)this.mTempPoint.y);
            canvas.setMatrix(matrix);
        }
        if (a && com.nhn.android.maps.g.a().a(canvas)) {
            return;
        }
        if (a) {
            if (!Assertion.checkNotNull(this.g)) {
                return;
            }
            if (this.g.b(l2)) {
                if (!this.g.a()) {
                    this.g.b();
                    this.h = true;
                }
            } else {
                matrix = this.getSclaingPivot();
                float f2 = this.g.c(l2);
                Matrix matrix2 = canvas.getMatrix();
                matrix2.preScale(f2, f2, matrix.x, matrix.y);
                canvas.setMatrix(matrix2);
                this.h = true;
            }
        }
    }

    protected abstract boolean isTitleTruncated();

    protected abstract int getMarginX();

    protected abstract Rect getBounds(NMapView var1);

    protected abstract PointF getSclaingPivot();

    protected abstract void drawCallout(Canvas var1, NMapView var2, boolean var3, long var4);

    protected abstract Drawable getDrawable(int var1, int var2);

    protected int getItemState(int n2) {
        return this.c[n2];
    }

    protected void setItemCount(int n2) {
        if (n2 > 0) {
            this.c = new int[n2];
        }
    }

    protected int getItemCount() {
        if (this.c == null) {
            return 0;
        }
        return this.c.length;
    }

    private Point a(int n2, int n3, NMapView nMapView) {
        if (nMapView.isAutoRotateEnabled()) {
            Point point = this.f;
            point.x = n2 - this.mTempPoint.x;
            point.y = n3 - this.mTempPoint.y;
            nMapView.mapPoint(point);
            n2 = point.x + this.mTempPoint.x;
            n3 = point.y + this.mTempPoint.y;
        }
        this.f.x = n2;
        this.f.y = n3;
        return this.f;
    }

    private int b(int n2, int n3, NMapView nMapView) {
        if (nMapView.isAutoRotateEnabled()) {
            Point point = this.a(n2, n3, nMapView);
            n2 = point.x;
            n3 = point.y;
        }
        if (this.c != null) {
            int n4 = this.c.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                Rect rect;
                int n5 = this.c[i2];
                Drawable drawable2 = this.getDrawable(i2, n5);
                if (drawable2 == null || (rect = drawable2.getBounds()) == null || !rect.contains(n2, n3)) continue;
                return i2;
            }
        }
        if (this.hitTest(n2, n3)) {
            return 0;
        }
        return -1;
    }

    private boolean a(boolean bl, int n2, MotionEvent motionEvent, NMapView nMapView, int n3, int n4) {
        boolean bl2;
        int n5;
        int n6 = motionEvent.getAction();
        boolean bl3 = n6 == 0;
        boolean bl4 = bl3 || n6 == 2;
        int n7 = this.b(n3, n4, nMapView);
        boolean bl5 = n7 != -1;
        int n8 = n5 = bl ? n7 : -1;
        if (com.nhn.android.maps.g.a().a(motionEvent) > 1) {
            n7 = -1;
            bl5 = false;
            this.b(-1, nMapView);
        }
        this.a(n5, nMapView);
        if (bl3) {
            this.mInGestureMask = bl5 ? (this.mInGestureMask |= n2) : (this.mInGestureMask &= ~n2);
        }
        boolean bl6 = bl2 = (this.mInGestureMask & n2) != 0;
        if (bl2) {
            if (bl4) {
                this.b(n7, nMapView);
                if (nMapView.getPanWithTouchMoveEvent() && !bl5 && n6 == 2) {
                    this.b(-1, nMapView);
                    this.mInGestureMask &= ~n2;
                    return false;
                }
            } else if (n6 == 1) {
                this.b(-1, nMapView);
                if (bl5) {
                    this.onTap(n7);
                }
                this.mInGestureMask &= ~n2;
            }
        }
        return bl2;
    }

    private void a(int n2, NMapView nMapView) {
        if (this.c != null) {
            this.e = this.a(this.e, n2, 2, nMapView);
        }
    }

    private void b(int n2, NMapView nMapView) {
        if (this.c != null) {
            this.d = this.a(this.d, n2, 1, nMapView);
        }
    }

    private int a(int n2, int n3, int n4, NMapView nMapView) {
        if (n2 != n3) {
            if (n2 != -1) {
                int n5 = n2;
                this.c[n5] = this.c[n5] & ~n4;
            }
            if (n3 != -1) {
                int n6 = n3;
                this.c[n6] = this.c[n6] | n4;
            }
            nMapView.postInvalidate();
        }
        return n3;
    }

    public static interface OnClickListener {
        public void onClick(NMapCalloutOverlay var1, NMapOverlay var2, NMapOverlayItem var3);
    }
}

