/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.maps.maplib;

import android.util.Log;
import com.nhn.android.maps.maplib.NGPoint;
import com.nhn.android.maps.maplib.NGeoPoint;
import com.nhn.android.maps.maplib.c;
import com.nhn.android.maps.maplib.d;
import com.nhn.android.maps.maplib.f;
import java.util.Formatter;

public class NMapConverter {
    public static final int MAP_TILE_WIDTH = 256;
    public static final int MAP_TILE_HEIGHT = 256;
    public static final c MAP_TILE_SIZE = new c(256, 256);
    public static final NGeoPoint NMAP_LOCATION_MIN = new NGeoPoint(120.0, 31.0);
    public static final NGeoPoint NMAP_LOCATION_MAX = new NGeoPoint(139.0, 43.0);
    public static final NGPoint NMAP_LOCATION_MIN_UTMK = new NGPoint(342830384, 142479225);
    public static final NGPoint NMAP_LOCATION_MAX_UTMK = new NGPoint(359377608, 156191544);
    static final int[][] a = new int[][]{{4, 3}, {8, 6}, {16, 12}, {32, 24}, {64, 48}, {128, 96}, {256, 192}, {512, 384}, {1024, 768}, {2048, 1536}, {4096, 3072}, {8192, 6144}, {16384, 12288}, {32768, 24576}, {65536, 49152}, {131072, 98304}};
    static final int[] b = new int[]{0x500000, 0x280000, 0x140000, 655360, 327680, 163840, 81920, 40960, 20480, 10240, 5120, 2560, 1280, 640, 320, 160};
    private static double c = 2.2252947962927703;
    private static double d = 0.6632251157578453;
    private static double e = 0.9996;
    private static double f = 1000000.0;
    private static double g = 2000000.0;
    private static double h = 4.0680631590769E13;
    private static double i = 4.040829998332806E13;
    private static double j = (h - i) / i;
    private static double k = (h - i) / h;
    private static double l = NMapConverter.c(k);
    private static double m = NMapConverter.d(k);
    private static double n = NMapConverter.e(k);
    private static double o = NMapConverter.f(k);
    private static double p = 6378137.0 * NMapConverter.a(l, m, n, o, d);

    public static boolean isValidLocation(double d2, double d3) {
        return d2 > NMAP_LOCATION_MIN.getLongitude() && d2 < NMAP_LOCATION_MAX.getLongitude() && d3 > NMAP_LOCATION_MIN.getLatitude() && d3 < NMAP_LOCATION_MAX.getLatitude();
    }

    public static boolean isValidLocation(int n2, int n3) {
        return n2 > NMapConverter.NMAP_LOCATION_MIN_UTMK.px && n2 < NMapConverter.NMAP_LOCATION_MAX_UTMK.px && n3 > NMapConverter.NMAP_LOCATION_MIN_UTMK.py && n3 < NMapConverter.NMAP_LOCATION_MAX_UTMK.py;
    }

    public static boolean isValidMapLevel(int n2) {
        return n2 >= 1 && n2 <= 16;
    }

    public static int getMaxZoomLevel() {
        return 14;
    }

    public static int getMinZoomLevel() {
        return 1;
    }

    public static int getMaxZoomLevelIndoor() {
        return 16;
    }

    public static int getMinZoomLevelIndoor() {
        return 12;
    }

    public static synchronized boolean isMapTileScaled(int n2, int n3) {
        return false;
    }

    public static boolean isValidZoomLevel(int n2, int n3) {
        return n2 <= n3 && NMapConverter.isValidMapLevel(n2) && NMapConverter.isValidMapLevel(n3);
    }

    public static int adjustMapLevel(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 > 16) {
            n2 = 16;
        }
        return n2;
    }

    public static int getTileOriginX(int n2) {
        return n2 * 256;
    }

    public static int getTileOriginY(int n2) {
        return n2 * 256;
    }

    public static NGPoint getTileOrigin(int n2, int n3) {
        return new NGPoint(NMapConverter.getTileOriginX(n2), NMapConverter.getTileOriginY(n3));
    }

    public static c getTileSize() {
        return MAP_TILE_SIZE;
    }

    public static c getMapSize(int n2) {
        return new c(NMapConverter.getMapTileHorzCount(n2) * 256, NMapConverter.getMapTileVertCount(n2) * 256);
    }

    public static NGPoint getPointFromMapIndex(d d2) {
        return new NGPoint(d2.f * 256 + d2.d, d2.g * 256 + d2.e);
    }

    public static NGPoint toPointInMapCoordinates(int n2, int n3, int n4) {
        d d2 = new d(n2, n3, n4);
        d2 = NMapConverter.getMapIndexFromUTMK(d2, null);
        NGPoint nGPoint = NMapConverter.getPointFromMapIndex(d2);
        return nGPoint;
    }

    public static d getMapIndexParamAt(int n2, NGPoint nGPoint) {
        d d2 = new d();
        d2.c = n2;
        d2.f = nGPoint.px / 256;
        d2.g = nGPoint.py / 256;
        d2.d = nGPoint.px - d2.f * 256;
        d2.e = nGPoint.py - d2.g * 256;
        return d2;
    }

    public static NGPoint getUtmkFromPoint(NGPoint nGPoint, int n2) {
        d d2 = NMapConverter.getMapIndexParamAt(n2, nGPoint);
        d2 = NMapConverter.getUTMKFromMapIndex(d2);
        return new NGPoint(d2.a, d2.b);
    }

    public static NGPoint grs2UtmK(NGeoPoint nGeoPoint) {
        return NMapConverter.grs2UtmK(nGeoPoint.longitude, nGeoPoint.latitude);
    }

    public static NGeoPoint utmK2Grs(NGPoint nGPoint) {
        return NMapConverter.utmK2Grs(nGPoint.px, nGPoint.py);
    }

    public static NGPoint grs2UtmK(double d2, double d3) {
        double d4 = d2 * (Math.PI / 180);
        double d5 = d3 * (Math.PI / 180);
        double d6 = NMapConverter.a(d4 - c);
        double d7 = Math.sin(d5);
        double d8 = Math.cos(d5);
        double d9 = d8 * d6;
        double d10 = Math.pow(d9, 2.0);
        double d11 = j * Math.pow(d8, 2.0);
        double d12 = Math.tan(d5);
        double d13 = Math.pow(d12, 2.0);
        double d14 = 1.0 - k * Math.pow(d7, 2.0);
        double d15 = 6378137.0 / Math.sqrt(d14);
        double d16 = 6378137.0 * NMapConverter.a(l, m, n, o, d5);
        double d17 = e * d15 * d9 * (1.0 + d10 / 6.0 * (1.0 - d13 + d11 + d10 / 20.0 * (5.0 - 18.0 * d13 + Math.pow(d13, 2.0) + 72.0 * d11 - 58.0 * j))) + f;
        double d18 = e * (d16 - p + d15 * d12 * (d10 * (0.5 + d10 / 24.0 * (5.0 - d13 + 9.0 * d11 + 4.0 * Math.pow(d11, 2.0) + d10 / 30.0 * (61.0 - 58.0 * d13 + Math.pow(d13, 2.0) + 600.0 * d11 - 330.0 * j))))) + g;
        d17 = d17 * 10.0 + 3.4E8;
        d18 = d18 * 10.0 + 1.3E8;
        return new NGPoint((int)d17, (int)d18);
    }

    public static NGeoPoint utmK2Grs(int n2, int n3) {
        double d2;
        int n4 = 6;
        double d3 = (double)(n2 - 340000000) / 10.0;
        double d4 = (double)(n3 - 130000000) / 10.0;
        d3 -= f;
        double d5 = d2 = (p + (d4 -= g) / e) / 6378137.0;
        int n5 = 0;
        while (true) {
            double d6 = (d2 + m * Math.sin(2.0 * d5) - n * Math.sin(4.0 * d5) + o * Math.sin(6.0 * d5)) / l - d5;
            d5 += d6;
            if (Math.abs(d6) <= 1.0E-10) break;
            if (n5 >= n4) {
                return null;
            }
            ++n5;
        }
        double d7 = Math.sin(d5);
        double d8 = Math.cos(d5);
        double d9 = Math.tan(d5);
        double d10 = j * Math.pow(d8, 2.0);
        double d11 = Math.pow(d10, 2.0);
        double d12 = Math.pow(d9, 2.0);
        double d13 = Math.pow(d12, 2.0);
        d2 = 1.0 - k * Math.pow(d7, 2.0);
        double d14 = 6378137.0 / Math.sqrt(d2);
        double d15 = d14 * (1.0 - k) / d2;
        double d16 = d3 / (d14 * e);
        double d17 = Math.pow(d16, 2.0);
        double d18 = d5 - d14 * d9 * d17 / d15 * (0.5 - d17 / 24.0 * (5.0 + 3.0 * d12 + 10.0 * d10 - 4.0 * d11 - 9.0 * j - d17 / 30.0 * (61.0 + 90.0 * d12 + 298.0 * d10 + 45.0 * d13 - 252.0 * j - 3.0 * d11)));
        double d19 = NMapConverter.a(c + d16 * (1.0 - d17 / 6.0 * (1.0 + 2.0 * d12 + d10 - d17 / 20.0 * (5.0 - 2.0 * d10 + 28.0 * d12 - 3.0 * d11 + 8.0 * j + 24.0 * d13))) / d8);
        return new NGeoPoint(d19 *= 57.29577951308232, d18 *= 57.29577951308232);
    }

    public static double distLoLa(NGeoPoint nGeoPoint, NGeoPoint nGeoPoint2) {
        return NMapConverter.distLoLa(nGeoPoint.longitude, nGeoPoint.latitude, nGeoPoint2.longitude, nGeoPoint2.latitude);
    }

    public static double distLoLa(double d2, double d3, double d4, double d5) {
        double d6 = 0.006694380022918163;
        double d7 = Math.sin(d2 * (Math.PI / 180));
        double d8 = Math.cos(d2 * (Math.PI / 180));
        double d9 = Math.sin(d3 * (Math.PI / 180));
        double d10 = Math.cos(d3 * (Math.PI / 180));
        double d11 = Math.sin(d4 * (Math.PI / 180));
        double d12 = Math.cos(d4 * (Math.PI / 180));
        double d13 = Math.sin(d5 * (Math.PI / 180));
        double d14 = Math.cos(d5 * (Math.PI / 180));
        double d15 = 6378137.0 / Math.sqrt(1.0 - d6 * d9 * d9);
        double d16 = 6378137.0 / Math.sqrt(1.0 - d6 * d13 * d13);
        double d17 = d15 * d10 * d8;
        double d18 = d15 * d10 * d7;
        double d19 = d15 * 6356752.3141403 * 6356752.3141403 / 4.0680631590769E13 * d9;
        double d20 = d16 * d14 * d12;
        double d21 = d16 * d14 * d11;
        double d22 = d16 * 6356752.3141403 * 6356752.3141403 / 4.0680631590769E13 * d13;
        return Math.sqrt((d20 - d17) * (d20 - d17) + (d21 - d18) * (d21 - d18) + (d22 - d19) * (d22 - d19));
    }

    public static d getMapIndexFromUTMK(d d2, f f2) {
        int n2 = d2.a;
        int n3 = d2.b;
        int n4 = d2.c;
        d2.f = NMapConverter.a(n2, n4);
        d2.g = NMapConverter.b(n3, n4);
        d2.d = NMapConverter.c(n2, n4);
        d2.e = NMapConverter.d(n3, n4);
        if (f2 != null) {
            int n5 = d2.f / 64;
            int n6 = d2.g / 64;
            int n7 = n5 / 16;
            int n8 = n6 / 16;
            int n9 = (d2.f + d2.g) % 4;
            if (!f2.a(d2, n9)) {
                Formatter formatter = new Formatter();
                formatter.format("%s%02d/%05d-%05d/%05d-%05d/%05d-%05d.%s", f2.b(n9), n4, n7, n8, n5, n6, d2.f, d2.g, f2.b());
                d2.h = formatter.toString();
            }
        }
        return d2;
    }

    public static d getUTMKFromMapIndex(d d2) {
        int n2 = d2.f;
        int n3 = d2.g;
        int n4 = d2.c;
        int n5 = d2.d;
        int n6 = d2.e;
        d2.a = NMapConverter.a(n4) * n2 + 340901120 + n5 * NMapConverter.a(n4) / 256;
        d2.b = NMapConverter.b(n4) * n3 + 141928960 + n6 * NMapConverter.b(n4) / 256;
        return d2;
    }

    public static void testUtmk2MapIndex() {
        d d2 = new d(10, 349543922, 149525091);
        d2 = NMapConverter.getMapIndexFromUTMK(d2, null);
        d2 = NMapConverter.getUTMKFromMapIndex(d2);
        Log.i((String)"NMapConverter", (String)("testUtmk2MapIndex: utmkX=" + d2.a + ", utmkY=" + d2.b));
    }

    public static int getMapTileHorzCount(int n2) {
        return a[n2 - 1][0];
    }

    public static int getMapTileVertCount(int n2) {
        return a[n2 - 1][1];
    }

    public static double findLongitudeForDistance(double d2, double d3, float f2) {
        double d4;
        int n2 = 0;
        double d5 = d2 + (double)0.01f;
        while (!(Math.abs((d4 = NMapConverter.distLoLa(d2, d3, d5, d3)) - (double)f2) < 1.0)) {
            d5 = d2 + (d5 - d2) * (double)f2 / d4;
            if (++n2 < 5) continue;
        }
        return d5;
    }

    public static double findLatitudeForDistance(double d2, double d3, double d4, float f2) {
        double d5;
        int n2 = 0;
        double d6 = d4 + (d3 - d2);
        while (!(Math.abs((d5 = NMapConverter.distLoLa(d2, d4, d2, d6)) - (double)f2) < 1.0)) {
            d6 = d4 + (d6 - d4) * (double)f2 / d5;
            if (++n2 < 5) continue;
        }
        return d6;
    }

    private static int a(int n2) {
        return b[n2 - 1];
    }

    private static int b(int n2) {
        return b[n2 - 1];
    }

    private static int a(int n2, int n3) {
        int n4 = n2 - 340901120;
        int n5 = NMapConverter.a(n3);
        return n4 / n5;
    }

    private static int b(int n2, int n3) {
        int n4 = n2 - 141928960;
        int n5 = NMapConverter.b(n3);
        return n4 / n5;
    }

    private static int c(int n2, int n3) {
        int n4 = n2 - 340901120;
        int n5 = NMapConverter.a(n3);
        return 256 * (n4 % n5) / n5;
    }

    private static int d(int n2, int n3) {
        int n4 = n2 - 141928960;
        int n5 = NMapConverter.b(n3);
        return 256 * (n4 % n5) / n5;
    }

    private static double a(double d2) {
        return Math.abs(d2) < Math.PI ? d2 : d2 - (double)NMapConverter.b(d2) * (Math.PI * 2);
    }

    private static int b(double d2) {
        if (d2 < 0.0) {
            return -1;
        }
        return 1;
    }

    private static double c(double d2) {
        return 1.0 - 0.25 * d2 * (1.0 + d2 / 16.0 * (3.0 + 1.25 * d2));
    }

    private static double d(double d2) {
        return 0.375 * d2 * (1.0 + 0.25 * d2 * (1.0 + 0.46875 * d2));
    }

    private static double e(double d2) {
        return 0.05859375 * d2 * d2 * (1.0 + 0.75 * d2);
    }

    private static double f(double d2) {
        return d2 * d2 * d2 * 0.011393229166666666;
    }

    private static double a(double d2, double d3, double d4, double d5, double d6) {
        return d2 * d6 - d3 * Math.sin(2.0 * d6) + d4 * Math.sin(4.0 * d6) - d5 * Math.sin(6.0 * d6);
    }
}

