/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.maps;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.nhn.android.maps.maplib.NGPoint;
import com.nhn.android.maps.maplib.NGeoPoint;
import com.nhn.android.maps.maplib.NMapConverter;

public class NMapOverlayItem {
    public static final int VISIBLE = 0;
    public static final int INVISIBLE = 4;
    public static final int GONE = 8;
    protected NGeoPoint mPoint;
    protected NGPoint mUtmk;
    protected String mTitle;
    protected String mSnippet;
    private String a;
    private String b;
    protected Drawable mMarker;
    protected int mVisibility;
    protected Drawable mInfoLayer;
    private int c;
    private Point d;
    private Rect e = new Rect();
    private Rect f = new Rect();
    private float g;
    private float h;
    public static final int ITEM_STATE_FOCUSED_MASK = 4;
    public static final int ITEM_STATE_SELECTED_MASK = 2;
    public static final int ITEM_STATE_PRESSED_MASK = 1;
    private static final int[][] i = new int[][]{{-16842908, -16842913, -16842919}, {-16842908, -16842913, 16842919}, {-16842908, 0x10100A1, -16842919}, {-16842908, 0x10100A1, 16842919}, {16842908, -16842913, -16842919}, {16842908, -16842913, 16842919}, {16842908, 0x10100A1, -16842919}, {16842908, 0x10100A1, 16842919}};

    public NMapOverlayItem(NGeoPoint nGeoPoint, String string, String string2, Drawable drawable2) {
        this.a();
        this.mPoint = nGeoPoint;
        this.mTitle = string;
        this.mSnippet = string2;
        this.mMarker = drawable2;
        this.b();
    }

    public NMapOverlayItem(NGPoint nGPoint, String string, String string2, Drawable drawable2) {
        this.a();
        this.mTitle = string;
        this.mSnippet = string2;
        this.mMarker = drawable2;
        this.mUtmk = nGPoint;
        this.b();
    }

    private void a() {
        this.mPoint = null;
        this.mTitle = null;
        this.mSnippet = null;
        this.mMarker = null;
        this.a = null;
        this.b = null;
        this.mUtmk = null;
        this.c = 8;
    }

    private void b() {
        this.mVisibility = this.mPoint == null && this.mUtmk == null ? 8 : 0;
    }

    public int getVisibility() {
        return this.mVisibility;
    }

    public void setVisibility(int n2) {
        this.mVisibility = n2;
    }

    protected Rect setBoundsInScreen(Rect rect, Point point) {
        if (rect != null) {
            this.f.set(rect);
            this.f.offset(point.x, point.y);
            return this.f;
        }
        return null;
    }

    public Rect getBoundsInScreen() {
        return this.f;
    }

    protected void drawBounds(Canvas canvas) {
        Rect rect = this.f;
        Paint paint = new Paint();
        paint.setColor(0x7F000000);
        canvas.drawRect(rect, paint);
    }

    public void setMarker(Drawable drawable2) {
        this.mMarker = drawable2;
    }

    public Drawable getMarker(int n2) {
        if (this.mMarker != null) {
            NMapOverlayItem.setState(this.mMarker, n2);
        }
        return this.mMarker;
    }

    protected void clearMarker() {
        this.mMarker = null;
    }

    public Drawable getMarker() {
        return this.mMarker;
    }

    protected void setInfoLayer(Drawable drawable2) {
        this.mInfoLayer = drawable2;
    }

    protected Drawable getInfoLayer() {
        return this.mInfoLayer;
    }

    public void setInfoLayerOffset(Point point) {
        this.d = point;
    }

    protected Rect getInfoLayerBoundsInScreen(Rect rect, Point point) {
        if (rect != null) {
            this.e.set(rect);
            this.e.offset(point.x, point.y);
            if (this.d != null) {
                this.e.offset(this.d.x, this.d.y);
                point.x += this.d.x;
                point.y += this.d.y;
            }
            return this.e;
        }
        return null;
    }

    protected int getInfoLayerVisibility() {
        return this.c;
    }

    protected void setInfoLayerVisibility(int n2) {
        this.c = n2;
    }

    public void setPoint(NGeoPoint nGeoPoint) {
        this.mPoint = nGeoPoint;
        this.mUtmk = null;
        this.b();
    }

    public void setPoint(NGPoint nGPoint) {
        this.mPoint = null;
        this.mUtmk = nGPoint;
        this.b();
    }

    public NGeoPoint getPoint() {
        if (this.mPoint == null && this.mUtmk != null) {
            this.mPoint = NMapConverter.utmK2Grs(this.mUtmk);
        }
        return this.mPoint;
    }

    public NGPoint getPointInUtmk() {
        if (this.mUtmk == null && this.mPoint != null) {
            this.mUtmk = NMapConverter.grs2UtmK(this.mPoint);
        }
        return this.mUtmk;
    }

    public void setSnippet(String string) {
        this.mSnippet = string;
    }

    public String getSnippet() {
        return this.mSnippet;
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public boolean isTitleEmpty() {
        return this.mTitle == null || this.mTitle.length() == 0;
    }

    public void setTailText(String string) {
        this.a = string;
    }

    public String getTailText() {
        return this.a;
    }

    public void setHeadText(String string) {
        this.b = string;
    }

    public String getHeadText() {
        return this.b;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((float)this.mPoint.getLongitude());
        stringBuilder.append(",");
        stringBuilder.append((float)this.mPoint.getLatitude());
        return stringBuilder.toString();
    }

    public static Drawable boundCenterTop(Drawable drawable2) {
        int n2 = drawable2.getIntrinsicWidth();
        int n3 = n2 / 2;
        int n4 = drawable2.getIntrinsicHeight();
        drawable2.setBounds(-n3, 0, n2 - n3, n4);
        return drawable2;
    }

    public static Drawable boundCenterBottom(Drawable drawable2) {
        int n2 = drawable2.getIntrinsicWidth();
        int n3 = n2 / 2;
        int n4 = drawable2.getIntrinsicHeight();
        drawable2.setBounds(-n3, 1 - n4, n2 - n3, 1);
        return drawable2;
    }

    public static Drawable boundCenter(Drawable drawable2) {
        int n2 = drawable2.getIntrinsicWidth();
        int n3 = n2 / 2;
        int n4 = drawable2.getIntrinsicHeight();
        int n5 = n4 / 2;
        drawable2.setBounds(-n3, -n5, n2 - n3, n4 - n5);
        return drawable2;
    }

    public static void setState(Drawable drawable2, int n2) {
        drawable2.setState(i[n2]);
    }

    public static boolean isFocusedState(int n2) {
        return (n2 & 4) != 0;
    }

    public static boolean isSelectedState(int n2) {
        return (n2 & 2) != 0;
    }

    public static boolean isPressedState(int n2) {
        return (n2 & 1) != 0;
    }

    public void setAnchorRatio(float f2, float f3) {
        this.g = f2;
        this.h = f3;
    }

    public float getAnchorXRatio() {
        return this.g;
    }

    public float getAnchorYRatio() {
        return this.h;
    }
}

