/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.maps;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import com.nhn.android.maps.NMapOverlay;
import com.nhn.android.maps.NMapOverlayItem;
import com.nhn.android.maps.NMapProjection;
import com.nhn.android.maps.NMapView;
import com.nhn.android.maps.maplib.NGeoPoint;
import com.nhn.android.maps.maplib.NMapConverter;
import com.nhn.android.util.Assertion;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class NMapItemizedOverlay
extends NMapOverlay {
    private ArrayList<NMapOverlayItem> a = null;
    private int b;
    private int c;
    private final Rect d = new Rect();
    private final Drawable e;
    private OnFocusChangeListener f;
    private boolean g = true;
    private int h = -1;
    private int[] i;
    private int j = -1;
    private NMapOverlayItem k = null;
    protected int mLastFocusedIndex = -1;
    private int l;
    private int m;
    private int n;
    private final Rect o = new Rect();
    private final RectF p = new RectF();
    private final Point q = new Point();
    private final Point r = new Point();
    private boolean s;
    private boolean t;
    private final Rect u = new Rect();

    public NMapItemizedOverlay(Drawable drawable2) {
        this.e = drawable2;
    }

    protected abstract NMapOverlayItem createItem(int var1);

    public abstract int size();

    public Rect getItemBounds(NMapOverlayItem nMapOverlayItem) {
        Drawable drawable2 = nMapOverlayItem.getMarker();
        if (drawable2 == null) {
            drawable2 = this.e;
        }
        if (drawable2 == null) {
            drawable2 = nMapOverlayItem.getMarker(0);
        }
        return drawable2.getBounds();
    }

    protected int getIndexToDraw(int n2) {
        return n2;
    }

    @Override
    public void draw(Canvas canvas, NMapView nMapView, boolean bl) {
        int n2;
        int n3;
        int n4;
        if (!Assertion.checkNotNull(this.i)) {
            return;
        }
        int n5 = this.size();
        this.h = -1;
        if (n5 < 1) {
            return;
        }
        if (this.s) {
            n4 = Math.min(10, n5);
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = this.getIndexToDraw(n3);
                this.b(canvas, nMapView, bl, n2);
            }
        }
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            n3 = this.getIndexToDraw(n4);
            n2 = this.i[n3];
            if ((n2 & 4) == 0) {
                this.a(canvas, nMapView, bl, n3);
                continue;
            }
            this.h = n3;
        }
    }

    @Override
    public void drawFocusedItem(Canvas canvas, NMapView nMapView, boolean bl) {
        if (this.g && this.h >= 0) {
            this.a(canvas, nMapView, bl, this.h);
        }
    }

    protected int getLatSpanE6() {
        return this.b;
    }

    protected int getLonSpanE6() {
        return this.c;
    }

    protected Rect getBoundsE6() {
        return this.d;
    }

    protected final void populate() {
        int n2 = this.size();
        int n3 = NMapConverter.NMAP_LOCATION_MAX.getLatitudeE6();
        int n4 = NMapConverter.NMAP_LOCATION_MIN.getLatitudeE6();
        int n5 = NMapConverter.NMAP_LOCATION_MAX.getLongitudeE6();
        int n6 = NMapConverter.NMAP_LOCATION_MIN.getLongitudeE6();
        ArrayList<NMapOverlayItem> arrayList = new ArrayList<NMapOverlayItem>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            NMapOverlayItem nMapOverlayItem = this.createItem(i2);
            arrayList.add(nMapOverlayItem);
            if (nMapOverlayItem.getVisibility() == 8) continue;
            NGeoPoint nGeoPoint = nMapOverlayItem.getPoint();
            n3 = Math.min(n3, nGeoPoint.getLatitudeE6());
            n4 = Math.max(n4, nGeoPoint.getLatitudeE6());
            n5 = Math.min(n5, nGeoPoint.getLongitudeE6());
            n6 = Math.max(n6, nGeoPoint.getLongitudeE6());
        }
        this.b = n4 - n3;
        this.c = n6 - n5;
        this.d.set(n5, n4, n6, n3);
        this.a = arrayList;
        this.i = new int[n2];
        this.m = -1;
        this.l = -1;
        this.n = 0;
    }

    protected void updateMarkerForItem(NMapOverlayItem nMapOverlayItem) {
        if (nMapOverlayItem != null) {
            nMapOverlayItem.clearMarker();
        }
    }

    protected void setLastFocusedIndex(int n2) {
        this.a(n2, null);
    }

    protected void setFocus(NMapOverlayItem nMapOverlayItem) {
        if (nMapOverlayItem == null) {
            this.a(this.mLastFocusedIndex, null);
        } else {
            int n2 = 0;
            for (NMapOverlayItem nMapOverlayItem2 : this.a) {
                if (nMapOverlayItem2 == nMapOverlayItem) {
                    this.a(n2, nMapOverlayItem2);
                    return;
                }
                ++n2;
            }
        }
    }

    public void showFocusedItemOnly() {
        NMapOverlayItem nMapOverlayItem = this.getFocus();
        if (nMapOverlayItem == null) {
            return;
        }
        for (NMapOverlayItem nMapOverlayItem2 : this.a) {
            if (nMapOverlayItem == nMapOverlayItem2) continue;
            nMapOverlayItem2.setVisibility(8);
        }
    }

    public void showAllItems() {
        for (NMapOverlayItem nMapOverlayItem : this.a) {
            nMapOverlayItem.setVisibility(0);
        }
    }

    public boolean setHiddenExceptEndItems(boolean bl, int n2) {
        if (this.t == bl) {
            return false;
        }
        this.t = bl;
        int n3 = this.size();
        int n4 = 0;
        for (NMapOverlayItem nMapOverlayItem : this.a) {
            if (n4 != 0 && n4 != n3 - 1 && n4 != n2) {
                if (bl) {
                    nMapOverlayItem.setVisibility(8);
                } else {
                    nMapOverlayItem.setVisibility(0);
                }
            }
            ++n4;
        }
        return true;
    }

    public boolean showInfoLayers(boolean bl) {
        if (null == this.a) {
            Assertion.checkNotNull(this.a);
            return false;
        }
        int n2 = Math.min(10, this.size());
        if (n2 < 1) {
            return false;
        }
        if (this.s == bl) {
            return false;
        }
        this.s = bl;
        int n3 = 0;
        for (NMapOverlayItem nMapOverlayItem : this.a) {
            if (bl) {
                if (nMapOverlayItem.getVisibility() == 0 && !nMapOverlayItem.isTitleEmpty()) {
                    nMapOverlayItem.setInfoLayerVisibility(0);
                }
            } else {
                nMapOverlayItem.setInfoLayerVisibility(8);
            }
            if (++n3 < n2) continue;
            break;
        }
        return true;
    }

    public boolean isInfoLayersVisible() {
        return this.s;
    }

    public NMapOverlayItem getFocus() {
        return this.k;
    }

    protected final int getLastFocusedIndex() {
        return this.mLastFocusedIndex;
    }

    protected final NMapOverlayItem getItem(int n2) {
        return this.a.get(n2);
    }

    protected final NMapOverlayItem getPressedItem() {
        if (this.l > -1) {
            return this.a.get(this.l);
        }
        return null;
    }

    protected final NMapOverlayItem getSelectedItem() {
        if (this.m > -1) {
            return this.a.get(this.m);
        }
        return null;
    }

    protected NMapOverlayItem nextFocus(boolean bl) {
        int n2 = this.mLastFocusedIndex + (bl ? 1 : -1);
        if (n2 >= 0 && n2 < this.a.size()) {
            return this.getItem(n2);
        }
        return null;
    }

    @Override
    public boolean onTap(int n2, int n3, NMapView nMapView) {
        int n4 = this.b(n2, n3, nMapView);
        if (!this.c(n4)) {
            return false;
        }
        int n5 = n4;
        this.a(n5);
        if (n4 != -1) {
            return this.onTap(n4);
        }
        return false;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent, NMapView nMapView) {
        return this.a(true, 1, motionEvent, nMapView, nMapView.getWidth() / 2, nMapView.getHeight() / 2);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent, NMapView nMapView) {
        return this.a(false, 2, motionEvent, nMapView, (int)motionEvent.getX(), (int)motionEvent.getY());
    }

    protected boolean hitTest(NMapOverlayItem nMapOverlayItem, Drawable drawable2, int n2, int n3) {
        Rect rect = this.a(drawable2.getBounds());
        return rect.contains(n2, n3);
    }

    protected boolean onTap(int n2) {
        return false;
    }

    public void setOnFocusChangeListener(OnFocusChangeListener onFocusChangeListener) {
        this.f = onFocusChangeListener;
    }

    protected void setDrawFocusedItem(boolean bl) {
        this.g = bl;
    }

    private ArrayList<Integer> a(int n2, int n3, NMapView nMapView) {
        ArrayList<NMapOverlayItem> arrayList = this.a;
        int n4 = arrayList.size();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(n4);
        Point point = this.r;
        if (!Assertion.checkNotNull(this.i)) {
            return arrayList2;
        }
        NMapProjection nMapProjection = nMapView.getMapProjection();
        if (this.p.isEmpty()) {
            this.onSizeChanged(nMapView.getWidth(), nMapView.getHeight());
        }
        for (int i2 = n4 - 1; i2 >= 0; --i2) {
            Drawable drawable2;
            NMapOverlayItem nMapOverlayItem;
            int n5 = i2;
            int n6 = this.i[n5];
            if (!this.g && (n6 & 4) != 0 || (nMapOverlayItem = arrayList.get(n5)).getVisibility() != 0) continue;
            nMapProjection.toPixels(nMapOverlayItem.getPointInUtmk(), this.q);
            if (!this.p.contains((float)this.q.x, (float)this.q.y)) continue;
            point.x = n2 - this.q.x;
            point.y = n3 - this.q.y;
            if (nMapView.isAutoRotateEnabled()) {
                nMapView.mapPoint(point);
            }
            if (!this.hitTest(nMapOverlayItem, drawable2 = this.a(nMapOverlayItem, n5), point.x, point.y)) continue;
            arrayList2.add(n5);
        }
        return arrayList2;
    }

    private int b(int n2, int n3, NMapView nMapView) {
        ArrayList<Integer> arrayList = this.a(n2, n3, nMapView);
        int n4 = -1;
        int n5 = Integer.MAX_VALUE;
        Point point = this.r;
        Iterator<Integer> iterator = arrayList.iterator();
        NMapProjection nMapProjection = nMapView.getMapProjection();
        while (iterator.hasNext()) {
            int n6;
            Rect rect;
            int n7;
            int n8;
            Drawable drawable2;
            int n9 = iterator.next();
            NMapOverlayItem nMapOverlayItem = this.a.get(n9);
            nMapProjection.toPixels(nMapOverlayItem.getPointInUtmk(), this.q);
            point.x = n2 - this.q.x;
            point.y = n3 - this.q.y;
            if (nMapView.isAutoRotateEnabled()) {
                nMapView.mapPoint(point);
            }
            if ((drawable2 = this.a(nMapOverlayItem, n9)) == null || (n8 = (n7 = (rect = this.a(drawable2.getBounds())).centerX() - point.x) * n7 + (n6 = rect.centerY() - point.y) * n6) >= n5) continue;
            n5 = n8;
            n4 = n9;
        }
        this.j = n4;
        return this.j;
    }

    private boolean a(boolean bl, int n2, MotionEvent motionEvent, NMapView nMapView, int n3, int n4) {
        boolean bl2;
        int n5 = motionEvent.getAction();
        boolean bl3 = n5 == 0;
        boolean bl4 = bl3 || n5 == 2;
        int n6 = this.b(n3, n4, nMapView);
        boolean bl5 = n6 != -1;
        int n7 = bl ? n6 : -1;
        this.a(n7);
        if (bl3) {
            this.n = bl5 ? (this.n |= n2) : (this.n &= ~n2);
        }
        boolean bl6 = bl2 = (this.n & n2) != 0;
        if (bl2) {
            if (bl4) {
                this.b(n6);
                if (nMapView.getPanWithTouchMoveEvent() && !bl5 && n5 == 2) {
                    this.b(-1);
                    this.n &= ~n2;
                    return false;
                }
            } else if (n5 == 1) {
                this.b(-1);
                if (bl5) {
                    this.onTap(n6);
                }
                this.n &= ~n2;
            }
        }
        return bl2;
    }

    private void a(int n2) {
        this.m = this.a(this.m, n2, 2);
    }

    private void b(int n2) {
        this.l = this.a(this.l, n2, 1);
    }

    private int a(int n2, int n3, int n4) {
        if (n2 != n3) {
            if (!Assertion.checkNotNull(this.i)) {
                return n3;
            }
            if (n2 != -1) {
                int n5 = n2;
                this.i[n5] = this.i[n5] & ~n4;
            }
            if (n3 != -1) {
                int n6 = n3;
                this.i[n6] = this.i[n6] | n4;
            }
        }
        return n3;
    }

    private boolean c(int n2) {
        NMapOverlayItem nMapOverlayItem = n2 == -1 ? null : this.getItem(n2);
        return this.a(n2, nMapOverlayItem);
    }

    private boolean a(int n2, NMapOverlayItem nMapOverlayItem) {
        boolean bl = this.k != nMapOverlayItem && this.f != null;
        this.mLastFocusedIndex = this.a(this.mLastFocusedIndex, n2, 4);
        this.k = nMapOverlayItem;
        if (bl) {
            this.f.onFocusChanged(this, nMapOverlayItem);
        }
        return true;
    }

    private Rect a(Rect rect) {
        int n2 = rect.width();
        int n3 = rect.height();
        if (n2 >= 10 && n3 >= 10) {
            return rect;
        }
        int n4 = rect.centerX();
        int n5 = rect.centerY();
        int n6 = Math.max(10, n2);
        int n7 = n4 - n6 / 2;
        int n8 = Math.max(10, n3);
        int n9 = n5 - n8 / 2;
        this.o.set(n7, n9, n7 + n6, n9 + n8);
        return this.o;
    }

    @Override
    protected void onSizeChanged(int n2, int n3) {
        this.p.set(0.0f, 0.0f, (float)n2, (float)n3);
    }

    private void a(Canvas canvas, NMapView nMapView, boolean bl, int n2) {
        NMapOverlayItem nMapOverlayItem = this.getItem(n2);
        if (nMapOverlayItem.getVisibility() != 0) {
            return;
        }
        nMapView.getMapProjection().toPixels(nMapOverlayItem.getPointInUtmk(), this.q);
        if (this.p.isEmpty()) {
            this.onSizeChanged(nMapView.getWidth(), nMapView.getHeight());
        }
        if (!this.p.contains((float)this.q.x, (float)this.q.y)) {
            nMapOverlayItem.setBoundsInScreen(this.u, this.q);
            return;
        }
        Drawable drawable2 = this.a(nMapOverlayItem, n2);
        this.drawItem(canvas, nMapView, bl, drawable2, nMapOverlayItem);
    }

    protected void drawItem(Canvas canvas, NMapView nMapView, boolean bl, Drawable drawable2, NMapOverlayItem nMapOverlayItem) {
        Matrix matrix;
        if (nMapView.isAutoRotateEnabled()) {
            canvas.save(1);
            matrix = canvas.getMatrix();
            matrix.preRotate(-nMapView.getRoateAngle(), (float)this.q.x, (float)this.q.y);
            canvas.setMatrix(matrix);
        }
        if (this.p.isEmpty()) {
            this.onSizeChanged(nMapView.getWidth(), nMapView.getHeight());
        }
        if (!Assertion.checkNotNull(matrix = nMapOverlayItem.setBoundsInScreen(drawable2.getBounds(), this.q))) {
            return;
        }
        if (this.p.intersects((float)matrix.left, (float)matrix.top, (float)matrix.right, (float)matrix.bottom)) {
            if (this.g && this.k == nMapOverlayItem) {
                this.setFocusedItemAnimationMatrix(canvas, nMapView, nMapView.getDrawingTime(), this.q.x, this.q.y);
            }
            NMapOverlay.drawAt(canvas, drawable2, this.q.x, this.q.y, bl);
        }
        if (nMapView.isAutoRotateEnabled()) {
            canvas.restore();
        }
    }

    private void b(Canvas canvas, NMapView nMapView, boolean bl, int n2) {
        NMapOverlayItem nMapOverlayItem = this.getItem(n2);
        if (nMapOverlayItem.getVisibility() != 0) {
            return;
        }
        if (nMapOverlayItem.getInfoLayerVisibility() != 0) {
            return;
        }
        nMapView.getMapProjection().toPixels(nMapOverlayItem.getPointInUtmk(), this.q);
        if (this.p.isEmpty()) {
            this.onSizeChanged(nMapView.getWidth(), nMapView.getHeight());
        }
        if (!this.p.contains((float)this.q.x, (float)this.q.y)) {
            return;
        }
        Drawable drawable2 = nMapOverlayItem.getInfoLayer();
        if (drawable2 != null) {
            this.a(canvas, nMapView, bl, drawable2, nMapOverlayItem);
        }
    }

    private void a(Canvas canvas, NMapView nMapView, boolean bl, Drawable drawable2, NMapOverlayItem nMapOverlayItem) {
        Matrix matrix;
        if (nMapView.isAutoRotateEnabled()) {
            canvas.save(1);
            matrix = canvas.getMatrix();
            matrix.preRotate(-nMapView.getRoateAngle(), (float)this.q.x, (float)this.q.y);
            canvas.setMatrix(matrix);
        }
        if (this.p.isEmpty()) {
            this.onSizeChanged(nMapView.getWidth(), nMapView.getHeight());
        }
        if (!Assertion.checkNotNull(matrix = nMapOverlayItem.getInfoLayerBoundsInScreen(drawable2.getBounds(), this.q))) {
            return;
        }
        if (this.p.intersects((float)matrix.left, (float)matrix.top, (float)matrix.right, (float)matrix.bottom)) {
            NMapOverlay.drawAt(canvas, drawable2, this.q.x, this.q.y, bl);
        }
        if (nMapView.isAutoRotateEnabled()) {
            canvas.restore();
        }
    }

    private Drawable a(NMapOverlayItem nMapOverlayItem, int n2) {
        if (!Assertion.checkNotNull(this.i)) {
            return null;
        }
        int n3 = this.i[n2];
        Drawable drawable2 = nMapOverlayItem.getMarker(n3);
        if (drawable2 == null) {
            drawable2 = this.e;
            if (drawable2 == null) {
                throw new IllegalStateException("You should provide a Drawable for NMapOverlayItem.");
            }
            NMapOverlayItem.setState(drawable2, n3);
        }
        return drawable2;
    }

    protected void setFocusedItemAnimationMatrix(Canvas canvas, NMapView nMapView, long l2, int n2, int n3) {
    }

    public static interface OnFocusChangeListener {
        public void onFocusChanged(NMapItemizedOverlay var1, NMapOverlayItem var2);
    }
}

