/*
 * Decompiled with CFR 0.152.
 */
package com.natradac.android.tokeninterceptor;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.natradac.android.tokeninterceptor.CannotMapResponseToObject;
import com.natradac.android.tokeninterceptor.NotFoundTokenException;
import com.natradac.android.tokeninterceptor.RefreshTokenException;
import com.natradac.android.tokeninterceptor.RefreshTokenExpired;
import com.natradac.android.tokeninterceptor.RefreshTokenManager;
import com.natradac.android.tokeninterceptor.db.PreferenceHelper;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/natradac/android/tokeninterceptor/TokenManager;", "", "()V", "Companion", "TokenInterceptor_release"})
public final class TokenManager {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJB\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0016\u0010\f\u001a\u0012\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0004\u0012\u00020\u00040\u000bJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ@\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/natradac/android/tokeninterceptor/TokenManager$Companion;", "", "()V", "clear", "", "context", "Landroid/content/Context;", "prefName", "", "getToken", "callBackOnSuccess", "Lkotlin/Function1;", "callBackOnFailed", "Ljava/lang/Exception;", "Lkotlin/Exception;", "isUnAvailable", "", "updateToken", "data", "", "Ljava/lang/Object;", "TokenInterceptor_release"})
    public static final class Companion {
        public final boolean isUnAvailable(@NotNull Context context, @NotNull String prefName) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)prefName, (String)"prefName");
            return PreferenceHelper.INSTANCE.isTokenUnAvailable(context, prefName);
        }

        /*
         * WARNING - void declaration
         */
        public final void getToken(@NotNull Context context, @NotNull String prefName, @NotNull Function1<? super String, Unit> callBackOnSuccess, @NotNull Function1<? super Exception, Unit> callBackOnFailed) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)prefName, (String)"prefName");
            Intrinsics.checkParameterIsNotNull(callBackOnSuccess, (String)"callBackOnSuccess");
            Intrinsics.checkParameterIsNotNull(callBackOnFailed, (String)"callBackOnFailed");
            String token = PreferenceHelper.INSTANCE.defaultPrefs(context, prefName).getString("TOKEN", null);
            if (token == null) {
                Unit cfr_ignored_0 = (Unit)callBackOnFailed.invoke((Object)new NotFoundTokenException());
            } else if (PreferenceHelper.INSTANCE.isAccessTokenExpired(context, prefName)) {
                if (PreferenceHelper.INSTANCE.isRefreshTokenExpired(context, prefName)) {
                    Unit cfr_ignored_1 = (Unit)callBackOnFailed.invoke((Object)new RefreshTokenExpired());
                } else {
                    OkHttpClient httpClient = new OkHttpClient();
                    Request request = RefreshTokenManager.INSTANCE.getRequest(context, prefName);
                    Log.d((String)TokenManager.class.getName(), (String)(request.method() + " --> " + request.url()));
                    Log.d((String)TokenManager.class.getName(), (String)("Header " + request.headers()));
                    httpClient.newCall(request).enqueue(new Callback(callBackOnFailed, request, context, prefName, callBackOnSuccess){
                        final /* synthetic */ Function1 $callBackOnFailed;
                        final /* synthetic */ Request $request;
                        final /* synthetic */ Context $context;
                        final /* synthetic */ String $prefName;
                        final /* synthetic */ Function1 $callBackOnSuccess;

                        public void onFailure(@NotNull Call call, @NotNull IOException e) {
                            Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                            String string = e.getMessage();
                            if (string == null) {
                                string = "Refresh token error";
                            }
                            this.$callBackOnFailed.invoke((Object)new RefreshTokenException(string));
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public void onResponse(@NotNull Call call, @NotNull Response response) {
                            Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                            Log.d((String)TokenManager.class.getName(), (String)(" <-- " + response.code() + " " + this.$request.url()));
                            if (response.code() == 200) {
                                if (response.body() != null) {
                                    Gson gson = new Gson();
                                    ResponseBody responseBody = response.body();
                                    if (responseBody == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    Object object = gson.fromJson(responseBody.string(), new TypeToken<Map<String, ? extends Object>>(){}.getType());
                                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Gson().fromJson(\n       \u2026                        )");
                                    Map refreshTokenResponse2 = (Map)object;
                                    Log.d((String)TokenManager.class.getName(), (String)("body: " + refreshTokenResponse2));
                                    if (refreshTokenResponse2.get("data") != null) {
                                        V v = refreshTokenResponse2.get("data");
                                        if (v == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, java.lang.Object>");
                                        }
                                        com.natradac.android.tokeninterceptor.TokenManager$Companion.access$updateToken(TokenManager.Companion, this.$context, this.$prefName, (Map)v, this.$callBackOnSuccess);
                                        return;
                                    } else if (refreshTokenResponse2.get("datas") != null) {
                                        V v = refreshTokenResponse2.get("datas");
                                        if (v == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, java.lang.Object>");
                                        }
                                        com.natradac.android.tokeninterceptor.TokenManager$Companion.access$updateToken(TokenManager.Companion, this.$context, this.$prefName, (Map)v, this.$callBackOnSuccess);
                                        return;
                                    } else {
                                        if (refreshTokenResponse2 == null) throw (Throwable)new CannotMapResponseToObject();
                                        com.natradac.android.tokeninterceptor.TokenManager$Companion.access$updateToken(TokenManager.Companion, this.$context, this.$prefName, refreshTokenResponse2, this.$callBackOnSuccess);
                                    }
                                    return;
                                } else {
                                    this.$callBackOnFailed.invoke((Object)new RefreshTokenException("Response body: " + response.body()));
                                }
                                return;
                            } else {
                                this.$callBackOnFailed.invoke((Object)new RefreshTokenException("Response code: " + response.code() + ", message: " + response.message()));
                            }
                        }
                        {
                            this.$callBackOnFailed = $captured_local_variable$0;
                            this.$request = $captured_local_variable$1;
                            this.$context = $captured_local_variable$2;
                            this.$prefName = $captured_local_variable$3;
                            this.$callBackOnSuccess = $captured_local_variable$4;
                        }
                    });
                }
            } else {
                String string;
                String string2;
                String string3;
                void key$iv;
                void $this$get$iv;
                SharedPreferences request = PreferenceHelper.INSTANCE.defaultPrefs(context, prefName);
                PreferenceHelper preferenceHelper = PreferenceHelper.INSTANCE;
                String string4 = "TOKEN";
                Function1<? super String, Unit> function1 = callBackOnSuccess;
                Object defaultValue$iv = null;
                boolean $i$f$get = false;
                KClass kClass = Reflection.getOrCreateKotlinClass(String.class);
                if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    string3 = $this$get$iv.getString((String)key$iv, (String)null);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    string3 = (String)((Object)Integer.valueOf($this$get$iv.getInt((String)key$iv, -1)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    string3 = (String)((Object)Boolean.valueOf($this$get$iv.getBoolean((String)key$iv, false)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    string3 = (String)((Object)Float.valueOf($this$get$iv.getFloat((String)key$iv, -1.0f)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    string3 = (String)((Object)Long.valueOf($this$get$iv.getLong((String)key$iv, -1L)));
                } else {
                    throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                }
                if ((string2 = (string = string3)) == null) {
                    string2 = "";
                }
                Unit cfr_ignored_6 = (Unit)function1.invoke((Object)string2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void updateToken(Context context, String prefName, Map<String, ? extends Object> data, Function1<? super String, Unit> callBackOnSuccess) {
            String string;
            String key$iv;
            void $this$get$iv22;
            SharedPreferences pref = PreferenceHelper.INSTANCE.defaultPrefs(context, prefName);
            Map<String, ? extends Object> map = data;
            SharedPreferences sharedPreferences = pref;
            Object object = PreferenceHelper.INSTANCE;
            String string2 = "REFRESH_TOKEN_KEY";
            String defaultValue$iv = "refresh_token";
            boolean $i$f$get = false;
            KClass kClass = Reflection.getOrCreateKotlinClass(String.class);
            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                string = $this$get$iv22.getString(key$iv, defaultValue$iv);
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                String string3 = defaultValue$iv;
                if (!(string3 instanceof Integer)) {
                    string3 = null;
                }
                Integer n = (Integer)((Object)string3);
                string = (String)((Object)Integer.valueOf($this$get$iv22.getInt(key$iv, n != null ? n : -1)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                String string4 = defaultValue$iv;
                if (!(string4 instanceof Boolean)) {
                    string4 = null;
                }
                Boolean bl = (Boolean)((Object)string4);
                string = (String)((Object)Boolean.valueOf($this$get$iv22.getBoolean(key$iv, bl != null ? bl : false)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                String string5 = defaultValue$iv;
                if (!(string5 instanceof Float)) {
                    string5 = null;
                }
                Float f = (Float)((Object)string5);
                string = (String)((Object)Float.valueOf($this$get$iv22.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                String string6 = defaultValue$iv;
                if (!(string6 instanceof Long)) {
                    string6 = null;
                }
                Long l = (Long)((Object)string6);
                string = (String)((Object)Long.valueOf($this$get$iv22.getLong(key$iv, l != null ? l : -1L)));
            } else {
                throw (Throwable)new UnsupportedOperationException("Not yet implemented");
            }
            object = string;
            boolean $this$get$iv22 = false;
            if (map.get(object) != null) {
                String string7;
                map = data;
                SharedPreferences $this$get$iv22 = pref;
                object = PreferenceHelper.INSTANCE;
                key$iv = "TOKEN_KEY";
                defaultValue$iv = "access_token";
                $i$f$get = false;
                kClass = Reflection.getOrCreateKotlinClass(String.class);
                if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    string7 = $this$get$iv22.getString(key$iv, defaultValue$iv);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    String string8 = defaultValue$iv;
                    if (!(string8 instanceof Integer)) {
                        string8 = null;
                    }
                    Integer n = (Integer)((Object)string8);
                    string7 = (String)((Object)Integer.valueOf($this$get$iv22.getInt(key$iv, n != null ? n : -1)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    String string9 = defaultValue$iv;
                    if (!(string9 instanceof Boolean)) {
                        string9 = null;
                    }
                    Boolean bl = (Boolean)((Object)string9);
                    string7 = (String)((Object)Boolean.valueOf($this$get$iv22.getBoolean(key$iv, bl != null ? bl : false)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    String string10 = defaultValue$iv;
                    if (!(string10 instanceof Float)) {
                        string10 = null;
                    }
                    Float f = (Float)((Object)string10);
                    string7 = (String)((Object)Float.valueOf($this$get$iv22.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    String string11 = defaultValue$iv;
                    if (!(string11 instanceof Long)) {
                        string11 = null;
                    }
                    Long l = (Long)((Object)string11);
                    string7 = (String)((Object)Long.valueOf($this$get$iv22.getLong(key$iv, l != null ? l : -1L)));
                } else {
                    throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                }
                object = string7;
                boolean $this$get$iv232 = false;
                if (map.get(object) != null) {
                    String string12;
                    map = data;
                    SharedPreferences $this$get$iv232 = pref;
                    object = PreferenceHelper.INSTANCE;
                    key$iv = "ACCESS_VALID_KEY";
                    defaultValue$iv = "access_valid";
                    $i$f$get = false;
                    kClass = Reflection.getOrCreateKotlinClass(String.class);
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                        string12 = $this$get$iv232.getString(key$iv, defaultValue$iv);
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                        String string13 = defaultValue$iv;
                        if (!(string13 instanceof Integer)) {
                            string13 = null;
                        }
                        Integer n = (Integer)((Object)string13);
                        string12 = (String)((Object)Integer.valueOf($this$get$iv232.getInt(key$iv, n != null ? n : -1)));
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                        String string14 = defaultValue$iv;
                        if (!(string14 instanceof Boolean)) {
                            string14 = null;
                        }
                        Boolean bl = (Boolean)((Object)string14);
                        string12 = (String)((Object)Boolean.valueOf($this$get$iv232.getBoolean(key$iv, bl != null ? bl : false)));
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                        String string15 = defaultValue$iv;
                        if (!(string15 instanceof Float)) {
                            string15 = null;
                        }
                        Float f = (Float)((Object)string15);
                        string12 = (String)((Object)Float.valueOf($this$get$iv232.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                        String string16 = defaultValue$iv;
                        if (!(string16 instanceof Long)) {
                            string16 = null;
                        }
                        Long l = (Long)((Object)string16);
                        string12 = (String)((Object)Long.valueOf($this$get$iv232.getLong(key$iv, l != null ? l : -1L)));
                    } else {
                        throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                    }
                    object = string12;
                    boolean $this$get$iv32 = false;
                    if (map.get(object) != null) {
                        String string17;
                        map = data;
                        SharedPreferences $this$get$iv32 = pref;
                        object = PreferenceHelper.INSTANCE;
                        key$iv = "REFRESH_VALID_KEY";
                        defaultValue$iv = "refresh_valid";
                        $i$f$get = false;
                        kClass = Reflection.getOrCreateKotlinClass(String.class);
                        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                            string17 = $this$get$iv32.getString(key$iv, defaultValue$iv);
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                            String string18 = defaultValue$iv;
                            if (!(string18 instanceof Integer)) {
                                string18 = null;
                            }
                            Integer n = (Integer)((Object)string18);
                            string17 = (String)((Object)Integer.valueOf($this$get$iv32.getInt(key$iv, n != null ? n : -1)));
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                            String string19 = defaultValue$iv;
                            if (!(string19 instanceof Boolean)) {
                                string19 = null;
                            }
                            Boolean bl = (Boolean)((Object)string19);
                            string17 = (String)((Object)Boolean.valueOf($this$get$iv32.getBoolean(key$iv, bl != null ? bl : false)));
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                            String string20 = defaultValue$iv;
                            if (!(string20 instanceof Float)) {
                                string20 = null;
                            }
                            Float f = (Float)((Object)string20);
                            string17 = (String)((Object)Float.valueOf($this$get$iv32.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
                        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                            String string21 = defaultValue$iv;
                            if (!(string21 instanceof Long)) {
                                string21 = null;
                            }
                            Long l = (Long)((Object)string21);
                            string17 = (String)((Object)Long.valueOf($this$get$iv32.getLong(key$iv, l != null ? l : -1L)));
                        } else {
                            throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                        }
                        object = string17;
                        boolean $this$get$iv332 = false;
                        if (map.get(object) != null) {
                            String string22;
                            long l;
                            String string23;
                            String string24;
                            String string25;
                            Object object2;
                            String string26;
                            map = data;
                            SharedPreferences $this$get$iv332 = pref;
                            object = PreferenceHelper.INSTANCE;
                            key$iv = "TOKEN_KEY";
                            defaultValue$iv = "access_token";
                            String string27 = "TOKEN";
                            Object object3 = pref;
                            Function1<? super String, Unit> function1 = PreferenceHelper.INSTANCE;
                            $i$f$get = false;
                            kClass = Reflection.getOrCreateKotlinClass(String.class);
                            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                                string26 = $this$get$iv332.getString(key$iv, defaultValue$iv);
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                                String string28 = defaultValue$iv;
                                if (!(string28 instanceof Integer)) {
                                    string28 = null;
                                }
                                Integer n = (Integer)((Object)string28);
                                string26 = (String)((Object)Integer.valueOf($this$get$iv332.getInt(key$iv, n != null ? n : -1)));
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                                String string29 = defaultValue$iv;
                                if (!(string29 instanceof Boolean)) {
                                    string29 = null;
                                }
                                Boolean bl = (Boolean)((Object)string29);
                                string26 = (String)((Object)Boolean.valueOf($this$get$iv332.getBoolean(key$iv, bl != null ? bl : false)));
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                                String string30 = defaultValue$iv;
                                if (!(string30 instanceof Float)) {
                                    string30 = null;
                                }
                                Float f = (Float)((Object)string30);
                                string26 = (String)((Object)Float.valueOf($this$get$iv332.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                                String string31 = defaultValue$iv;
                                if (!(string31 instanceof Long)) {
                                    string31 = null;
                                }
                                Long l2 = (Long)((Object)string31);
                                string26 = (String)((Object)Long.valueOf($this$get$iv332.getLong(key$iv, l2 != null ? l2 : -1L)));
                            } else {
                                throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                            }
                            object = object2 = string26;
                            boolean $this$get$iv42 = false;
                            object2 = map.get(object);
                            function1.set(object3, string27, (Object)String.valueOf(object2));
                            map = data;
                            SharedPreferences $this$get$iv42 = pref;
                            object = PreferenceHelper.INSTANCE;
                            key$iv = "REFRESH_TOKEN_KEY";
                            defaultValue$iv = "refresh_token";
                            string27 = "REFRESH_TOKEN";
                            object3 = pref;
                            function1 = PreferenceHelper.INSTANCE;
                            $i$f$get = false;
                            kClass = Reflection.getOrCreateKotlinClass(String.class);
                            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                                string25 = $this$get$iv42.getString(key$iv, defaultValue$iv);
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                                String string32 = defaultValue$iv;
                                if (!(string32 instanceof Integer)) {
                                    string32 = null;
                                }
                                Integer n = (Integer)((Object)string32);
                                string25 = (String)((Object)Integer.valueOf($this$get$iv42.getInt(key$iv, n != null ? n : -1)));
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                                String string33 = defaultValue$iv;
                                if (!(string33 instanceof Boolean)) {
                                    string33 = null;
                                }
                                Boolean bl = (Boolean)((Object)string33);
                                string25 = (String)((Object)Boolean.valueOf($this$get$iv42.getBoolean(key$iv, bl != null ? bl : false)));
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                                String string34 = defaultValue$iv;
                                if (!(string34 instanceof Float)) {
                                    string34 = null;
                                }
                                Float f = (Float)((Object)string34);
                                string25 = (String)((Object)Float.valueOf($this$get$iv42.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                                String string35 = defaultValue$iv;
                                if (!(string35 instanceof Long)) {
                                    string35 = null;
                                }
                                Long l3 = (Long)((Object)string35);
                                string25 = (String)((Object)Long.valueOf($this$get$iv42.getLong(key$iv, l3 != null ? l3 : -1L)));
                            } else {
                                throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                            }
                            object = object2 = string25;
                            $this$get$iv5 = false;
                            object2 = map.get(object);
                            function1.set(object3, string27, (Object)String.valueOf(object2));
                            map = data;
                            SharedPreferences $this$get$iv5 = pref;
                            object = PreferenceHelper.INSTANCE;
                            key$iv = "ACCESS_VALID_KEY";
                            defaultValue$iv = "access_valid";
                            string27 = "ACCESS_VALID";
                            object3 = pref;
                            function1 = PreferenceHelper.INSTANCE;
                            $i$f$get = false;
                            kClass = Reflection.getOrCreateKotlinClass(String.class);
                            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                                string24 = $this$get$iv5.getString(key$iv, defaultValue$iv);
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                                String string36 = defaultValue$iv;
                                if (!(string36 instanceof Integer)) {
                                    string36 = null;
                                }
                                Integer n = (Integer)((Object)string36);
                                string24 = (String)((Object)Integer.valueOf($this$get$iv5.getInt(key$iv, n != null ? n : -1)));
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                                String string37 = defaultValue$iv;
                                if (!(string37 instanceof Boolean)) {
                                    string37 = null;
                                }
                                Boolean bl = (Boolean)((Object)string37);
                                string24 = (String)((Object)Boolean.valueOf($this$get$iv5.getBoolean(key$iv, bl != null ? bl : false)));
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                                String string38 = defaultValue$iv;
                                if (!(string38 instanceof Float)) {
                                    string38 = null;
                                }
                                Float f = (Float)((Object)string38);
                                string24 = (String)((Object)Float.valueOf($this$get$iv5.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                                String string39 = defaultValue$iv;
                                if (!(string39 instanceof Long)) {
                                    string39 = null;
                                }
                                Long l4 = (Long)((Object)string39);
                                string24 = (String)((Object)Long.valueOf($this$get$iv5.getLong(key$iv, l4 != null ? l4 : -1L)));
                            } else {
                                throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                            }
                            object = object2 = string24;
                            $this$get$iv6 = false;
                            Object object4 = object2 = map.get(object);
                            if (object4 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
                            }
                            function1.set(object3, string27, (Object)((long)((Double)object4).doubleValue()));
                            map = data;
                            SharedPreferences $this$get$iv6 = pref;
                            object = PreferenceHelper.INSTANCE;
                            key$iv = "REFRESH_VALID_KEY";
                            defaultValue$iv = "refresh_valid";
                            string27 = "REFRESH_VALID";
                            object3 = pref;
                            function1 = PreferenceHelper.INSTANCE;
                            $i$f$get = false;
                            kClass = Reflection.getOrCreateKotlinClass(String.class);
                            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                                string23 = $this$get$iv6.getString(key$iv, defaultValue$iv);
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                                String string40 = defaultValue$iv;
                                if (!(string40 instanceof Integer)) {
                                    string40 = null;
                                }
                                Integer n = (Integer)((Object)string40);
                                string23 = (String)((Object)Integer.valueOf($this$get$iv6.getInt(key$iv, n != null ? n : -1)));
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                                String string41 = defaultValue$iv;
                                if (!(string41 instanceof Boolean)) {
                                    string41 = null;
                                }
                                Boolean bl = (Boolean)((Object)string41);
                                string23 = (String)((Object)Boolean.valueOf($this$get$iv6.getBoolean(key$iv, bl != null ? bl : false)));
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                                String string42 = defaultValue$iv;
                                if (!(string42 instanceof Float)) {
                                    string42 = null;
                                }
                                Float f = (Float)((Object)string42);
                                string23 = (String)((Object)Float.valueOf($this$get$iv6.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                                String string43 = defaultValue$iv;
                                if (!(string43 instanceof Long)) {
                                    string43 = null;
                                }
                                Long l5 = (Long)((Object)string43);
                                string23 = (String)((Object)Long.valueOf($this$get$iv6.getLong(key$iv, l5 != null ? l5 : -1L)));
                            } else {
                                throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                            }
                            object = object2 = string23;
                            $this$get$iv7 = false;
                            Object object5 = object2 = map.get(object);
                            if (object5 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
                            }
                            function1.set(object3, string27, (Object)((long)((Double)object5).doubleValue()));
                            if (Build.VERSION.SDK_INT >= 26) {
                                Instant instant = Instant.now();
                                Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
                                l = instant.getEpochSecond();
                            } else {
                                l = System.currentTimeMillis() / 1000L;
                            }
                            PreferenceHelper.INSTANCE.set(pref, "TIME_STAMP", l);
                            map = data;
                            SharedPreferences $this$get$iv7 = pref;
                            object = PreferenceHelper.INSTANCE;
                            key$iv = "TOKEN_KEY";
                            defaultValue$iv = "access_token";
                            function1 = callBackOnSuccess;
                            $i$f$get = false;
                            kClass = Reflection.getOrCreateKotlinClass(String.class);
                            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                                string22 = $this$get$iv7.getString(key$iv, defaultValue$iv);
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                                String string44 = defaultValue$iv;
                                if (!(string44 instanceof Integer)) {
                                    string44 = null;
                                }
                                Integer n = (Integer)((Object)string44);
                                string22 = (String)((Object)Integer.valueOf($this$get$iv7.getInt(key$iv, n != null ? n : -1)));
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                                String string45 = defaultValue$iv;
                                if (!(string45 instanceof Boolean)) {
                                    string45 = null;
                                }
                                Boolean bl = (Boolean)((Object)string45);
                                string22 = (String)((Object)Boolean.valueOf($this$get$iv7.getBoolean(key$iv, bl != null ? bl : false)));
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                                String string46 = defaultValue$iv;
                                if (!(string46 instanceof Float)) {
                                    string46 = null;
                                }
                                Float f = (Float)((Object)string46);
                                string22 = (String)((Object)Float.valueOf($this$get$iv7.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
                            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                                String string47 = defaultValue$iv;
                                if (!(string47 instanceof Long)) {
                                    string47 = null;
                                }
                                Long l6 = (Long)((Object)string47);
                                string22 = (String)((Object)Long.valueOf($this$get$iv7.getLong(key$iv, l6 != null ? l6 : -1L)));
                            } else {
                                throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                            }
                            object3 = string22;
                            object = object3;
                            boolean bl = false;
                            object3 = map.get(object);
                            function1.invoke((Object)String.valueOf(object3));
                        }
                    }
                }
            }
        }

        public final void clear(@NotNull Context context, @NotNull String prefName) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)prefName, (String)"prefName");
            PreferenceHelper.INSTANCE.clear(context, prefName);
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$updateToken(Companion $this, Context context, String prefName, Map data, Function1 callBackOnSuccess) {
            $this.updateToken(context, prefName, data, (Function1<? super String, Unit>)callBackOnSuccess);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

