/*
 * Decompiled with CFR 0.152.
 */
package com.natradac.android.tokeninterceptor.db;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.preference.PreferenceManager;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ!\u0010\u0013\u001a\u00020\n*\u00020\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\n0\u0015H\u0086\bJ4\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\n\b\u0000\u0010\u0018\u0018\u0001*\u00020\u0001*\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00042\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u0001H\u0018H\u0086\n\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001c\u001a\u00020\n*\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/natradac/android/tokeninterceptor/db/PreferenceHelper;", "", "()V", "ACCESS_VALID", "", "REFRESH_TOKEN", "REFRESH_VALID", "TIME_STAMP", "TOKEN", "clear", "", "context", "Landroid/content/Context;", "defaultPrefs", "Landroid/content/SharedPreferences;", "isAccessTokenExpired", "", "isRefreshTokenExpired", "isTokenUnAvailable", "edit", "operation", "Lkotlin/Function1;", "Landroid/content/SharedPreferences$Editor;", "get", "T", "key", "defaultValue", "(Landroid/content/SharedPreferences;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "set", "value", "TokenInterceptor_release"})
public final class PreferenceHelper {
    @NotNull
    public static final String TOKEN = "TOKEN";
    @NotNull
    public static final String REFRESH_TOKEN = "REFRESH_TOKEN";
    @NotNull
    public static final String TIME_STAMP = "TIME_STAMP";
    @NotNull
    public static final String ACCESS_VALID = "ACCESS_VALID";
    @NotNull
    public static final String REFRESH_VALID = "REFRESH_VALID";
    public static final PreferenceHelper INSTANCE;

    @NotNull
    public final SharedPreferences defaultPrefs(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"PreferenceManager.getDef\u2026haredPreferences(context)");
        return sharedPreferences;
    }

    public final void edit(@NotNull SharedPreferences $this$edit, @NotNull Function1<? super SharedPreferences.Editor, Unit> operation) {
        SharedPreferences.Editor editor;
        int $i$f$edit = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$edit, (String)"$this$edit");
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        SharedPreferences.Editor editor2 = editor = $this$edit.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor");
        operation.invoke((Object)editor2);
        editor.apply();
    }

    /*
     * WARNING - void declaration
     */
    public final void set(@NotNull SharedPreferences $this$set, @NotNull String key, @Nullable Object value) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$this$set, (String)"$this$set");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Object object2 = object = value;
        if (object2 != null ? object2 instanceof String : true) {
            void $this$edit$iv;
            SharedPreferences.Editor editor$iv;
            SharedPreferences sharedPreferences = $this$set;
            PreferenceHelper this_$iv = this;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
            SharedPreferences.Editor it = editor;
            boolean bl = false;
            it.putString(key, (String)value);
            editor$iv.apply();
        } else if (object instanceof Integer) {
            SharedPreferences.Editor editor$iv;
            SharedPreferences $this$edit$iv = $this$set;
            PreferenceHelper this_$iv = this;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
            SharedPreferences.Editor it = editor;
            boolean bl = false;
            it.putInt(key, ((Number)value).intValue());
            editor$iv.apply();
        } else if (object instanceof Boolean) {
            SharedPreferences.Editor editor$iv;
            SharedPreferences $this$edit$iv = $this$set;
            PreferenceHelper this_$iv = this;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
            SharedPreferences.Editor it = editor;
            boolean bl = false;
            it.putBoolean(key, ((Boolean)value).booleanValue());
            editor$iv.apply();
        } else if (object instanceof Float) {
            SharedPreferences.Editor editor$iv;
            SharedPreferences $this$edit$iv = $this$set;
            PreferenceHelper this_$iv = this;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
            SharedPreferences.Editor it = editor;
            boolean bl = false;
            it.putFloat(key, ((Number)value).floatValue());
            editor$iv.apply();
        } else if (object instanceof Long) {
            SharedPreferences.Editor editor$iv;
            SharedPreferences $this$edit$iv = $this$set;
            PreferenceHelper this_$iv = this;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
            SharedPreferences.Editor it = editor;
            boolean bl = false;
            it.putLong(key, ((Number)value).longValue());
            editor$iv.apply();
        } else {
            throw (Throwable)new UnsupportedOperationException("Not yet implemented");
        }
    }

    @Nullable
    public final /* synthetic */ <T> T get(@NotNull SharedPreferences $this$get, @NotNull String key, @Nullable T defaultValue) {
        Object object;
        int $i$f$get = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$get, (String)"$this$get");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            T t = defaultValue;
            if (!(t instanceof String)) {
                t = null;
            }
            String string = $this$get.getString(key, (String)t);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
            object = string;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            T t = defaultValue;
            if (!(t instanceof Integer)) {
                t = null;
            }
            Integer n = (Integer)t;
            Integer n2 = $this$get.getInt(key, n != null ? n : -1);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
            object = n2;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            T t = defaultValue;
            if (!(t instanceof Boolean)) {
                t = null;
            }
            Boolean bl = (Boolean)t;
            Boolean bl2 = $this$get.getBoolean(key, bl != null ? bl : false);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
            object = bl2;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            T t = defaultValue;
            if (!(t instanceof Float)) {
                t = null;
            }
            Float f = (Float)t;
            Float f2 = Float.valueOf($this$get.getFloat(key, f != null ? f.floatValue() : -1.0f));
            Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
            object = f2;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            T t = defaultValue;
            if (!(t instanceof Long)) {
                t = null;
            }
            Long l = (Long)t;
            Long l2 = $this$get.getLong(key, l != null ? l : -1L);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
            object = l2;
        } else {
            throw (Throwable)new UnsupportedOperationException("Not yet implemented");
        }
        return (T)object;
    }

    public static /* synthetic */ Object get$default(PreferenceHelper this_, SharedPreferences $this$get, String key, Object defaultValue, int n, Object object) {
        Object object2;
        if ((n & 2) != 0) {
            defaultValue = null;
        }
        boolean $i$f$get = false;
        Intrinsics.checkParameterIsNotNull((Object)$this$get, (String)"$this$get");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        object = Reflection.getOrCreateKotlinClass(Object.class);
        if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            Object object3 = defaultValue;
            if (!(object3 instanceof String)) {
                object3 = null;
            }
            String string = $this$get.getString(key, (String)object3);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
            object2 = string;
        } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Object object4 = defaultValue;
            if (!(object4 instanceof Integer)) {
                object4 = null;
            }
            Integer n2 = (Integer)object4;
            Integer n3 = $this$get.getInt(key, n2 != null ? n2 : -1);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
            object2 = n3;
        } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            Object object5 = defaultValue;
            if (!(object5 instanceof Boolean)) {
                object5 = null;
            }
            Boolean bl = (Boolean)object5;
            Boolean bl2 = $this$get.getBoolean(key, bl != null ? bl : false);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
            object2 = bl2;
        } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            Object object6 = defaultValue;
            if (!(object6 instanceof Float)) {
                object6 = null;
            }
            Float f = (Float)object6;
            Float f2 = Float.valueOf($this$get.getFloat(key, f != null ? f.floatValue() : -1.0f));
            Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
            object2 = f2;
        } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            Object object7 = defaultValue;
            if (!(object7 instanceof Long)) {
                object7 = null;
            }
            Long l = (Long)object7;
            Long l2 = $this$get.getLong(key, l != null ? l : -1L);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
            object2 = l2;
        } else {
            throw (Throwable)new UnsupportedOperationException("Not yet implemented");
        }
        return object2;
    }

    public final boolean isAccessTokenExpired(@NotNull Context context) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences prefs = this.defaultPrefs(context);
        if (Build.VERSION.SDK_INT >= 26) {
            Instant instant = Instant.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
            l = instant.getEpochSecond();
        } else {
            l = System.currentTimeMillis() / 1000L;
        }
        long currentTime = l;
        long timeStamp = prefs.getLong(TIME_STAMP, 0L);
        long expired = prefs.getLong(ACCESS_VALID, 0L);
        return currentTime - timeStamp > expired;
    }

    public final boolean isRefreshTokenExpired(@NotNull Context context) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences prefs = this.defaultPrefs(context);
        if (Build.VERSION.SDK_INT >= 26) {
            Instant instant = Instant.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
            l = instant.getEpochSecond();
        } else {
            l = System.currentTimeMillis() / 1000L;
        }
        long currentTime = l;
        long timeStamp = prefs.getLong(TIME_STAMP, 0L);
        long expired = prefs.getLong(REFRESH_VALID, 0L);
        return currentTime - timeStamp > expired;
    }

    public final boolean isTokenUnAvailable(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences prefs = this.defaultPrefs(context);
        return prefs.getString(TOKEN, null) == null || this.isRefreshTokenExpired(context);
    }

    public final void clear(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences prefs = this.defaultPrefs(context);
        this.set(prefs, TOKEN, null);
        this.set(prefs, REFRESH_TOKEN, null);
        this.set(prefs, TIME_STAMP, null);
        this.set(prefs, ACCESS_VALID, null);
        this.set(prefs, REFRESH_VALID, null);
    }

    private PreferenceHelper() {
    }

    static {
        PreferenceHelper preferenceHelper;
        INSTANCE = preferenceHelper = new PreferenceHelper();
    }
}

