/*
 * Decompiled with CFR 0.152.
 */
package com.natradac.android.tokeninterceptor;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.natradac.android.tokeninterceptor.CannotMapResponseToObject;
import com.natradac.android.tokeninterceptor.NotFoundTokenException;
import com.natradac.android.tokeninterceptor.RefreshTokenException;
import com.natradac.android.tokeninterceptor.RefreshTokenExpired;
import com.natradac.android.tokeninterceptor.RefreshTokenManager;
import com.natradac.android.tokeninterceptor.db.PreferenceHelper;
import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/natradac/android/tokeninterceptor/TokenManager;", "", "()V", "Companion", "TokenInterceptor_release"})
public final class TokenManager {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b2\u0016\u0010\n\u001a\u0012\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u0004\u0012\u00020\u00040\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006J0\u0010\u000f\u001a\u00020\u00042\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u00112\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/natradac/android/tokeninterceptor/TokenManager$Companion;", "", "()V", "getToken", "", "context", "Landroid/content/Context;", "callBackOnSuccess", "Lkotlin/Function1;", "", "callBackOnFailed", "Ljava/lang/Exception;", "Lkotlin/Exception;", "isUnAvailable", "", "updateToken", "data", "", "Ljava/lang/Object;", "TokenInterceptor_release"})
    public static final class Companion {
        public final boolean isUnAvailable(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            return PreferenceHelper.INSTANCE.isTokenUnAvailable(context);
        }

        /*
         * WARNING - void declaration
         */
        public final void getToken(@NotNull Context context, @NotNull Function1<? super String, Unit> callBackOnSuccess, @NotNull Function1<? super Exception, Unit> callBackOnFailed) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull(callBackOnSuccess, (String)"callBackOnSuccess");
            Intrinsics.checkParameterIsNotNull(callBackOnFailed, (String)"callBackOnFailed");
            String token = PreferenceHelper.INSTANCE.defaultPrefs(context).getString("TOKEN", null);
            if (token == null) {
                Unit cfr_ignored_0 = (Unit)callBackOnFailed.invoke((Object)new NotFoundTokenException());
            } else if (PreferenceHelper.INSTANCE.isAccessTokenExpired(context)) {
                if (PreferenceHelper.INSTANCE.isRefreshTokenExpired(context)) {
                    Unit cfr_ignored_1 = (Unit)callBackOnFailed.invoke((Object)new RefreshTokenExpired());
                } else {
                    OkHttpClient httpClient = new OkHttpClient();
                    Request request = RefreshTokenManager.INSTANCE.getRequest();
                    Log.d((String)TokenManager.class.getName(), (String)(request.method() + " --> " + request.url()));
                    Log.d((String)TokenManager.class.getName(), (String)("Header " + request.headers()));
                    Log.d((String)TokenManager.class.getName(), (String)("Body " + request.body()));
                    httpClient.newCall(request).enqueue(new Callback(callBackOnFailed, request, callBackOnSuccess){
                        final /* synthetic */ Function1 $callBackOnFailed;
                        final /* synthetic */ Request $request;
                        final /* synthetic */ Function1 $callBackOnSuccess;

                        public void onFailure(@NotNull Call call, @NotNull IOException e) {
                            Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                            String string = e.getMessage();
                            if (string == null) {
                                string = "Refresh token error";
                            }
                            this.$callBackOnFailed.invoke((Object)new RefreshTokenException(string));
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public void onResponse(@NotNull Call call, @NotNull Response response) {
                            Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                            Log.d((String)TokenManager.class.getName(), (String)(" <-- " + response.code() + " " + this.$request.url()));
                            if (response.code() == 200) {
                                if (response.body() != null) {
                                    Gson gson = new Gson();
                                    ResponseBody responseBody = response.body();
                                    if (responseBody == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    Object object = gson.fromJson(responseBody.string(), new TypeToken<Map<String, ? extends Object>>(){}.getType());
                                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Gson().fromJson(\n       \u2026                        )");
                                    Map refreshTokenResponse2 = (Map)object;
                                    Log.d((String)TokenManager.class.getName(), (String)("body: " + refreshTokenResponse2));
                                    if (refreshTokenResponse2.get("data") != null) {
                                        V v = refreshTokenResponse2.get("data");
                                        if (v == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, java.lang.Object>");
                                        }
                                        com.natradac.android.tokeninterceptor.TokenManager$Companion.access$updateToken(TokenManager.Companion, (Map)v, this.$callBackOnSuccess);
                                        return;
                                    } else if (refreshTokenResponse2.get("datas") != null) {
                                        V v = refreshTokenResponse2.get("datas");
                                        if (v == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, java.lang.Object>");
                                        }
                                        com.natradac.android.tokeninterceptor.TokenManager$Companion.access$updateToken(TokenManager.Companion, (Map)v, this.$callBackOnSuccess);
                                        return;
                                    } else {
                                        if (refreshTokenResponse2 == null) throw (Throwable)new CannotMapResponseToObject();
                                        com.natradac.android.tokeninterceptor.TokenManager$Companion.access$updateToken(TokenManager.Companion, refreshTokenResponse2, this.$callBackOnSuccess);
                                    }
                                    return;
                                } else {
                                    this.$callBackOnFailed.invoke((Object)new RefreshTokenException("Response body: " + response.body()));
                                }
                                return;
                            } else {
                                this.$callBackOnFailed.invoke((Object)new RefreshTokenException("Response code: " + response.code() + ", message: " + response.message()));
                            }
                        }
                        {
                            this.$callBackOnFailed = $captured_local_variable$0;
                            this.$request = $captured_local_variable$1;
                            this.$callBackOnSuccess = $captured_local_variable$2;
                        }
                    });
                }
            } else {
                String string;
                String string2;
                String string3;
                void key$iv;
                void $this$get$iv;
                SharedPreferences request = PreferenceHelper.INSTANCE.defaultPrefs(context);
                PreferenceHelper preferenceHelper = PreferenceHelper.INSTANCE;
                String string4 = "TOKEN";
                Function1<? super String, Unit> function1 = callBackOnSuccess;
                Object defaultValue$iv = null;
                boolean $i$f$get = false;
                KClass kClass = Reflection.getOrCreateKotlinClass(String.class);
                if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    string3 = $this$get$iv.getString((String)key$iv, (String)null);
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    string3 = (String)((Object)Integer.valueOf($this$get$iv.getInt((String)key$iv, -1)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    string3 = (String)((Object)Boolean.valueOf($this$get$iv.getBoolean((String)key$iv, false)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    string3 = (String)((Object)Float.valueOf($this$get$iv.getFloat((String)key$iv, -1.0f)));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    string3 = (String)((Object)Long.valueOf($this$get$iv.getLong((String)key$iv, -1L)));
                } else {
                    throw (Throwable)new UnsupportedOperationException("Not yet implemented");
                }
                if ((string2 = (string = string3)) == null) {
                    string2 = "";
                }
                Unit cfr_ignored_6 = (Unit)function1.invoke((Object)string2);
            }
        }

        private final void updateToken(Map<String, ? extends Object> data, Function1<? super String, Unit> callBackOnSuccess) {
            if (data.get(RefreshTokenManager.INSTANCE.getAccessTokenKey()) != null && data.get(RefreshTokenManager.INSTANCE.getRefreshTokenKey()) != null && data.get(RefreshTokenManager.INSTANCE.getAccessValidKey()) != null && data.get(RefreshTokenManager.INSTANCE.getRefreshValidKey()) != null) {
                Object object = data.get(RefreshTokenManager.INSTANCE.getAccessValidKey());
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
                }
                Object object2 = data.get(RefreshTokenManager.INSTANCE.getRefreshValidKey());
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
                }
                RefreshTokenManager.INSTANCE.updateToken(String.valueOf(data.get(RefreshTokenManager.INSTANCE.getAccessTokenKey())), String.valueOf(data.get(RefreshTokenManager.INSTANCE.getRefreshTokenKey())), (long)((Double)object).doubleValue(), (long)((Double)object2).doubleValue());
                callBackOnSuccess.invoke((Object)String.valueOf(data.get(RefreshTokenManager.INSTANCE.getAccessTokenKey())));
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$updateToken(Companion $this, Map data, Function1 callBackOnSuccess) {
            $this.updateToken(data, (Function1<? super String, Unit>)callBackOnSuccess);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

