/*
 * Decompiled with CFR 0.152.
 */
package com.natradac.android.tokeninterceptor;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.natradac.android.tokeninterceptor.CannotMapResponseToObject;
import com.natradac.android.tokeninterceptor.ConfigInterceptor;
import com.natradac.android.tokeninterceptor.NotFoundTokenException;
import com.natradac.android.tokeninterceptor.RefreshTokenException;
import com.natradac.android.tokeninterceptor.RefreshTokenExpired;
import com.natradac.android.tokeninterceptor.RefreshTokenManager;
import com.natradac.android.tokeninterceptor.TokenRequestParamType;
import com.natradac.android.tokeninterceptor.db.PreferenceHelper;
import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u000e\u001a\u00020\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/natradac/android/tokeninterceptor/ExpiredTokenInterceptor;", "Lokhttp3/Interceptor;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getModifiedRequest", "Lokhttp3/Request;", "oldRequest", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "refreshToken", "", "updateToken", "data", "", "", "Ljava/lang/Object;", "TokenInterceptor_release"})
public final class ExpiredTokenInterceptor
implements Interceptor {
    private final Context context;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request();
        SharedPreferences pref = PreferenceHelper.INSTANCE.defaultPrefs(this.context);
        try {
            Response response;
            String token = pref.getString("TOKEN", null);
            if (token == null) {
                throw (Throwable)new NotFoundTokenException();
            }
            if (PreferenceHelper.INSTANCE.isAccessTokenExpired(this.context)) {
                if (PreferenceHelper.INSTANCE.isRefreshTokenExpired(this.context)) {
                    throw (Throwable)new RefreshTokenExpired();
                }
                this.refreshToken(chain);
                response = chain.proceed(this.getModifiedRequest(request, this.context));
            } else {
                response = chain.proceed(this.getModifiedRequest(request, this.context));
            }
            return response;
        }
        catch (Exception e) {
            throw (Throwable)new IOException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void refreshToken(Interceptor.Chain chain) {
        Request request = RefreshTokenManager.INSTANCE.getRequest();
        Log.d((String)this.getClass().getName(), (String)(request.method() + " --> " + request.url()));
        Log.d((String)this.getClass().getName(), (String)("Header " + request.headers()));
        Log.d((String)this.getClass().getName(), (String)("Body " + request.body()));
        Response response = chain.proceed(request);
        Log.d((String)this.getClass().getName(), (String)(" <-- " + response.code() + " " + request.url()));
        if (response.code() != 200) throw (Throwable)new RefreshTokenException("Response code: " + response.code() + ", message: " + response.message());
        if (response.body() == null) throw (Throwable)new RefreshTokenException("Response body: " + response.body());
        Gson gson = new Gson();
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        Object object = gson.fromJson(responseBody.string(), new TypeToken<Map<String, ? extends Object>>(){}.getType());
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Gson().fromJson(\n       \u2026ype\n                    )");
        Map refreshTokenResponse2 = (Map)object;
        Log.d((String)this.getClass().getName(), (String)("body: " + refreshTokenResponse2));
        if (refreshTokenResponse2.get("data") != null) {
            Object v = refreshTokenResponse2.get("data");
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, java.lang.Object>");
            }
            this.updateToken((Map)v);
            return;
        } else if (refreshTokenResponse2.get("datas") != null) {
            Object v = refreshTokenResponse2.get("datas");
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, java.lang.Object>");
            }
            this.updateToken((Map)v);
            return;
        } else {
            if (refreshTokenResponse2 == null) throw (Throwable)new CannotMapResponseToObject();
            this.updateToken(refreshTokenResponse2);
        }
    }

    private final void updateToken(Map<String, ? extends Object> data) {
        if (data.get(RefreshTokenManager.INSTANCE.getAccessTokenKey()) != null && data.get(RefreshTokenManager.INSTANCE.getRefreshTokenKey()) != null && data.get(RefreshTokenManager.INSTANCE.getAccessValidKey()) != null && data.get(RefreshTokenManager.INSTANCE.getRefreshValidKey()) != null) {
            Object object = data.get(RefreshTokenManager.INSTANCE.getAccessValidKey());
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
            }
            Object object2 = data.get(RefreshTokenManager.INSTANCE.getRefreshValidKey());
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
            }
            RefreshTokenManager.INSTANCE.updateToken(String.valueOf(data.get(RefreshTokenManager.INSTANCE.getAccessTokenKey())), String.valueOf(data.get(RefreshTokenManager.INSTANCE.getRefreshTokenKey())), (long)((Double)object).doubleValue(), (long)((Double)object2).doubleValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Request getModifiedRequest(Request oldRequest, Context context) {
        SharedPreferences pref = PreferenceHelper.INSTANCE.defaultPrefs(context);
        TokenRequestParamType tokenRequestParamType = ConfigInterceptor.INSTANCE.getTokenParamType();
        if (Intrinsics.areEqual((Object)tokenRequestParamType, (Object)TokenRequestParamType.Query.INSTANCE)) {
            String string;
            void defaultValue$iv;
            void key$iv;
            void $this$get$iv;
            SharedPreferences sharedPreferences = pref;
            PreferenceHelper preferenceHelper = PreferenceHelper.INSTANCE;
            String string2 = "TOKEN";
            String string3 = "";
            String string4 = ConfigInterceptor.INSTANCE.getTokenKey();
            HttpUrl.Builder builder = oldRequest.url().newBuilder();
            boolean $i$f$get = false;
            KClass kClass = Reflection.getOrCreateKotlinClass(String.class);
            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                string = $this$get$iv.getString((String)key$iv, (String)defaultValue$iv);
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                Object v1 = defaultValue$iv;
                if (!(v1 instanceof Integer)) {
                    v1 = null;
                }
                Integer n = v1;
                string = (String)((Object)Integer.valueOf($this$get$iv.getInt((String)key$iv, n != null ? n : -1)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                Object v3 = defaultValue$iv;
                if (!(v3 instanceof Boolean)) {
                    v3 = null;
                }
                Boolean bl = v3;
                string = (String)((Object)Boolean.valueOf($this$get$iv.getBoolean((String)key$iv, bl != null ? bl : false)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                Object v5 = defaultValue$iv;
                if (!(v5 instanceof Float)) {
                    v5 = null;
                }
                Float f = v5;
                string = (String)((Object)Float.valueOf($this$get$iv.getFloat((String)key$iv, f != null ? f.floatValue() : -1.0f)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                Object v7 = defaultValue$iv;
                if (!(v7 instanceof Long)) {
                    v7 = null;
                }
                Long l = v7;
                string = (String)((Object)Long.valueOf($this$get$iv.getLong((String)key$iv, l != null ? l : -1L)));
            } else {
                throw (Throwable)new UnsupportedOperationException("Not yet implemented");
            }
            String string5 = string;
            HttpUrl url = builder.addQueryParameter(string4, String.valueOf(string5)).build();
            Request newRequest = oldRequest.newBuilder().url(url).build();
            Log.d((String)this.getClass().getName(), (String)(newRequest.method() + " --> " + newRequest.url()));
            Log.d((String)this.getClass().getName(), (String)("Header " + newRequest.headers().toString()));
            Log.d((String)this.getClass().getName(), (String)("Body " + String.valueOf(newRequest.body())));
            return newRequest;
        }
        if (Intrinsics.areEqual((Object)tokenRequestParamType, (Object)TokenRequestParamType.Header.INSTANCE)) {
            String string;
            SharedPreferences $this$get$iv = pref;
            PreferenceHelper preferenceHelper = PreferenceHelper.INSTANCE;
            String key$iv = "TOKEN";
            String defaultValue$iv = "";
            String string6 = ConfigInterceptor.INSTANCE.getTokenKey();
            Request.Builder builder = oldRequest.newBuilder();
            boolean $i$f$get = false;
            KClass kClass = Reflection.getOrCreateKotlinClass(String.class);
            if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                string = $this$get$iv.getString(key$iv, defaultValue$iv);
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                String string7 = defaultValue$iv;
                if (!(string7 instanceof Integer)) {
                    string7 = null;
                }
                Integer n = (Integer)((Object)string7);
                string = (String)((Object)Integer.valueOf($this$get$iv.getInt(key$iv, n != null ? n : -1)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                String string8 = defaultValue$iv;
                if (!(string8 instanceof Boolean)) {
                    string8 = null;
                }
                Boolean bl = (Boolean)((Object)string8);
                string = (String)((Object)Boolean.valueOf($this$get$iv.getBoolean(key$iv, bl != null ? bl : false)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                String string9 = defaultValue$iv;
                if (!(string9 instanceof Float)) {
                    string9 = null;
                }
                Float f = (Float)((Object)string9);
                string = (String)((Object)Float.valueOf($this$get$iv.getFloat(key$iv, f != null ? f.floatValue() : -1.0f)));
            } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                String string10 = defaultValue$iv;
                if (!(string10 instanceof Long)) {
                    string10 = null;
                }
                Long l = (Long)((Object)string10);
                string = (String)((Object)Long.valueOf($this$get$iv.getLong(key$iv, l != null ? l : -1L)));
            } else {
                throw (Throwable)new UnsupportedOperationException("Not yet implemented");
            }
            String string11 = string;
            Request newRequest = builder.addHeader(string6, String.valueOf(string11)).build();
            Log.d((String)this.getClass().getName(), (String)(newRequest.method() + " --> " + newRequest.url()));
            Log.d((String)this.getClass().getName(), (String)("Header " + newRequest.headers().toString()));
            Log.d((String)this.getClass().getName(), (String)("Body " + String.valueOf(newRequest.body())));
            return newRequest;
        }
        Log.d((String)this.getClass().getName(), (String)(oldRequest.method() + " --> " + oldRequest.url()));
        Log.d((String)this.getClass().getName(), (String)("Header " + oldRequest.headers().toString()));
        Log.d((String)this.getClass().getName(), (String)("Body " + String.valueOf(oldRequest.body())));
        return oldRequest;
    }

    public ExpiredTokenInterceptor(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

