/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridj.BridJ;
import org.bridj.BridJRuntime;
import org.bridj.NativeObject;
import org.bridj.ann.Constructor;
import org.bridj.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBridJRuntime
implements BridJRuntime {
    protected boolean log(Level level, String message, Throwable ex) {
        if (!BridJ.shouldLog(level)) {
            return true;
        }
        Logger.getLogger(this.getClass().getName()).log(level, message, ex);
        return true;
    }

    protected boolean log(Level level, String message) {
        return this.log(level, message, null);
    }

    @Override
    public void unregister(Type type) {
    }

    @Override
    public Type getType(NativeObject instance) {
        if (instance == null) {
            return null;
        }
        return Utils.getClass(instance.getClass());
    }

    protected java.lang.reflect.Constructor findConstructor(Class<?> type, int constructorId, boolean onlyWithAnnotation) throws SecurityException, NoSuchMethodException {
        for (java.lang.reflect.Constructor<?> c : type.getDeclaredConstructors()) {
            Constructor ca = c.getAnnotation(Constructor.class);
            if (ca == null || ca.value() != constructorId) continue;
            return c;
        }
        if (constructorId < 0) {
            return type.getConstructor(new Class[0]);
        }
        Class<?> sup = type.getSuperclass();
        if (sup != null) {
            try {
                java.lang.reflect.Constructor<?>[] ccs;
                java.lang.reflect.Constructor c = this.findConstructor(sup, constructorId, onlyWithAnnotation);
                if (onlyWithAnnotation && c != null) {
                    return c;
                }
                Type[] params = c.getGenericParameterTypes();
                for (java.lang.reflect.Constructor<?> cc : ccs = type.getDeclaredConstructors()) {
                    int overrideOffset;
                    Type[] ccparams = cc.getGenericParameterTypes();
                    if (!AbstractBridJRuntime.isOverridenSignature(params, ccparams, overrideOffset = Utils.getEnclosedConstructorParametersOffset(cc))) continue;
                    return cc;
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        throw new NoSuchMethodException("Cannot find constructor with index " + constructorId);
    }

    public static boolean isOverridenSignature(Type[] parentSignature, Type[] overrideSignature, int overrideOffset) {
        int n = parentSignature.length;
        if (overrideSignature.length - overrideOffset != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (AbstractBridJRuntime.isOverride(parentSignature[i], overrideSignature[overrideOffset + i])) continue;
            return false;
        }
        return true;
    }

    protected static boolean isOverride(Type parentSignature, Type overrideSignature) {
        return Utils.getClass(parentSignature).isAssignableFrom(Utils.getClass(overrideSignature));
    }
}

