/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.view;

import android.content.Context;
import android.support.design.widget.CoordinatorLayout;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.nasserkhosravi.appcomponent.Device;
import com.nasserkhosravi.appcomponent.R;
import com.nasserkhosravi.appcomponent.ResHelper;
import com.nasserkhosravi.appcomponent.ViewComponentConfig;
import com.nasserkhosravi.appcomponent.utils.DimensUtils;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0000J\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/nasserkhosravi/appcomponent/view/ProgressBuilder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "height", "", "layoutGravity", "width", "buildCircleProgressView", "Landroid/view/View;", "buildCustom", "buildLinearProgressView", "title", "", "inCenter", "withSizeDP", "Companion", "library_release"})
public final class ProgressBuilder {
    private int width;
    private int height;
    private int layoutGravity;
    private Context context;
    public static final int CIRCLE_PROGRESS = 0;
    public static final int LINEAR_PROGRESS = 1;
    public static final int CUSTOM_PROGRESS = 2;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ProgressBuilder inCenter() {
        this.layoutGravity = 17;
        return this;
    }

    @NotNull
    public final ProgressBuilder withSizeDP(int width, int height) {
        this.width = DimensUtils.INSTANCE.dpToPx(width);
        this.height = DimensUtils.INSTANCE.dpToPx(height);
        return this;
    }

    @NotNull
    public final View buildCircleProgressView() {
        ProgressBar view = new ProgressBar(this.context, null, 16843399);
        view.setIndeterminate(true);
        view.setId(R.id.progressView);
        view.setVisibility(8);
        view.setIndeterminate(true);
        if (this.height == 0 && this.width == 0) {
            this.withSizeDP(40, 40);
        }
        CoordinatorLayout.LayoutParams layoutParams = new CoordinatorLayout.LayoutParams(this.width, this.height);
        if (this.layoutGravity == 17) {
            layoutParams.gravity = 17;
        }
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return (View)view;
    }

    @NotNull
    public final View buildLinearProgressView(@NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        TextView tvTitle = new TextView(this.context);
        tvTitle.setTextSize(1, 14.0f);
        tvTitle.setTypeface(null, 1);
        tvTitle.setTextColor(ResHelper.INSTANCE.getColorRes(R.color.secondary_text));
        tvTitle.setText((CharSequence)title);
        LinearLayout.LayoutParams lpTV = new LinearLayout.LayoutParams(-2, -2);
        lpTV.gravity = 17;
        tvTitle.setLayoutParams((ViewGroup.LayoutParams)lpTV);
        View view = View.inflate((Context)this.context, (int)R.layout.widget_linear_progress_bar, null);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.ProgressBar");
        }
        ProgressBar progress = (ProgressBar)view;
        if (this.width == 0) {
            this.width = Device.get().width / 2;
        }
        if (this.height == 0) {
            this.height = (int)this.context.getResources().getDimension(R.dimen.default_linear_progress_height);
        }
        LinearLayout.LayoutParams lpProgress = new LinearLayout.LayoutParams(this.width, this.height);
        lpProgress.gravity = 17;
        progress.setLayoutParams((ViewGroup.LayoutParams)lpProgress);
        LinearLayout layout2 = new LinearLayout(this.context);
        layout2.setOrientation(1);
        layout2.addView((View)tvTitle);
        layout2.addView((View)progress);
        CoordinatorLayout.LayoutParams layoutParams = new CoordinatorLayout.LayoutParams(-2, -2);
        if (this.layoutGravity == 17) {
            layoutParams.gravity = 17;
        }
        layout2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layout2.setVisibility(8);
        return (View)layout2;
    }

    @NotNull
    public final View buildCustom() {
        View progress = View.inflate((Context)this.context, (int)R.layout.widget_custom_progress_bar, null);
        CoordinatorLayout.LayoutParams layoutParams = new CoordinatorLayout.LayoutParams(this.width, this.height);
        if (this.layoutGravity == 17) {
            layoutParams.gravity = 17;
        }
        View view = progress;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"progress");
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return progress;
    }

    public ProgressBuilder(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.layoutGravity = 17;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/nasserkhosravi/appcomponent/view/ProgressBuilder$Companion;", "", "()V", "CIRCLE_PROGRESS", "", "CUSTOM_PROGRESS", "LINEAR_PROGRESS", "createFrom", "Landroid/view/View;", "context", "Landroid/content/Context;", "config", "Lcom/nasserkhosravi/appcomponent/ViewComponentConfig;", "library_release"})
    public static final class Companion {
        @NotNull
        public final View createFrom(@NotNull Context context, @NotNull ViewComponentConfig config) {
            View view;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            switch (config.getProgressType()) {
                case 0: {
                    view = new ProgressBuilder(context).inCenter().buildCircleProgressView();
                    break;
                }
                case 1: {
                    String string2;
                    if (config.getProgressTitle() == null) {
                        string2 = ResHelper.INSTANCE.getString(context, R.string.linear_progress_text);
                    } else {
                        string2 = config.getProgressTitle();
                        if (string2 == null) {
                            Intrinsics.throwNpe();
                        }
                    }
                    String progressTitle = string2;
                    view = new ProgressBuilder(context).inCenter().buildLinearProgressView(progressTitle);
                    break;
                }
                case 2: {
                    view = new ProgressBuilder(context).inCenter().buildCustom();
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException();
                }
            }
            return view;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

