/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.utils;

import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import com.nasserkhosravi.appcomponent.AppContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006\u00a8\u0006\u000e"}, d2={"Lcom/nasserkhosravi/appcomponent/utils/DimensUtils;", "", "()V", "dpToPx", "", "dps", "", "getHeightOfTV", "tv", "Landroid/widget/TextView;", "textSize", "deviceWidth", "spToPx", "sps", "library_release"})
public final class DimensUtils {
    public static final DimensUtils INSTANCE;

    public final int spToPx(int sps) {
        Resources resources = AppContext.INSTANCE.get().getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"AppContext.get().resources");
        return Math.round(resources.getDisplayMetrics().scaledDensity * (float)sps);
    }

    public final int dpToPx(int dps) {
        Resources resources = AppContext.INSTANCE.get().getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"AppContext.get().resources");
        return Math.round(resources.getDisplayMetrics().density * (float)dps);
    }

    public final float spToPx(float sps) {
        Resources resources = AppContext.INSTANCE.get().getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"AppContext.get().resources");
        DisplayMetrics dm = resources.getDisplayMetrics();
        return TypedValue.applyDimension((int)2, (float)sps, (DisplayMetrics)dm);
    }

    public final float dpToPx(float dps) {
        Resources resources = AppContext.INSTANCE.get().getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"AppContext.get().resources");
        DisplayMetrics dm = resources.getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)dps, (DisplayMetrics)dm);
    }

    public final int getHeightOfTV(@NotNull TextView tv, float textSize, int deviceWidth) {
        Intrinsics.checkParameterIsNotNull((Object)tv, (String)"tv");
        tv.setTextSize(0, textSize);
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)deviceWidth, (int)Integer.MIN_VALUE);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        tv.measure(widthMeasureSpec, heightMeasureSpec);
        return tv.getMeasuredHeight();
    }

    private DimensUtils() {
    }

    static {
        DimensUtils dimensUtils;
        INSTANCE = dimensUtils = new DimensUtils();
    }
}

