/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.utils;

import com.nasserkhosravi.appcomponent.utils.DateFormats;
import com.nasserkhosravi.appcomponent.utils.calendar.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class CalenderUtils {
    private CalenderUtils() {
    }

    public static Date convertToDate(String date, DateFormats format) {
        try {
            return new SimpleDateFormat(format.asString()).parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Date or Format is not correct. Date is:" + date + " Format is:" + (Object)((Object)format));
        }
    }

    public static String convertToString(long date, DateFormats format) {
        return new SimpleDateFormat(format.asString()).format(new Date(date));
    }

    public static String YMDtoJalali(String gregorianDate) {
        Date date = CalenderUtils.convertToDate(gregorianDate, DateFormats.YEAR_MONTH_DAY);
        return DateUtils.getPersianDateString(date);
    }

    public static String getFormattedCurrentDateYID() {
        return new SimpleDateFormat(DateFormats.YEAR_MONTH_DAY.asString(), Locale.getDefault()).format(new Date());
    }

    public static long getCurrentTime() {
        return new Date().getTime();
    }
}

