/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.error;

import com.google.gson.stream.MalformedJsonException;
import com.nasserkhosravi.appcomponent.R;
import com.nasserkhosravi.appcomponent.error.HttpException;
import com.nasserkhosravi.appcomponent.error.NetworkErrorModel;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Response;

public class ErrorInspector {
    public static NetworkErrorModel exceptionTypeFactory(Throwable throwable, int errorId) {
        int resourceString;
        int code;
        if (throwable instanceof SocketTimeoutException || throwable instanceof NoRouteToHostException) {
            code = 3;
            resourceString = R.string.No_server_connection;
        } else if (throwable instanceof ConnectException || throwable instanceof UnknownHostException) {
            code = 2;
            resourceString = R.string.No_internet_connection;
        } else if (throwable instanceof HttpException || throwable instanceof MalformedJsonException) {
            code = 1;
            resourceString = R.string.Problem_in_catching_data;
        } else {
            code = 0;
            resourceString = R.string.Un_expected_exception;
        }
        return new NetworkErrorModel(errorId, code, resourceString);
    }

    public JSONObject convertErrorBody(Response response) {
        try {
            return new JSONObject(response.errorBody().string());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

