/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import java.util.Locale;

public class LocaleHelper {
    public static final String LANGUAGE_PREFERENCE = "language_preference";
    private static final String SELECTED_LANGUAGE = "Locale.Helper.Selected.Language";

    public static Context onAttach(Context context) {
        String lang = LocaleHelper.getPersistedData(context, Locale.getDefault().getLanguage());
        return LocaleHelper.setLocale(context, lang);
    }

    public static Context onAttach(Context context, String defaultLanguage) {
        String lang = LocaleHelper.getPersistedData(context, defaultLanguage);
        return LocaleHelper.setLocale(context, lang);
    }

    public static String getLanguage(Context context) {
        return LocaleHelper.getPersistedData(context, Locale.getDefault().getLanguage());
    }

    public static Context setLocale(Context context, String language) {
        LocaleHelper.persist(context, language);
        if (Build.VERSION.SDK_INT >= 24) {
            return LocaleHelper.updateResources(context, language);
        }
        return LocaleHelper.updateResourcesLegacy(context, language);
    }

    private static String getPersistedData(Context context, String defaultLanguage) {
        SharedPreferences preferences = context.getSharedPreferences(LANGUAGE_PREFERENCE, 0);
        return preferences.getString(SELECTED_LANGUAGE, defaultLanguage);
    }

    private static void persist(Context context, String language) {
        SharedPreferences preferences = context.getSharedPreferences(LANGUAGE_PREFERENCE, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(SELECTED_LANGUAGE, language);
        editor.apply();
    }

    @TargetApi(value=24)
    private static Context updateResources(Context context, String language) {
        Locale locale = new Locale(language);
        Locale.setDefault(locale);
        Configuration configuration = context.getResources().getConfiguration();
        configuration.setLocale(locale);
        return context.createConfigurationContext(configuration);
    }

    private static Context updateResourcesLegacy(Context context, String language) {
        Locale locale = new Locale(language);
        Locale.setDefault(locale);
        Resources resources = context.getResources();
        Configuration configuration = resources.getConfiguration();
        configuration.locale = locale;
        resources.updateConfiguration(configuration, resources.getDisplayMetrics());
        return context;
    }
}

