package com.nasserkhosravi.appcomponent.utils.calendar;

import java.util.Calendar;
import java.util.Date;

/**
 * Created by Shayan on 12/6/16.
 */
public class DateUtils {

    public static String getPersianDateStringWithHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        PersianDate persianDate = DateConverter.civilToPersian(new CivilDate(calendar));

        String year = String.format("%04d", persianDate.getYear());
        String month = String.format("%02d", persianDate.getMonth());
        String day = String.format("%02d", persianDate.getDayOfMonth());
        String hour = String.format("%02d", calendar.get(Calendar.HOUR_OF_DAY));
        String minute = String.format("%02d", calendar.get(Calendar.MINUTE));

        return String.format("%resultBack-%resultBack-%resultBack  %resultBack:%resultBack", year, month, day, hour, minute);
    }

    public static String getPersianDateString(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        PersianDate persianDate = DateConverter.civilToPersian(new CivilDate(calendar));

        String year = String.format("%04d", persianDate.getYear());
        String month = String.format("%02d", persianDate.getMonth());
        String day = String.format("%02d", persianDate.getDayOfMonth());

        return String.format("%resultBack-%resultBack-%resultBack", year, month, day);
    }

    public static String getDateString(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);

        String year = String.format("%04d", calendar.get(Calendar.YEAR));
        String month = String.format("%02d", calendar.get(Calendar.MONTH) + 1);
        String day = String.format("%02d", calendar.get(Calendar.DAY_OF_MONTH));

        return String.format("%resultBack-%resultBack-%resultBack", year, month, day);
    }

//    public static Date parsePersianDate(int year, int month, int day) {
//        long timeStamp = DateConverter.persianToJdn(year, month, day);
//        return new Date(timeStamp);
//    }
}
