package com.nasserkhosravi.appcomponent.error;


import com.google.gson.stream.MalformedJsonException;
import com.nasserkhosravi.appcomponent.R;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Response;

import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

/**
 * Created by Nasser on 11/6/2017
 */
public class ErrorInspector {

    public static NetworkErrorModel exceptionTypeFactory(Throwable throwable, int errorId) {
        int code;
        int resourceString;
        if (throwable instanceof SocketTimeoutException || throwable instanceof NoRouteToHostException) {
            code = NetworkErrorModel.NO_SERVER_CONNECTION;
            resourceString = R.string.No_server_connection;
        } else if (throwable instanceof ConnectException || throwable instanceof UnknownHostException) {
            code = NetworkErrorModel.NO_INTERNET;
            resourceString = R.string.No_internet_connection;
        } else if (throwable instanceof HttpException || throwable instanceof MalformedJsonException) {
            code = NetworkErrorModel.HTTP;
            resourceString = R.string.Problem_in_catching_data;
        } else {
            code = NetworkErrorModel.UN_KNOWN;
            resourceString = R.string.Un_expected_exception;
        }
        return new NetworkErrorModel(errorId, code, resourceString);
    }

    public JSONObject convertErrorBody(Response response) {
        try {
            return new JSONObject(response.errorBody().string());
        } catch (JSONException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

}
