package com.nasserkhosravi.appcomponent

import android.content.Context
import android.support.annotation.NonNull
import android.view.ViewGroup

/**
 * Created by Nasser Khosravi on 12/24/2017
 */
open class AppComponent(override var ctx: Context) : ResourceComponent {

    private lateinit var config: ViewComponentConfig
    private lateinit var viewGroupManager: BaseViewGroupManager
    private lateinit var viewManger: BaseViewAccessor

    fun construct() {
        config = ViewComponentConfig()
        viewGroupManager = BaseViewGroupManager()
        viewManger = BaseViewAccessor(this, viewGroupManager, config)
    }

    fun getConfig(): ViewComponentConfig {
        return config
    }

    fun getViewAccessor(): BaseViewAccessor {
        return viewManger
    }

    fun getViewGroupManager(): BaseViewGroupManager {
        return viewGroupManager
    }

    @NonNull
    fun getViewGroup(): ViewGroup? {
        return viewGroupManager.viewGroup
    }


}