/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.utils.calendar;

import com.nasserkhosravi.appcomponent.utils.calendar.AbstractDate;
import com.nasserkhosravi.appcomponent.utils.calendar.DayOutOfRangeException;
import com.nasserkhosravi.appcomponent.utils.calendar.MonthOutOfRangeException;
import com.nasserkhosravi.appcomponent.utils.calendar.YearOutOfRangeException;
import java.util.Calendar;

public class PersianDate
extends AbstractDate {
    private int year;
    private int month;
    private int day;

    public PersianDate(int year, int month, int day) {
        this.setYear(year);
        this.day = 1;
        this.setMonth(month);
        this.setDayOfMonth(day);
    }

    @Override
    public PersianDate clone() {
        return new PersianDate(this.getYear(), this.getMonth(), this.getDayOfMonth());
    }

    @Override
    public int getDayOfMonth() {
        return this.day;
    }

    @Override
    public void setDayOfMonth(int day) {
        if (day < 1) {
            throw new DayOutOfRangeException("day " + day + " " + "is out of range!");
        }
        if (this.month <= 6 && day > 31) {
            throw new DayOutOfRangeException("day " + day + " " + "is out of range!");
        }
        if (this.month > 6 && this.month <= 12 && day > 30) {
            throw new DayOutOfRangeException("day " + day + " " + "is out of range!");
        }
        if (this.isLeapYear() && this.month == 12 && day > 30) {
            throw new DayOutOfRangeException("day " + day + " " + "is out of range!");
        }
        if (!this.isLeapYear() && this.month == 12 && day > 29) {
            throw new DayOutOfRangeException("day " + day + " " + "is out of range!");
        }
        this.day = day;
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public void setMonth(int month) {
        if (month < 1 || month > 12) {
            throw new MonthOutOfRangeException("month " + month + " " + "is out of range!");
        }
        this.setDayOfMonth(this.day);
        this.month = month;
    }

    @Override
    public int getWeekOfYear() {
        throw new RuntimeException("not implemented yet!");
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public void setYear(int year) {
        if (year == 0) {
            throw new YearOutOfRangeException("Year 0 is invalid!");
        }
        this.year = year;
    }

    @Override
    public void rollDay(int amount, boolean up) {
        throw new RuntimeException("not implemented yet!");
    }

    @Override
    public void rollMonth(int amount, boolean up) {
        throw new RuntimeException("not implemented yet!");
    }

    @Override
    public void rollYear(int amount, boolean up) {
        throw new RuntimeException("not implemented yet!");
    }

    @Override
    public String getEvent() {
        throw new RuntimeException("not implemented yet!");
    }

    @Override
    public int getDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, this.year);
        cal.set(2, this.month - 1);
        cal.set(5, this.day);
        return cal.get(7);
    }

    @Override
    public int getDayOfYear() {
        throw new RuntimeException("not implemented yet!");
    }

    @Override
    public int getWeekOfMonth() {
        throw new RuntimeException("not implemented yet!");
    }

    @Override
    public boolean isLeapYear() {
        int y = this.year > 0 ? this.year - 474 : 473;
        return (y % 2820 + 474 + 38) * 682 % 2816 < 682;
    }

    public boolean equals(PersianDate persianDate) {
        return this.getDayOfMonth() == persianDate.getDayOfMonth() && this.getMonth() == persianDate.getMonth() && (this.getYear() == persianDate.getYear() || this.getYear() == -1);
    }
}

