/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.utils.calendar;

import com.nasserkhosravi.appcomponent.utils.calendar.CivilDate;
import com.nasserkhosravi.appcomponent.utils.calendar.IslamicDate;
import com.nasserkhosravi.appcomponent.utils.calendar.PersianDate;
import java.util.Calendar;
import java.util.Date;

public final class DateConverter {
    public static IslamicDate civilToIslamic(CivilDate civil, int offset) {
        return DateConverter.jdnToIslamic(DateConverter.civilToJdn(civil) + (long)offset);
    }

    public static long civilToJdn(CivilDate civil) {
        long lYear = civil.getYear();
        long lMonth = civil.getMonth();
        long lDay = civil.getDayOfMonth();
        if (lYear > 1582L || lYear == 1582L && lMonth > 10L || lYear == 1582L && lMonth == 10L && lDay > 14L) {
            return 1461L * (lYear + 4800L + (lMonth - 14L) / 12L) / 4L + 367L * (lMonth - 2L - 12L * ((lMonth - 14L) / 12L)) / 12L - 3L * ((lYear + 4900L + (lMonth - 14L) / 12L) / 100L) / 4L + lDay - 32075L;
        }
        return DateConverter.julianToJdn(lYear, lMonth, lDay);
    }

    public static PersianDate civilToPersian(CivilDate civil) {
        return DateConverter.jdnToPersian(DateConverter.civilToJdn(civil));
    }

    private static long floor(double d2) {
        return (long)Math.floor(d2);
    }

    public static CivilDate islamicToCivil(IslamicDate islamic) {
        return DateConverter.jdnToCivil(DateConverter.islamicToJdn(islamic));
    }

    public static long islamicToJdn(IslamicDate islamic) {
        int NMONTHS = 16861;
        int year = islamic.getYear();
        int month = islamic.getMonth();
        int day = islamic.getDayOfMonth();
        if (year < 0) {
            ++year;
        }
        long k = month + year * 12 - NMONTHS;
        return DateConverter.floor(DateConverter.visibility(k + 1048L) + (double)day + 0.5);
    }

    public static PersianDate islamicToPersian(IslamicDate islamic) {
        return DateConverter.jdnToPersian(DateConverter.islamicToJdn(islamic));
    }

    public static CivilDate jdnToCivil(long jdn) {
        if (jdn > 2299160L) {
            long l = jdn + 68569L;
            long n = 4L * l / 146097L;
            long i = 4000L * ((l -= (146097L * n + 3L) / 4L) + 1L) / 1461001L;
            l = l - 1461L * i / 4L + 31L;
            long j = 80L * l / 2447L;
            int day = (int)(l - 2447L * j / 80L);
            l = j / 11L;
            int month = (int)(j + 2L - 12L * l);
            int year = (int)(100L * (n - 49L) + i + l);
            return new CivilDate(year, month, day);
        }
        return DateConverter.jdnToJulian(jdn);
    }

    public static IslamicDate jdnToIslamic(long jd) {
        double mjd;
        CivilDate civil = DateConverter.jdnToCivil(jd);
        int year = civil.getYear();
        int month = civil.getMonth();
        int day = civil.getDayOfMonth();
        long k = DateConverter.floor(0.6 + ((double)year + (double)(month % 2 == 0 ? month : month - 1) / 12.0 + (double)((float)day / 365.0f) - 1900.0) * 12.3685);
        do {
            mjd = DateConverter.visibility(k);
            --k;
        } while (mjd > (double)jd - 0.5);
        long hm = ++k - 1048L;
        year = 1405 + (int)(hm / 12L);
        month = (int)(hm % 12L) + 1;
        if (hm != 0L && month <= 0) {
            month += 12;
            --year;
        }
        if (year <= 0) {
            --year;
        }
        day = (int)DateConverter.floor((double)jd - mjd + 0.5);
        return new IslamicDate(year, month, day);
    }

    public static CivilDate jdnToJulian(long jdn) {
        long j = jdn + 1402L;
        long k = (j - 1L) / 1461L;
        long l = j - 1461L * k;
        long n = (l - 1L) / 365L - l / 1461L;
        long i = l - 365L * n + 30L;
        j = 80L * i / 2447L;
        int day = (int)(i - 2447L * j / 80L);
        i = j / 11L;
        int month = (int)(j + 2L - 12L * i);
        int year = (int)(4L * k + n + i - 4716L);
        return new CivilDate(year, month, day);
    }

    public static PersianDate jdnToPersian(long jdn) {
        long yday;
        long ycycle;
        long depoch = jdn - DateConverter.persianToJdn(475, 1, 1);
        long cycle = depoch / 1029983L;
        long cyear = depoch % 1029983L;
        if (cyear == 1029982L) {
            ycycle = 2820L;
        } else {
            long aux1 = cyear / 366L;
            long aux2 = cyear % 366L;
            ycycle = DateConverter.floor((double)(2134L * aux1 + 2816L * aux2 + 2815L) / 1028522.0) + aux1 + 1L;
        }
        int year = (int)(ycycle + 2820L * cycle + 474L);
        if (year <= 0) {
            --year;
        }
        int month = (yday = jdn - DateConverter.persianToJdn(year, 1, 1) + 1L) <= 186L ? (int)Math.ceil((double)yday / 31.0) : (int)Math.ceil((double)(yday - 6L) / 30.0);
        int day = (int)(jdn - DateConverter.persianToJdn(year, month, 1)) + 1;
        return new PersianDate(year, month, day);
    }

    public static long julianToJdn(long lYear, long lMonth, long lDay) {
        return 367L * lYear - 7L * (lYear + 5001L + (lMonth - 9L) / 7L) / 4L + 275L * lMonth / 9L + lDay + 1729777L;
    }

    public static Date persianToJavaDate(int year, int month, int day) {
        CivilDate civilDate = DateConverter.jdnToCivil(DateConverter.persianToJdn(year, month, day));
        Calendar cal = Calendar.getInstance();
        cal.set(civilDate.getYear(), civilDate.getMonth() - 1, civilDate.getDayOfMonth());
        return cal.getTime();
    }

    public static CivilDate persianToCivil(PersianDate persian) {
        return DateConverter.jdnToCivil(DateConverter.persianToJdn(persian));
    }

    public static IslamicDate persianToIslamic(PersianDate persian) {
        return DateConverter.jdnToIslamic(DateConverter.persianToJdn(persian));
    }

    public static long persianToJdn(int year, int month, int day) {
        long PERSIAN_EPOCH = 1948321L;
        long epbase = year >= 0 ? (long)(year - 474) : (long)(year - 473);
        long epyear = 474L + epbase % 2820L;
        long mdays = month <= 7 ? (long)((month - 1) * 31) : (long)((month - 1) * 30 + 6);
        return (long)day + mdays + (epyear * 682L - 110L) / 2816L + (epyear - 1L) * 365L + epbase / 2820L * 1029983L + 1948320L;
    }

    public static long persianToJdn(PersianDate persian) {
        int year = persian.getYear();
        int month = persian.getMonth();
        int day = persian.getDayOfMonth();
        long PERSIAN_EPOCH = 1948321L;
        long epbase = year >= 0 ? (long)(year - 474) : (long)(year - 473);
        long epyear = 474L + epbase % 2820L;
        long mdays = month <= 7 ? (long)((month - 1) * 31) : (long)((month - 1) * 30 + 6);
        return (long)day + mdays + (epyear * 682L - 110L) / 2816L + (epyear - 1L) * 365L + epbase / 2820L * 1029983L + 1948320L;
    }

    private static double tmoonphase(long n, int nph) {
        double xtra;
        double RPD = 0.0174532925199433;
        double k = (double)n + (double)nph / 4.0;
        double T = k / 1236.85;
        double t2 = T * T;
        double t3 = t2 * T;
        double jd = 2415020.75933 + 29.53058868 * k - 1.178E-4 * t2 - 1.55E-7 * t3 + 3.3E-4 * Math.sin(0.0174532925199433 * (166.56 + 132.87 * T - 0.009173 * t2));
        double sa = 0.0174532925199433 * (359.2242 + 29.10535608 * k - 3.33E-5 * t2 - 3.47E-6 * t3);
        double ma = 0.0174532925199433 * (306.0253 + 385.81691806 * k + 0.0107306 * t2 + 1.236E-5 * t3);
        double tf = 0.0349065850398866 * (21.2964 + 390.67050646 * k - 0.0016528 * t2 - 2.39E-6 * t3);
        switch (nph) {
            case 0: 
            case 2: {
                xtra = (0.1734 - 3.93E-4 * T) * Math.sin(sa) + 0.0021 * Math.sin(sa * 2.0) - 0.4068 * Math.sin(ma) + 0.0161 * Math.sin(2.0 * ma) - 4.0E-4 * Math.sin(3.0 * ma) + 0.0104 * Math.sin(tf) - 0.0051 * Math.sin(sa + ma) - 0.0074 * Math.sin(sa - ma) + 4.0E-4 * Math.sin(tf + sa) - 4.0E-4 * Math.sin(tf - sa) - 6.0E-4 * Math.sin(tf + ma) + 0.001 * Math.sin(tf - ma) + 5.0E-4 * Math.sin(sa + 2.0 * ma);
                break;
            }
            case 1: 
            case 3: {
                xtra = (0.1721 - 4.0E-4 * T) * Math.sin(sa) + 0.0021 * Math.sin(sa * 2.0) - 0.628 * Math.sin(ma) + 0.0089 * Math.sin(2.0 * ma) - 4.0E-4 * Math.sin(3.0 * ma) + 0.0079 * Math.sin(tf) - 0.0119 * Math.sin(sa + ma) - 0.0047 * Math.sin(sa - ma) + 3.0E-4 * Math.sin(tf + sa) - 4.0E-4 * Math.sin(tf - sa) - 6.0E-4 * Math.sin(tf + ma) + 0.0021 * Math.sin(tf - ma) + 3.0E-4 * Math.sin(sa + 2.0 * ma) + 4.0E-4 * Math.sin(sa - 2.0 * ma) - 3.0E-4 * Math.sin(2.0 * sa + ma);
                if (nph == 1) {
                    xtra = xtra + 0.0028 - 4.0E-4 * Math.cos(sa) + 3.0E-4 * Math.cos(ma);
                    break;
                }
                xtra = xtra - 0.0028 + 4.0E-4 * Math.cos(sa) - 3.0E-4 * Math.cos(ma);
                break;
            }
            default: {
                return 0.0;
            }
        }
        return jd + xtra - (0.41 + 1.2053 * T + 0.4992 * t2) / 1440.0;
    }

    private static double visibility(long n) {
        long d2;
        float TIMZ = 3.0f;
        float MINAGE = 13.5f;
        float SUNSET = 19.5f;
        float TIMDIF = 6.0f;
        double jd = DateConverter.tmoonphase(n, 0);
        double tf = jd - (double)(d2 = DateConverter.floor(jd));
        if (tf <= 0.5) {
            return jd + 1.0;
        }
        if ((tf = (tf - 0.5) * 24.0 + 3.0) > 6.0) {
            return jd + 1.0;
        }
        return jd;
    }
}

