/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.utils.calendar;

import com.nasserkhosravi.appcomponent.utils.calendar.AbstractDate;
import com.nasserkhosravi.appcomponent.utils.calendar.DayOutOfRangeException;
import com.nasserkhosravi.appcomponent.utils.calendar.MonthOutOfRangeException;
import com.nasserkhosravi.appcomponent.utils.calendar.YearOutOfRangeException;
import java.util.Calendar;

public class CivilDate
extends AbstractDate {
    private static final int[] daysInMonth = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int year;
    private int month;
    private int day;

    public CivilDate() {
        this(Calendar.getInstance());
    }

    public CivilDate(Calendar calendar) {
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
    }

    public CivilDate(int year, int month, int day) {
        this();
        this.setYear(year);
        this.day = 1;
        this.setMonth(month);
        this.setDayOfMonth(day);
    }

    @Override
    public int getDayOfMonth() {
        return this.day;
    }

    @Override
    public void setDayOfMonth(int day) {
        if (day < 1) {
            throw new DayOutOfRangeException("day " + day + " " + "is out of range!");
        }
        if (this.month != 2 && day > daysInMonth[this.month]) {
            throw new DayOutOfRangeException("day " + day + " " + "is out of range!");
        }
        if (this.month == 2 && this.isLeapYear() && day > 29) {
            throw new DayOutOfRangeException("day " + day + " " + "is out of range!");
        }
        if (this.month == 2 && !this.isLeapYear() && day > 28) {
            throw new DayOutOfRangeException("day " + day + " " + "is out of range!");
        }
        this.day = day;
    }

    @Override
    public int getDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, this.year);
        cal.set(2, this.month - 1);
        cal.set(5, this.day);
        return cal.get(7);
    }

    @Override
    public int getDayOfYear() {
        throw new RuntimeException("not implemented yet!");
    }

    @Override
    public String getEvent() {
        throw new RuntimeException("not implemented yet!");
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public void setMonth(int month) {
        if (month < 1 || month > 12) {
            throw new MonthOutOfRangeException("month " + month + " " + "is out of range!");
        }
        this.setDayOfMonth(this.getDayOfMonth());
        this.month = month;
    }

    @Override
    public int getWeekOfMonth() {
        throw new RuntimeException("not implemented yet!");
    }

    @Override
    public int getWeekOfYear() {
        throw new RuntimeException("not implemented yet!");
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public void setYear(int year) {
        if (year == 0) {
            throw new YearOutOfRangeException("Year 0 is invalid!");
        }
        this.year = year;
    }

    @Override
    public boolean isLeapYear() {
        if (this.year % 400 == 0) {
            return true;
        }
        if (this.year % 100 == 0) {
            return false;
        }
        return this.year % 4 == 0;
    }

    @Override
    public void rollDay(int amount, boolean up) {
        throw new RuntimeException("not implemented yet!");
    }

    @Override
    public void rollMonth(int amount, boolean up) {
        throw new RuntimeException("not implemented yet!");
    }

    @Override
    public void rollYear(int amount, boolean up) {
        throw new RuntimeException("not implemented yet!");
    }

    public boolean equals(CivilDate civilDate) {
        return this.getDayOfMonth() == civilDate.getDayOfMonth() && this.getMonth() == civilDate.getMonth() && this.getYear() == civilDate.getYear();
    }

    @Override
    public CivilDate clone() {
        return new CivilDate(this.getYear(), this.getMonth(), this.getDayOfMonth());
    }
}

