/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.data;

import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import com.nasserkhosravi.appcomponent.AppContext;
import com.nasserkhosravi.appcomponent.ResType;
import com.nasserkhosravi.appcomponent.utils.FileUtils;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0001%B\u0011\b\u0012\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0018\u001a\u00020\u0003H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\b\u0010\u001f\u001a\u00020\u0003H\u0007J\u0006\u0010 \u001a\u00020\nJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0003H\u0016R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u0018\u0010\u0013\u001a\u00020\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\bR\u001c\u0010\u0015\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000e\u00a8\u0006&"}, d2={"Lcom/nasserkhosravi/appcomponent/data/ImageResource;", "Landroid/os/Parcelable;", "resType", "", "(I)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "()V", "assetPath", "", "getAssetPath", "()Ljava/lang/String;", "setAssetPath", "(Ljava/lang/String;)V", "drawableRes", "filePath", "getFilePath", "setFilePath", "resourceType", "resourceType$annotations", "url", "getUrl", "setUrl", "describeContents", "getAsBitmap", "Landroid/graphics/Bitmap;", "getContext", "Landroid/app/Application;", "getDrawable", "Landroid/graphics/drawable/Drawable;", "getType", "getURI", "writeToParcel", "", "dest", "flags", "Companion", "library_release"})
public final class ImageResource
implements Parcelable {
    @Nullable
    private String url;
    @Nullable
    private String assetPath;
    @Nullable
    private String filePath;
    private int drawableRes;
    private int resourceType;
    @NotNull
    private static final Parcelable.Creator<ImageResource> CREATOR;
    public static final Companion Companion;

    @Nullable
    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(@Nullable String string2) {
        this.url = string2;
    }

    @Nullable
    public final String getAssetPath() {
        return this.assetPath;
    }

    public final void setAssetPath(@Nullable String string2) {
        this.assetPath = string2;
    }

    @Nullable
    public final String getFilePath() {
        return this.filePath;
    }

    public final void setFilePath(@Nullable String string2) {
        this.filePath = string2;
    }

    @ResType
    private static /* synthetic */ void resourceType$annotations() {
    }

    @ResType
    public final int getType() {
        return this.resourceType;
    }

    @Nullable
    public final Drawable getDrawable() {
        switch (this.resourceType) {
            case 1: {
                Drawable drawable2 = null;
                try {
                    drawable2 = FileUtils.drawableFromAsset((Context)this.getContext(), this.assetPath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return drawable2;
            }
            case 2: {
                return this.getContext().getDrawable(this.drawableRes);
            }
            case 3: {
                return (Drawable)new BitmapDrawable(this.getContext().getResources(), this.filePath);
            }
            case 0: {
                throw (Throwable)new NotImplementedError("");
            }
        }
        return null;
    }

    @NotNull
    public final Bitmap getAsBitmap() {
        switch (this.resourceType) {
            case 3: {
                Bitmap bitmap = FileUtils.extractBitmap(FileUtils.getFileByName(this.filePath));
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"FileUtils.extractBitmap(\u2026.getFileByName(filePath))");
                return bitmap;
            }
        }
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final String getURI() {
        switch (this.resourceType) {
            case 1: {
                String string2 = this.assetPath;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                return string2;
            }
            case 2: {
                return String.valueOf(this.drawableRes);
            }
            case 3: {
                String string3 = this.filePath;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                return string3;
            }
            case 0: {
                String string4 = this.url;
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                return string4;
            }
        }
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    private final Application getContext() {
        return AppContext.INSTANCE.get();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        dest.writeString(this.url);
        dest.writeString(this.assetPath);
        dest.writeString(this.filePath);
        dest.writeInt(this.drawableRes);
        dest.writeInt(this.resourceType);
    }

    private ImageResource() {
    }

    private ImageResource(@ResType int resType) {
        this();
        this.resourceType = resType;
    }

    public ImageResource(@NotNull Parcel parcel) {
        Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
        this();
        this.url = parcel.readString();
        this.assetPath = parcel.readString();
        this.filePath = parcel.readString();
        this.drawableRes = parcel.readInt();
        this.resourceType = parcel.readInt();
    }

    static {
        Companion = new Companion(null);
        CREATOR = (Parcelable.Creator)new Parcelable.Creator<ImageResource>(){

            @NotNull
            public ImageResource createFromParcel(@NotNull Parcel in) {
                Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
                return new ImageResource(in);
            }

            @NotNull
            public ImageResource[] newArray(int size) {
                return new ImageResource[size];
            }
        };
    }

    public /* synthetic */ ImageResource(@ResType int resType, DefaultConstructorMarker $constructor_marker) {
        this(resType);
    }

    public static final /* synthetic */ int access$getDrawableRes$p(ImageResource $this) {
        return $this.drawableRes;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\nJ\u0010\u0010\u000f\u001a\u00020\u00052\b\b\u0001\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/nasserkhosravi/appcomponent/data/ImageResource$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/nasserkhosravi/appcomponent/data/ImageResource;", "getCREATOR", "()Landroid/os/Parcelable$Creator;", "from", "uri", "", "resourceType", "", "fromAsset", "assetPath", "fromDrawable", "drawableRes", "fromFile", "fullFilePath", "fromWeb", "url", "library_release"})
    public static final class Companion {
        @NotNull
        public final Parcelable.Creator<ImageResource> getCREATOR() {
            return CREATOR;
        }

        @NotNull
        public final ImageResource fromAsset(@NotNull String assetPath) {
            Intrinsics.checkParameterIsNotNull((Object)assetPath, (String)"assetPath");
            ImageResource image = new ImageResource(1, null);
            image.setAssetPath(assetPath);
            return image;
        }

        @NotNull
        public final ImageResource fromWeb(@NotNull String url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            ImageResource image = new ImageResource(0, null);
            image.setUrl(url);
            return image;
        }

        @NotNull
        public final ImageResource fromFile(@NotNull String fullFilePath) {
            Intrinsics.checkParameterIsNotNull((Object)fullFilePath, (String)"fullFilePath");
            ImageResource image = new ImageResource(3, null);
            image.setFilePath(fullFilePath);
            return image;
        }

        @NotNull
        public final ImageResource fromDrawable(@DrawableRes int drawableRes) {
            ImageResource image = new ImageResource(2, null);
            image.drawableRes = drawableRes;
            return image;
        }

        @NotNull
        public final ImageResource from(@NotNull String uri, int resourceType) {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            ImageResource image = new ImageResource(resourceType, null);
            switch (resourceType) {
                case 1: {
                    image.setAssetPath(uri);
                    break;
                }
                case 2: {
                    image.drawableRes = Integer.parseInt(uri);
                    break;
                }
                case 3: {
                    image.setFilePath(uri);
                    break;
                }
                case 0: {
                    image.setUrl(uri);
                }
            }
            return image;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

