package com.nasserkhosravi.appcomponent.utils;

import android.content.res.AssetManager;
import com.nasserkhosravi.appcomponent.AppContext;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertyReader {
    private Properties p;

    public PropertyReader(String fileName) {
        AssetManager assetManager = AppContext.INSTANCE.get().getAssets();
        InputStream inputStream = null;
        p = new Properties();
        try {
            inputStream = assetManager.open(fileName);
            p.load(inputStream);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean getBool(final String key) {
        String property = p.getProperty(key);
        return Boolean.parseBoolean(property);
    }

    public int getInt(final String key) {
        return Integer.parseInt(p.getProperty(key));
    }

    public String getString(final String key) {
        return p.getProperty(key);
    }
}
