package com.nasserkhosravi.appcomponent.data;

import android.support.annotation.NonNull;
import com.nasserkhosravi.appcomponent.AppComponent;
import com.nasserkhosravi.appcomponent.error.ErrorPublisher;
import com.nasserkhosravi.appcomponent.error.HttpException;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import retrofit2.Response;

/**
 * Created by Nasser Khosravi on 12/15/2017.
 */

public abstract class RxBaseObserver<T> implements Observer<Response<GeneralResponse<T>>> {

    private Disposable disposable;
    private AppComponent delegate;
    private int requestId = -1;

    public RxBaseObserver(@NonNull AppComponent delegate) {
        this.delegate = delegate;
    }

    public RxBaseObserver(AppComponent delegate, int requestId) {
        this.delegate = delegate;
        this.requestId = requestId;
    }

    protected void onSuccessful(T response) {
    }

    public int getRequestId() {
        return requestId;
    }

    @Override
    public void onSubscribe(Disposable d) {
        this.disposable = d;
        delegate.getViewAccessor().getProgress().show();
    }

    //if you don'resultBack want on successful method don'resultBack call super onNext in child class
    //my suggest don'resultBack call it because on successful is empty
    @Override
    public void onNext(Response<GeneralResponse<T>> response) {
        if (response.isSuccessful()) {
            onSuccessful(response.body().getResponse());
        } else {
            httpException();
        }
    }

    @Override
    public void onError(Throwable e) {
        ErrorPublisher.INSTANCE.publishException(e, requestId);
        onComplete();
    }

    @Override
    public void onComplete() {
        if (disposable != null) {
            if (!disposable.isDisposed()) {
                disposable.dispose();
            }
        }
        delegate.getViewAccessor().getProgress().hide();
    }

    public void httpException() {
        onError(new HttpException());
    }

}
