package com.nasserkhosravi.appcomponent

import android.content.Context
import android.graphics.drawable.Drawable
import android.support.annotation.*
import android.support.v4.content.ContextCompat

object Res {
    const val WEB = 0
    const val ASSET = 1
    const val DRAWABLE = 2
    const val FILE = 3
}

@IntDef(Res.WEB, Res.ASSET, Res.DRAWABLE, Res.FILE)
annotation class ResType {}

/**
 * Created by Nasser Khosravi on 12/8/2017
 */
interface ResourceComponent {
    val ctx: Context

    fun getStringRes(@StringRes resId: Int): String {
        return ctx.getString(resId)
    }

    @ColorInt
    fun getColorRes(@ColorRes res: Int): Int {
        return ContextCompat.getColor(ctx, res)
    }

    fun getResName(int: Int): String {
        return ResHelper.getResName(int)
    }
}

object ResHelper {

    fun getResName(id: Int): String {
        return AppContext.get().resources.getResourceEntryName(id)
    }

    @ColorInt
    fun getColorRes(@ColorRes res: Int): Int {
        return ContextCompat.getColor(AppContext.get(), res)
    }


    fun getDrawable(@DrawableRes res: Int): Drawable? {
        return ContextCompat.getDrawable(
            AppContext.get(),
            res
        )
    }

}