package com.nasserkhosravi.appcomponent

import android.app.Activity
import android.graphics.PorterDuff
import android.support.annotation.LayoutRes
import android.support.annotation.StringRes
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.RelativeLayout
import android.widget.TextView

import com.nasserkhosravi.appcomponent.utils.DimensUtils
import com.nasserkhosravi.appcomponent.view.NoConnectionView
import com.nasserkhosravi.appcomponent.view.ProgressBuilder
import com.nasserkhosravi.appcomponent.view.ProgressProxy

class BaseViewAccessor internal constructor(
    private val component: AppComponent,
    private val viewGroupManager: BaseViewGroupManager,
    private val config: BaseConfig
) {
    private var tvTitle: TextView? = null
        private set

    lateinit var progress: ProgressProxy
        private set

    private var noConnectionView: NoConnectionView? = null
    private val banView: View? = null

    val toolbar: ViewGroup
        get() = viewGroupManager.viewGroup.findViewById(R.id.ac_toolbarLayout)

    fun constructLayout() {
        if (config.isEnableToolBar) {
            val viewGroup = viewGroupManager.viewGroup
            val toolBarLayout = viewGroup.findViewById<ViewGroup>(R.id.ac_toolbarLayout)
            if (toolBarLayout == null) {
                throw IllegalArgumentException("enable toolbar is true but you did not supply toolbar")
            } else {
                tvTitle = toolBarLayout.findViewById(R.id.ac_tvTitleToolbar)
                if (config.isEnableBackButton) {
                    setupBackButton(toolBarLayout)
                }
            }
        }
        buildProgress()
    }

    private fun setupBackButton(toolBarLayout: ViewGroup) {
        val imgArrowBack = ImageView(toolBarLayout.context)
        imgArrowBack.setImageResource(R.drawable.ac_ic_arrow_back_black_24dp)
        imgArrowBack.setColorFilter(component.getColorRes(R.color.ac_toolbar_child_color), PorterDuff.Mode.SRC_IN)
        val imgLayoutParams =
            RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        imgLayoutParams.addRule(RelativeLayout.ALIGN_PARENT_START)
        imgLayoutParams.addRule(RelativeLayout.CENTER_VERTICAL)
        val px = DimensUtils.dpToPx(10)
        imgArrowBack.setPadding(px, px, px, px)
        imgArrowBack.layoutParams = imgLayoutParams
        imgArrowBack.setOnClickListener { _ -> (component.ctx as Activity).onBackPressed() }
        toolBarLayout.addView(imgArrowBack)
    }

    fun setTitleToolBar(titleToolBar: String) {
        tvTitle!!.text = titleToolBar
    }

    fun setTitleToolBar(@StringRes res: Int) {
        tvTitle!!.setText(res)
    }

    fun buildProgress() {
        if (viewGroupManager.viewGroup.findViewById<View>(R.id.ac_progressView) == null) {
            val view = ProgressBuilder(component.ctx).build()
            progress = ProgressProxy(view, viewGroupManager.viewGroup)
        }
    }

    /**
     * * use this for banning a layout
     * this method dedicated for showing one layout over root layout that provided by main view group.
     * use case: use want see a page and there is no network, you show a dedicated page, and everytime network is available you hide
     * or remove ban view
     */
    fun showBanViewTo(@LayoutRes layoutRes: Int, to: View) {}

    fun hideBanView() {
        banView!!.visibility = View.GONE
    }

    fun getNoConnectionView(): NoConnectionView {
        if (noConnectionView == null) {
            noConnectionView = NoConnectionView(viewGroupManager.viewGroup)
        }
        return noConnectionView!!
    }

}
